/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.TransactionRollbackException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLConnectionTestBase
extends MySQLTestBase {
    Vertx vertx;
    MySQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testTx(TestContext ctx) {
        Async async = ctx.async();
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("BEGIN").execute(ctx.asyncAssertSuccess(result1 -> {
            ctx.assertEquals((Object)0, (Object)result1.size());
            ctx.assertNotNull((Object)result1.iterator());
            conn.query("COMMIT").execute(ctx.asyncAssertSuccess(result2 -> {
                ctx.assertEquals((Object)0, (Object)result2.size());
                async.complete();
            }));
        }))));
    }

    @Test
    public void testTransactionCommit(TestContext ctx) {
        this.testTransactionCommit(ctx, Runnable::run);
    }

    @Test
    public void testTransactionCommitFromAnotherThread(TestContext ctx) {
        this.testTransactionCommit(ctx, t -> new Thread(t).start());
    }

    private void testTransactionCommit(TestContext ctx, Executor exec) {
        Async done = ctx.async();
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> MySQLConnectionTestBase.deleteFromMutableTable(ctx, (SqlClient)conn, () -> exec.execute(() -> conn.begin().onComplete(ctx.asyncAssertSuccess(tx -> {
            AtomicInteger u1 = new AtomicInteger();
            AtomicInteger u2 = new AtomicInteger();
            conn.query("INSERT INTO mutable (id, val) VALUES (1, 'val-1')").execute(ctx.asyncAssertSuccess(res1 -> {
                u1.addAndGet(res1.rowCount());
                exec.execute(() -> conn.query("INSERT INTO mutable (id, val) VALUES (2, 'val-2')").execute(ctx.asyncAssertSuccess(res2 -> {
                    u2.addAndGet(res2.rowCount());
                    exec.execute(() -> tx.commit(ctx.asyncAssertSuccess(v -> {
                        ctx.assertEquals((Object)1, (Object)u1.get());
                        ctx.assertEquals((Object)1, (Object)u2.get());
                        conn.query("SELECT id FROM mutable WHERE id=1 OR id=2").execute(ctx.asyncAssertSuccess(result -> {
                            ctx.assertEquals((Object)2, (Object)result.size());
                            done.complete();
                        }));
                    })));
                })));
            }));
        }))))));
    }

    @Test
    public void testTransactionRollback(TestContext ctx) {
        this.testTransactionRollback(ctx, Runnable::run);
    }

    @Test
    public void testTransactionRollbackFromAnotherThread(TestContext ctx) {
        this.testTransactionRollback(ctx, t -> new Thread(t).start());
    }

    private void testTransactionRollback(TestContext ctx, Executor exec) {
        Async done = ctx.async();
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> MySQLConnectionTestBase.deleteFromMutableTable(ctx, (SqlClient)conn, () -> exec.execute(() -> conn.begin().onComplete(ctx.asyncAssertSuccess(tx -> {
            AtomicInteger u1 = new AtomicInteger();
            AtomicInteger u2 = new AtomicInteger();
            conn.query("INSERT INTO mutable (id, val) VALUES (1, 'val-1')").execute(ctx.asyncAssertSuccess(res1 -> {
                u1.addAndGet(res1.rowCount());
                exec.execute(() -> {});
                conn.query("INSERT INTO mutable (id, val) VALUES (2, 'val-2')").execute(ctx.asyncAssertSuccess(res2 -> {
                    u2.addAndGet(res2.rowCount());
                    exec.execute(() -> tx.rollback(ctx.asyncAssertSuccess(v -> {
                        ctx.assertEquals((Object)1, (Object)u1.get());
                        ctx.assertEquals((Object)1, (Object)u2.get());
                        conn.query("SELECT id FROM mutable WHERE id=1 OR id=2").execute(ctx.asyncAssertSuccess(result -> {
                            ctx.assertEquals((Object)0, (Object)result.size());
                            done.complete();
                        }));
                    })));
                }));
            }));
        }))))));
    }

    @Test
    public void testTransactionAbort(TestContext ctx) {
        Async done = ctx.async(2);
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> MySQLConnectionTestBase.deleteFromMutableTable(ctx, (SqlClient)conn, () -> conn.begin().onComplete(ctx.asyncAssertSuccess(tx -> {
            tx.completion().onComplete(ctx.asyncAssertFailure(err -> {
                ctx.assertEquals((Object)TransactionRollbackException.INSTANCE, err);
                done.countDown();
            }));
            AtomicReference queryAfterFailed = new AtomicReference();
            AtomicReference commit = new AtomicReference();
            conn.query("INSERT INTO mutable (id, val) VALUES (1, 'val-1')").execute(ar1 -> {});
            conn.query("INSERT INTO mutable (id, val) VALUES (1, 'val-2')").execute(ar2 -> {
                ctx.assertNotNull(queryAfterFailed.get());
                ctx.assertTrue(((Boolean)queryAfterFailed.get()).booleanValue());
                ctx.assertNotNull(commit.get());
                ctx.assertTrue(((Boolean)commit.get()).booleanValue());
                ctx.assertTrue(ar2.failed());
                conn.query("SELECT id FROM mutable WHERE id=1").execute(ctx.asyncAssertSuccess(result -> {
                    ctx.assertEquals((Object)0, (Object)result.size());
                    done.complete();
                }));
            });
            conn.query("SELECT id FROM mutable").execute(result -> queryAfterFailed.set(result.failed()));
            tx.commit(result -> commit.set(result.failed()));
        })))));
    }
}

