/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.Repeat;
import io.vertx.ext.unit.junit.RepeatRule;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLPoolTest
extends MySQLTestBase {
    Vertx vertx;
    MySQLConnectOptions options;
    MySQLPool pool;
    @Rule
    public RepeatRule rule = new RepeatRule();

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
        this.pool = MySQLPool.pool((Vertx)this.vertx, (MySQLConnectOptions)this.options, (PoolOptions)new PoolOptions());
    }

    @After
    public void tearDown(TestContext ctx) {
        if (this.pool != null) {
            this.pool.close();
        }
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testContinuouslyConnecting(TestContext ctx) {
        Async async = ctx.async(3);
        this.pool.getConnection(ctx.asyncAssertSuccess(conn1 -> async.countDown()));
        this.pool.getConnection(ctx.asyncAssertSuccess(conn2 -> async.countDown()));
        this.pool.getConnection(ctx.asyncAssertSuccess(conn3 -> async.countDown()));
        async.await();
    }

    @Test
    public void testContinuouslyQuery(TestContext ctx) {
        Async async = ctx.async(3);
        this.pool.preparedQuery("SELECT 1").execute(ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)1, (Object)res1.size());
            async.countDown();
        }));
        this.pool.preparedQuery("SELECT 2").execute(ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)1, (Object)res1.size());
            async.countDown();
        }));
        this.pool.preparedQuery("SELECT 3").execute(ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)1, (Object)res1.size());
            async.countDown();
        }));
        async.await();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentMultipleConnection(TestContext ctx) {
        PoolOptions poolOptions = new PoolOptions().setMaxSize(2);
        try (MySQLPool pool = MySQLPool.pool((Vertx)this.vertx, (MySQLConnectOptions)new MySQLConnectOptions(this.options).setCachePreparedStatements(false), (PoolOptions)poolOptions);){
            int numRequests = 1500;
            Async async = ctx.async(numRequests);
            for (int i = 0; i < numRequests; ++i) {
                pool.preparedQuery("SELECT * FROM Fortune WHERE id=?").execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(results -> {
                    ctx.assertEquals((Object)1, (Object)results.size());
                    Tuple row = (Tuple)results.iterator().next();
                    ctx.assertEquals((Object)1, (Object)row.getInteger(0));
                    ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString(1));
                    async.countDown();
                }));
            }
            async.awaitSuccess(10000L);
        }
    }

    @Test
    public void testBorrowedPooledConnectionClosedByServer(TestContext ctx) {
        Async async = ctx.async();
        PoolOptions poolOptions = new PoolOptions().setMaxSize(1);
        MySQLPool pool = MySQLPool.pool((Vertx)this.vertx, (MySQLConnectOptions)new MySQLConnectOptions(this.options).setCachePreparedStatements(false), (PoolOptions)poolOptions);
        pool.getConnection(ctx.asyncAssertSuccess(conn -> conn.query("SET SESSION wait_timeout=3;").execute(ctx.asyncAssertSuccess(wait -> this.vertx.setTimer(5000L, id -> conn.query("SELECT 'vertx'").execute(ctx.asyncAssertFailure(err -> {
            ctx.assertEquals((Object)"Connection is not active now, current status: CLOSED", (Object)err.getMessage());
            conn.close();
            pool.query("SELECT 'mysql'").execute(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)1, (Object)res.size());
                Row row = (Row)res.iterator().next();
                ctx.assertEquals((Object)"mysql", (Object)row.getString(0));
                async.complete();
            }));
        })))))));
    }

    @Test
    public void testPooledConnectionClosedByServer(TestContext ctx) {
        Async async = ctx.async();
        PoolOptions poolOptions = new PoolOptions().setMaxSize(1);
        MySQLPool pool = MySQLPool.pool((Vertx)this.vertx, (MySQLConnectOptions)new MySQLConnectOptions(this.options).setCachePreparedStatements(false), (PoolOptions)poolOptions);
        pool.getConnection(ctx.asyncAssertSuccess(conn -> conn.query("SET SESSION wait_timeout=3;").execute(ctx.asyncAssertSuccess(wait -> {
            conn.close();
            this.vertx.setTimer(5000L, id -> pool.query("SELECT 'vertx'").execute(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)1, (Object)res.size());
                Row row = (Row)res.iterator().next();
                ctx.assertEquals((Object)"vertx", (Object)row.getString(0));
                async.complete();
            })));
        }))));
    }

    @Test
    @Repeat(value=50)
    public void testNoConnectionLeaks(TestContext ctx) {
        Tuple params = Tuple.of((Object)this.options.getUser(), (Object)this.options.getDatabase());
        Async killConnections = ctx.async();
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            String sql = "SELECT ID FROM INFORMATION_SCHEMA.PROCESSLIST WHERE ID <> CONNECTION_ID() AND User = ? AND db = ?";
            Collector collector = Collectors.mapping(row -> row.getInteger(0), Collectors.toList());
            conn.preparedQuery(sql).collecting(collector).execute(params, ctx.asyncAssertSuccess(ids -> {
                CompositeFuture killAll = ((List)ids.value()).stream().map(connId -> conn.query("KILL " + connId).execute()).collect(Collectors.collectingAndThen(Collectors.toList(), CompositeFuture::all));
                killAll.compose(cf -> conn.close()).onComplete(ctx.asyncAssertSuccess(v -> killConnections.complete()));
            }));
        }));
        killConnections.awaitSuccess();
        String sql = "SELECT CONNECTION_ID() AS cid, (SELECT count(*) FROM INFORMATION_SCHEMA.PROCESSLIST WHERE User = ? AND db = ?) AS cnt";
        int idleTimeout = 50;
        PoolOptions poolOptions = new PoolOptions().setMaxSize(1).setIdleTimeout(idleTimeout).setIdleTimeoutUnit(TimeUnit.MILLISECONDS).setPoolCleanerPeriod(5);
        this.pool = MySQLPool.pool((MySQLConnectOptions)this.options, (PoolOptions)poolOptions);
        Async async = ctx.async();
        AtomicInteger cid = new AtomicInteger();
        this.vertx.getOrCreateContext().runOnContext(v -> this.pool.preparedQuery(sql).execute(params, ctx.asyncAssertSuccess(rs1 -> {
            Row row1 = (Row)rs1.iterator().next();
            cid.set(row1.getInteger("cid"));
            ctx.assertEquals((Object)1, (Object)row1.getInteger("cnt"));
            this.vertx.setTimer((long)(2 * idleTimeout), l -> this.pool.preparedQuery(sql).execute(params, ctx.asyncAssertSuccess(rs2 -> {
                Row row2 = (Row)rs2.iterator().next();
                ctx.assertEquals((Object)1, (Object)row2.getInteger("cnt"));
                ctx.assertNotEquals((Object)cid.get(), (Object)row2.getInteger("cid"));
                async.complete();
            })));
        })));
        async.awaitSuccess();
    }
}

