/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnection;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLPooledConnectionTest
extends MySQLTestBase {
    Vertx vertx;
    MySQLConnectOptions options;
    MySQLPool pool;
    Consumer<Handler<AsyncResult<SqlConnection>>> connector;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
        this.pool = MySQLPool.pool((Vertx)this.vertx, (MySQLConnectOptions)this.options, (PoolOptions)new PoolOptions());
        this.connector = handler -> {
            if (this.pool == null) {
                this.pool = MySQLPool.pool((Vertx)this.vertx, (MySQLConnectOptions)this.options, (PoolOptions)new PoolOptions().setMaxSize(1));
            }
            this.pool.getConnection(handler);
        };
    }

    @After
    public void tearDown(TestContext ctx) {
        if (this.pool != null) {
            this.pool.close();
        }
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testTransactionRollbackUnfinishedOnRecycle(TestContext ctx) {
        String txnIdSql = "SELECT tx.trx_id FROM information_schema.innodb_trx tx WHERE tx.trx_mysql_thread_id = connection_id()";
        Async done = ctx.async(2);
        this.connector.accept((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn1 -> MySQLPooledConnectionTest.deleteFromMutableTable(ctx, (SqlClient)conn1, () -> {
            conn1.begin();
            conn1.query("INSERT INTO mutable (id, val) VALUES (5, 'some-value')").execute(ctx.asyncAssertSuccess());
            conn1.query(txnIdSql).execute(ctx.asyncAssertSuccess(result -> {
                Object txid1 = ((Row)result.iterator().next()).getValue(0);
                conn1.close();
                this.connector.accept((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn2 -> {
                    conn2.query("SELECT id FROM mutable WHERE id=5").execute(ctx.asyncAssertSuccess(result2 -> {
                        ctx.assertEquals((Object)0, (Object)result2.size());
                        done.countDown();
                    }));
                    conn2.query(txnIdSql).execute(ctx.asyncAssertSuccess(result2 -> {
                        Object txid2 = ((Row)result.iterator().next()).getValue(0);
                        ctx.assertEquals(txid1, txid2);
                        done.countDown();
                    }));
                }));
            }));
        })));
    }

    @Test
    public void testQueryConstantWithCursor(TestContext ctx) {
        this.connector.accept((Handler<AsyncResult<SqlConnection>>)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT 1").onComplete(ctx.asyncAssertSuccess(ps -> {
            Cursor cursor = ps.cursor();
            cursor.read(1024).onComplete(ctx.asyncAssertSuccess(result -> {
                ctx.assertEquals((Object)1, (Object)result.size());
                Row row = (Row)result.iterator().next();
                ctx.assertEquals((Object)1, (Object)row.getInteger(0));
            }));
        }))));
    }
}

