/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLException;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLPreparedStatementTest
extends MySQLTestBase {
    Vertx vertx;
    MySQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testContinuousPreparedQueriesWithSameTypeParameters(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT id, message FROM immutable WHERE id = ? AND message = ?", ctx.asyncAssertSuccess(preparedQuery -> preparedQuery.query().execute(Tuple.of((Object)1, (Object)"fortune: No such file or directory"), ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)1, (Object)res1.size());
            preparedQuery.query().execute(Tuple.of((Object)4, (Object)"After enough decimal places, nobody gives a damn."), ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)0, (Object)res2.size());
                conn.close();
            }));
        }))))));
    }

    @Test
    public void testContinuousPreparedQueriesWithDifferentTypeParameters(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.prepare("SELECT id, message FROM immutable WHERE id = ? AND message = ?", ctx.asyncAssertSuccess(preparedQuery -> preparedQuery.query().execute(Tuple.of((Object)"1", (Object)"fortune: No such file or directory"), ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)1, (Object)res1.size());
            preparedQuery.query().execute(Tuple.of((Object)4, (Object)"A bad random number generator: 1, 1, 1, 1, 1, 4.33e+67, 1, 1, 1"), ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)1, (Object)res2.size());
                conn.close();
            }));
        }))))));
    }

    @Test
    public void testContinuousOneShotPreparedQueriesWithDifferentTypeParameters(TestContext ctx) {
        this.options.setCachePreparedStatements(true);
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT id, message FROM immutable WHERE id = ?").execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)1, (Object)res1.size());
            Row row = (Row)res1.iterator().next();
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString("message"));
            conn.preparedQuery("SELECT id, message FROM immutable WHERE id = ?").execute(Tuple.of((Object)"3"), ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)1, (Object)res2.size());
                Row row2 = (Row)res2.iterator().next();
                ctx.assertEquals((Object)"After enough decimal places, nobody gives a damn.", (Object)row2.getString("message"));
                conn.close();
            }));
        }))));
    }

    @Test
    public void testContinuousOneShotPreparedQueriesWithBindingFailure(TestContext ctx) {
        this.options.setCachePreparedStatements(true);
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT id, message FROM immutable WHERE id = ?").execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)1, (Object)res1.size());
            Row row = (Row)res1.iterator().next();
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString("message"));
            conn.preparedQuery("SELECT id, message FROM immutable WHERE id = ?").execute(Tuple.of((Object)3, (Object)"USELESS PARAM"), ctx.asyncAssertFailure(err -> {
                ctx.assertEquals((Object)"The number of parameters to execute should be consistent with the expected number of parameters = [1] but the actual number is [2].", (Object)err.getMessage());
                conn.query("SELECT 1").execute(ctx.asyncAssertSuccess(check -> conn.close()));
            }));
        }))));
    }

    @Test
    public void testContinuousOneShotPreparedBatchWithBindingFailure(TestContext ctx) {
        this.options.setCachePreparedStatements(true);
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT id, message FROM immutable WHERE id = ?").execute(Tuple.of((Object)1), ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)1, (Object)res1.size());
            Row row = (Row)res1.iterator().next();
            ctx.assertEquals((Object)"fortune: No such file or directory", (Object)row.getString("message"));
            conn.preparedQuery("SELECT id, message FROM immutable WHERE id = ?").executeBatch(Arrays.asList(Tuple.of((Object)3), Tuple.of((Object)4, (Object)"USELESS PARAM"), Tuple.of((Object)6)), ctx.asyncAssertFailure(err -> {
                ctx.assertEquals((Object)"The number of parameters to execute should be consistent with the expected number of parameters = [1] but the actual number is [2].", (Object)err.getMessage());
                conn.query("SELECT 1").execute(ctx.asyncAssertSuccess(check -> conn.close()));
            }));
        }))));
    }

    @Test
    public void testMaxPreparedStatementEviction(TestContext ctx) {
        this.testPreparedStatements(ctx, new MySQLConnectOptions(this.options).setCachePreparedStatements(true).setPreparedStatementCacheMaxSize(16), 128, 16);
    }

    @Test
    public void testOneShotPreparedStatements(TestContext ctx) {
        this.testPreparedStatements(ctx, new MySQLConnectOptions(this.options).setCachePreparedStatements(false), 128, 0);
    }

    private void testPreparedStatements(TestContext ctx, MySQLConnectOptions options, int num, int expected) {
        Assume.assumeFalse((MySQLTestBase.rule.isUsingMySQL5_6() || MySQLTestBase.rule.isUsingMariaDB() ? 1 : 0) != 0);
        Async async = ctx.async();
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)options.setUser("root").setPassword("password"), (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT * FROM performance_schema.prepared_statements_instances").execute(ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)0, (Object)res1.size());
            AtomicInteger count = new AtomicInteger(num);
            for (int i = 0; i < num; ++i) {
                int val = i;
                conn.preparedQuery("SELECT " + i).execute(Tuple.tuple(), ctx.asyncAssertSuccess(res2 -> {
                    ctx.assertEquals((Object)1, (Object)res2.size());
                    ctx.assertEquals((Object)val, (Object)((Row)res2.iterator().next()).getInteger(0));
                    if (count.decrementAndGet() == 0) {
                        ctx.assertEquals((Object)(num - 1), (Object)val);
                        conn.query("SELECT * FROM performance_schema.prepared_statements_instances").execute(ctx.asyncAssertSuccess(res3 -> {
                            ctx.assertEquals((Object)expected, (Object)res3.size());
                            conn.close(ctx.asyncAssertSuccess(v -> async.complete()));
                        }));
                    }
                }));
            }
        }))));
    }

    @Test
    public void testPreparedStatementCleaned(TestContext ctx) {
        Assume.assumeFalse((MySQLTestBase.rule.isUsingMySQL5_6() || MySQLTestBase.rule.isUsingMariaDB() ? 1 : 0) != 0);
        MySQLConnectOptions connectOptions = new MySQLConnectOptions(this.options).setUser("root").setPassword("password").setCachePreparedStatements(false);
        Async async = ctx.async();
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)connectOptions, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT * FROM performance_schema.prepared_statements_instances").execute(ctx.asyncAssertSuccess(res1 -> {
            ctx.assertEquals((Object)0, (Object)res1.size());
            conn.preparedQuery("INSERT INTO duplicate_test VALUES (?)").execute(Tuple.of((Object)1), ctx.asyncAssertFailure(failure -> {
                if (!(failure instanceof MySQLException)) {
                    ctx.fail(failure);
                    return;
                }
                MySQLException e = (MySQLException)failure;
                ctx.assertEquals((Object)1062, (Object)e.getErrorCode());
                ctx.assertEquals((Object)"23000", (Object)e.getSqlState());
                conn.query("SELECT * FROM performance_schema.prepared_statements_instances").execute(ctx.asyncAssertSuccess(res2 -> {
                    ctx.assertEquals((Object)0, (Object)res2.size());
                    conn.close(ctx.asyncAssertSuccess(v -> async.complete()));
                }));
            }));
        }))));
    }
}

