/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.file.FileSystem;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLClient;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLQueryTest
extends MySQLTestBase {
    Vertx vertx;
    MySQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testLastInsertIdWithDefaultValue(TestContext ctx) {
        PropertyKind property = PropertyKind.create((String)"last-inserted-id", Long.class);
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("CREATE TEMPORARY TABLE last_insert_id(id INTEGER PRIMARY KEY AUTO_INCREMENT, val VARCHAR(20));").execute(ctx.asyncAssertSuccess(createTableResult -> {
            Long lastInsertId1 = (Long)createTableResult.property(property);
            ctx.assertNull((Object)lastInsertId1);
            conn.query("INSERT INTO last_insert_id(val) VALUES('test')").execute(ctx.asyncAssertSuccess(insertResult1 -> {
                Long lastInsertId2 = (Long)insertResult1.property(property);
                ctx.assertEquals((Object)1L, (Object)lastInsertId2);
                conn.query("INSERT INTO last_insert_id(val) VALUES('test2')").execute(ctx.asyncAssertSuccess(insertResult2 -> {
                    Long lastInsertId3 = (Long)insertResult2.property(property);
                    ctx.assertEquals((Object)2L, (Object)lastInsertId3);
                    conn.close();
                }));
            }));
        }))));
    }

    @Test
    public void testLastInsertIdWithSpecifiedValue(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("CREATE TEMPORARY TABLE last_insert_id(id INTEGER PRIMARY KEY AUTO_INCREMENT, val VARCHAR(20));").execute(ctx.asyncAssertSuccess(createTableResult -> {
            Long lastInsertId1 = (Long)createTableResult.property(MySQLClient.LAST_INSERTED_ID);
            ctx.assertNull((Object)lastInsertId1);
            conn.query("ALTER TABLE last_insert_id AUTO_INCREMENT=1234").execute(ctx.asyncAssertSuccess(alterTableResult -> {
                Long lastInsertId2 = (Long)createTableResult.property(MySQLClient.LAST_INSERTED_ID);
                ctx.assertNull((Object)lastInsertId2);
                conn.query("INSERT INTO last_insert_id(val) VALUES('test')").execute(ctx.asyncAssertSuccess(insertResult1 -> {
                    Long lastInsertId3 = (Long)insertResult1.property(MySQLClient.LAST_INSERTED_ID);
                    ctx.assertEquals((Object)1234L, (Object)lastInsertId3);
                    conn.query("INSERT INTO last_insert_id(val) VALUES('test2')").execute(ctx.asyncAssertSuccess(insertResult2 -> {
                        Long lastInsertId4 = (Long)insertResult2.property(MySQLClient.LAST_INSERTED_ID);
                        ctx.assertEquals((Object)1235L, (Object)lastInsertId4);
                        conn.close();
                    }));
                }));
            }));
        }))));
    }

    @Test
    public void testCachePreparedStatementWithDifferentSql(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options.setCachePreparedStatements(true).setPreparedStatementCacheMaxSize(1024), (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SHOW VARIABLES LIKE 'max_prepared_stmt_count'").execute(ctx.asyncAssertSuccess(res1 -> {
            Row row = (Row)res1.iterator().next();
            int maxPreparedStatementCount = Integer.parseInt(row.getString(1));
            ctx.assertEquals((Object)"max_prepared_stmt_count", (Object)row.getString(0));
            ctx.assertEquals((Object)1024, (Object)maxPreparedStatementCount);
            for (int i = 0; i < 1280; ++i) {
                String value = "value-" + i;
                for (int j = 0; j < 2; ++j) {
                    conn.preparedQuery("SELECT '" + value + "'").execute(ctx.asyncAssertSuccess(res2 -> ctx.assertEquals((Object)value, (Object)((Row)res2.iterator().next()).getString(0))));
                }
            }
        }))));
    }

    @Test
    public void testCachePreparedStatementWithSameSql(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options.setCachePreparedStatements(true), (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SHOW VARIABLES LIKE 'max_prepared_stmt_count'").execute(ctx.asyncAssertSuccess(res1 -> {
            Row row = (Row)res1.iterator().next();
            int maxPreparedStatementCount = Integer.parseInt(row.getString(1));
            ctx.assertEquals((Object)"max_prepared_stmt_count", (Object)row.getString(0));
            ctx.assertEquals((Object)1024, (Object)maxPreparedStatementCount);
            for (int i = 0; i < 2000; ++i) {
                conn.preparedQuery("SELECT 'test'").execute(ctx.asyncAssertSuccess(res2 -> ctx.assertEquals((Object)"test", (Object)((Row)res2.iterator().next()).getString(0))));
            }
        }))));
    }

    @Test
    public void testCachePreparedStatementBatchWithSameSql(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options.setCachePreparedStatements(true), (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SHOW VARIABLES LIKE 'max_prepared_stmt_count'").execute(ctx.asyncAssertSuccess(res1 -> {
            Row row = (Row)res1.iterator().next();
            int maxPreparedStatementCount = Integer.parseInt(row.getString(1));
            ctx.assertEquals((Object)"max_prepared_stmt_count", (Object)row.getString(0));
            ctx.assertEquals((Object)1024, (Object)maxPreparedStatementCount);
            for (int i = 0; i < 2000; ++i) {
                int val = i * 1000;
                ArrayList<Tuple> tuples = new ArrayList<Tuple>();
                tuples.add(Tuple.of((Object)val));
                tuples.add(Tuple.of((Object)(val + 1)));
                conn.preparedQuery("Select cast(? AS CHAR)").executeBatch(tuples, ctx.asyncAssertSuccess(res2 -> {
                    String v1 = ((Row)res2.iterator().next()).getString(0);
                    String v2 = ((Row)res2.next().iterator().next()).getString(0);
                    ctx.assertEquals((Object)("" + val), (Object)v1);
                    ctx.assertEquals((Object)("" + (val + 1)), (Object)v2);
                }));
            }
        }))));
    }

    @Test
    public void testAutoClosingNonCacheOneShotPreparedQueryStatement(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options.setCachePreparedStatements(false), (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SHOW VARIABLES LIKE 'max_prepared_stmt_count'").execute(ctx.asyncAssertSuccess(res1 -> {
            Row row = (Row)res1.iterator().next();
            int maxPreparedStatementCount = Integer.parseInt(row.getString(1));
            ctx.assertEquals((Object)"max_prepared_stmt_count", (Object)row.getString(0));
            ctx.assertEquals((Object)1024, (Object)maxPreparedStatementCount);
            for (int i = 0; i < 2000; ++i) {
                conn.preparedQuery("SELECT 'test'").execute(ctx.asyncAssertSuccess(res2 -> ctx.assertEquals((Object)"test", (Object)((Row)res2.iterator().next()).getString(0))));
            }
        }))));
    }

    @Test
    public void testAutoClosingNonCacheOneShotPreparedBatchStatement(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options.setCachePreparedStatements(false), (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SHOW VARIABLES LIKE 'max_prepared_stmt_count'").execute(ctx.asyncAssertSuccess(res0 -> {
            Row row = (Row)res0.iterator().next();
            int maxPreparedStatementCount = Integer.parseInt(row.getString(1));
            ctx.assertEquals((Object)"max_prepared_stmt_count", (Object)row.getString(0));
            ctx.assertEquals((Object)1024, (Object)maxPreparedStatementCount);
            for (int i = 0; i < 2000; ++i) {
                List<Tuple> params = Arrays.asList(Tuple.of((Object)1), Tuple.of((Object)2), Tuple.of((Object)3));
                conn.preparedQuery("SELECT CAST(? AS CHAR)").executeBatch(params, ctx.asyncAssertSuccess(res1 -> {
                    ctx.assertEquals((Object)"1", (Object)((Row)res1.iterator().next()).getString(0));
                    RowSet res2 = res1.next();
                    ctx.assertEquals((Object)"2", (Object)((Row)res2.iterator().next()).getString(0));
                    RowSet res3 = res2.next();
                    ctx.assertEquals((Object)"3", (Object)((Row)res3.iterator().next()).getString(0));
                }));
            }
        }))));
    }

    @Test
    public void testDecodePacketSizeMoreThan16MB(TestContext ctx) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 4000000; ++i) {
            sb.append("abcde");
        }
        String expected = sb.toString();
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT REPEAT('abcde', 4000000)").execute(ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)1, (Object)rowSet.size());
            Row row = (Row)rowSet.iterator().next();
            ctx.assertTrue(row.getString(0).getBytes().length > 0xFFFFFF);
            ctx.assertEquals((Object)expected, row.getValue(0));
            ctx.assertEquals((Object)expected, (Object)row.getString(0));
            conn.close();
        }))));
    }

    @Test
    public void testEncodePacketSizeMoreThan16MB(TestContext ctx) {
        Assume.assumeFalse((boolean)rule.isUsingMySQL5_6());
        int dataSize = 0x1400000;
        byte[] data = new byte[dataSize];
        ThreadLocalRandom.current().nextBytes(data);
        Buffer buffer = Buffer.buffer((byte[])data);
        ctx.assertTrue(buffer.length() > 0xFFFFFF);
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("UPDATE datatype SET `LongBlob` = ? WHERE id = 2").execute(Tuple.of((Object)buffer), ctx.asyncAssertSuccess(v -> conn.preparedQuery("SELECT id, `LongBlob` FROM datatype WHERE id = 2").execute(ctx.asyncAssertSuccess(rowSet -> {
            Row row = (Row)rowSet.iterator().next();
            ctx.assertEquals((Object)2, (Object)row.getInteger(0));
            ctx.assertEquals((Object)2, (Object)row.getInteger("id"));
            ctx.assertEquals((Object)buffer, (Object)row.getBuffer(1));
            ctx.assertEquals((Object)buffer, (Object)row.getBuffer("LongBlob"));
            conn.close();
        }))))));
    }

    @Test
    public void testLocalInfileRequest(TestContext ctx) {
        FileSystem fileSystem = this.vertx.fileSystem();
        Buffer fileData = Buffer.buffer();
        for (int i = 0; i < 10000; ++i) {
            fileData.appendString("Fluffy,Harold,cat,f,1993-02-04,NULL").appendString("\n").appendString("Bowser,Diane,dog,m,1979-08-31,1995-07-29").appendString("\n").appendString("Whistler,Gwen,bird,NULL,1997-12-09,NULL").appendString("\n");
        }
        fileSystem.createTempFile(null, null, ctx.asyncAssertSuccess(filename -> fileSystem.writeFile(filename, fileData, ctx.asyncAssertSuccess(write -> MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("TRUNCATE TABLE localinfile").execute(ctx.asyncAssertSuccess(cleanup -> conn.query("LOAD DATA LOCAL INFILE '" + filename + "' INTO TABLE localinfile FIELDS TERMINATED BY ',' ENCLOSED BY '\"' LINES TERMINATED BY '\\n';").execute(ctx.asyncAssertSuccess(v -> conn.query("SELECT * FROM localinfile").execute(ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)30000, (Object)rowSet.size());
            RowIterator iterator = rowSet.iterator();
            for (int i = 0; i < 10000; ++i) {
                Row row1 = (Row)iterator.next();
                ctx.assertEquals((Object)"Fluffy", row1.getValue(0));
                ctx.assertEquals((Object)"Harold", row1.getValue(1));
                ctx.assertEquals((Object)"cat", row1.getValue(2));
                ctx.assertEquals((Object)"f", row1.getValue(3));
                ctx.assertEquals((Object)LocalDate.of(1993, 2, 4), row1.getValue(4));
                ctx.assertEquals(null, row1.getValue(5));
                Row row2 = (Row)iterator.next();
                ctx.assertEquals((Object)"Bowser", row2.getValue(0));
                ctx.assertEquals((Object)"Diane", row2.getValue(1));
                ctx.assertEquals((Object)"dog", row2.getValue(2));
                ctx.assertEquals((Object)"m", row2.getValue(3));
                ctx.assertEquals((Object)LocalDate.of(1979, 8, 31), row2.getValue(4));
                ctx.assertEquals((Object)LocalDate.of(1995, 7, 29), row2.getValue(5));
                Row row3 = (Row)iterator.next();
                ctx.assertEquals((Object)"Whistler", row3.getValue(0));
                ctx.assertEquals((Object)"Gwen", row3.getValue(1));
                ctx.assertEquals((Object)"bird", row3.getValue(2));
                ctx.assertEquals(null, row3.getValue(3));
                ctx.assertEquals((Object)LocalDate.of(1997, 12, 9), row3.getValue(4));
                ctx.assertEquals(null, row3.getValue(5));
            }
            conn.close();
        }))))))))))));
    }

    @Test
    public void testLocalInfileRequestEmptyFile(TestContext ctx) {
        FileSystem fileSystem = this.vertx.fileSystem();
        Buffer fileData = Buffer.buffer();
        fileSystem.createTempFile(null, null, ctx.asyncAssertSuccess(filename -> fileSystem.writeFile(filename, fileData, ctx.asyncAssertSuccess(write -> MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("TRUNCATE TABLE localinfile").execute(ctx.asyncAssertSuccess(cleanup -> conn.query("LOAD DATA LOCAL INFILE '" + filename + "' INTO TABLE localinfile FIELDS TERMINATED BY ',' ENCLOSED BY '\"' LINES TERMINATED BY '\\n';").execute(ctx.asyncAssertSuccess(v -> conn.query("SELECT * FROM localinfile").execute(ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)0, (Object)rowSet.size());
            conn.close();
        }))))))))))));
    }

    @Test
    public void testLocalInfileRequestInPackets(TestContext ctx) {
        FileSystem fileSystem = this.vertx.fileSystem();
        Buffer fileData = Buffer.buffer();
        for (int i = 0; i < 200000; ++i) {
            fileData.appendString("Fluffy,Harold,cat,f,1993-02-04,NULL").appendString("\n").appendString("Bowser,Diane,dog,m,1979-08-31,1995-07-29").appendString("\n").appendString("Whistler,Gwen,bird,NULL,1997-12-09,NULL").appendString("\n");
        }
        ctx.assertTrue(fileData.length() > 0xFFFFFF);
        fileSystem.createTempFile(null, null, ctx.asyncAssertSuccess(filename -> fileSystem.writeFile(filename, fileData, ctx.asyncAssertSuccess(write -> MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("TRUNCATE TABLE localinfile").execute(ctx.asyncAssertSuccess(cleanup -> conn.query("LOAD DATA LOCAL INFILE '" + filename + "' INTO TABLE localinfile FIELDS TERMINATED BY ',' ENCLOSED BY '\"' LINES TERMINATED BY '\\n';").execute(ctx.asyncAssertSuccess(v -> conn.query("SELECT * FROM localinfile").execute(ctx.asyncAssertSuccess(rowSet -> {
            ctx.assertEquals((Object)600000, (Object)rowSet.size());
            RowIterator iterator = rowSet.iterator();
            for (int i = 0; i < 200000; ++i) {
                Row row1 = (Row)iterator.next();
                ctx.assertEquals((Object)"Fluffy", row1.getValue(0));
                ctx.assertEquals((Object)"Harold", row1.getValue(1));
                ctx.assertEquals((Object)"cat", row1.getValue(2));
                ctx.assertEquals((Object)"f", row1.getValue(3));
                ctx.assertEquals((Object)LocalDate.of(1993, 2, 4), row1.getValue(4));
                ctx.assertEquals(null, row1.getValue(5));
                Row row2 = (Row)iterator.next();
                ctx.assertEquals((Object)"Bowser", row2.getValue(0));
                ctx.assertEquals((Object)"Diane", row2.getValue(1));
                ctx.assertEquals((Object)"dog", row2.getValue(2));
                ctx.assertEquals((Object)"m", row2.getValue(3));
                ctx.assertEquals((Object)LocalDate.of(1979, 8, 31), row2.getValue(4));
                ctx.assertEquals((Object)LocalDate.of(1995, 7, 29), row2.getValue(5));
                Row row3 = (Row)iterator.next();
                ctx.assertEquals((Object)"Whistler", row3.getValue(0));
                ctx.assertEquals((Object)"Gwen", row3.getValue(1));
                ctx.assertEquals((Object)"bird", row3.getValue(2));
                ctx.assertEquals(null, row3.getValue(3));
                ctx.assertEquals((Object)LocalDate.of(1997, 12, 9), row3.getValue(4));
                ctx.assertEquals(null, row3.getValue(5));
            }
            conn.close();
        }))))))))))));
    }
}

