/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.mysqlclient.impl.MySQLDatabaseMetadata;
import org.junit.Assert;
import org.junit.Test;

public class MySQLServerVersionParserTest {
    private MySQLDatabaseMetadata actual;

    @Test
    public void testMySQL_V8_0() {
        this.actual = MySQLDatabaseMetadata.parse((String)"8.0.19");
        Assert.assertEquals((Object)"8.0.19", (Object)this.actual.fullVersion());
        Assert.assertEquals((Object)"MySQL", (Object)this.actual.productName());
        Assert.assertEquals((long)8L, (long)this.actual.majorVersion());
        Assert.assertEquals((long)0L, (long)this.actual.minorVersion());
        Assert.assertEquals((long)19L, (long)this.actual.microVersion());
    }

    @Test
    public void testMySQL_V5_7() {
        this.actual = MySQLDatabaseMetadata.parse((String)"5.7.29");
        Assert.assertEquals((Object)"5.7.29", (Object)this.actual.fullVersion());
        Assert.assertEquals((Object)"MySQL", (Object)this.actual.productName());
        Assert.assertEquals((long)5L, (long)this.actual.majorVersion());
        Assert.assertEquals((long)7L, (long)this.actual.minorVersion());
        Assert.assertEquals((long)29L, (long)this.actual.microVersion());
    }

    @Test
    public void testMySQL_LOG() {
        this.actual = MySQLDatabaseMetadata.parse((String)"5.7.29-log");
        Assert.assertEquals((Object)"5.7.29-log", (Object)this.actual.fullVersion());
        Assert.assertEquals((Object)"MySQL", (Object)this.actual.productName());
        Assert.assertEquals((long)5L, (long)this.actual.majorVersion());
        Assert.assertEquals((long)7L, (long)this.actual.minorVersion());
        Assert.assertEquals((long)29L, (long)this.actual.microVersion());
    }

    @Test
    public void testMariaDB_V10_5() {
        this.actual = MySQLDatabaseMetadata.parse((String)"5.5.5-10.5.3-MariaDB-1:10.5.3+maria~bionic");
        Assert.assertEquals((Object)"5.5.5-10.5.3-MariaDB-1:10.5.3+maria~bionic", (Object)this.actual.fullVersion());
        Assert.assertEquals((Object)"MariaDB", (Object)this.actual.productName());
        Assert.assertEquals((long)10L, (long)this.actual.majorVersion());
        Assert.assertEquals((long)5L, (long)this.actual.minorVersion());
        Assert.assertEquals((long)3L, (long)this.actual.microVersion());
    }

    @Test
    public void testMariaDB_V10_1() {
        this.actual = MySQLDatabaseMetadata.parse((String)"5.5.5-10.1.45-MariaDB-1~bionic");
        Assert.assertEquals((Object)"5.5.5-10.1.45-MariaDB-1~bionic", (Object)this.actual.fullVersion());
        Assert.assertEquals((Object)"MariaDB", (Object)this.actual.productName());
        Assert.assertEquals((long)10L, (long)this.actual.majorVersion());
        Assert.assertEquals((long)1L, (long)this.actual.minorVersion());
        Assert.assertEquals((long)45L, (long)this.actual.microVersion());
    }

    @Test
    public void testPercona_V8_0() {
        this.actual = MySQLDatabaseMetadata.parse((String)"8.0.19-10");
        Assert.assertEquals((Object)"8.0.19-10", (Object)this.actual.fullVersion());
        Assert.assertEquals((Object)"MySQL", (Object)this.actual.productName());
        Assert.assertEquals((long)8L, (long)this.actual.majorVersion());
        Assert.assertEquals((long)0L, (long)this.actual.minorVersion());
        Assert.assertEquals((long)19L, (long)this.actual.microVersion());
    }

    @Test
    public void testTiDB_V3() {
        this.actual = MySQLDatabaseMetadata.parse((String)"5.7.25-TiDB-v3.0.14");
        Assert.assertEquals((Object)"5.7.25-TiDB-v3.0.14", (Object)this.actual.fullVersion());
        Assert.assertEquals((Object)"MySQL", (Object)this.actual.productName());
        Assert.assertEquals((long)5L, (long)this.actual.majorVersion());
        Assert.assertEquals((long)7L, (long)this.actual.minorVersion());
        Assert.assertEquals((long)25L, (long)this.actual.microVersion());
    }

    @Test
    public void testVitess() {
        this.actual = MySQLDatabaseMetadata.parse((String)"5.7.9-Vitess");
        Assert.assertEquals((Object)"5.7.9-Vitess", (Object)this.actual.fullVersion());
        Assert.assertEquals((Object)"MySQL", (Object)this.actual.productName());
        Assert.assertEquals((long)5L, (long)this.actual.majorVersion());
        Assert.assertEquals((long)7L, (long)this.actual.minorVersion());
        Assert.assertEquals((long)9L, (long)this.actual.microVersion());
    }

    @Test
    public void testFacebook_V8_0() {
        this.actual = MySQLDatabaseMetadata.parse((String)"8.0.17 Source distribution");
        Assert.assertEquals((Object)"8.0.17 Source distribution", (Object)this.actual.fullVersion());
        Assert.assertEquals((Object)"MySQL", (Object)this.actual.productName());
        Assert.assertEquals((long)8L, (long)this.actual.majorVersion());
        Assert.assertEquals((long)0L, (long)this.actual.minorVersion());
        Assert.assertEquals((long)17L, (long)this.actual.microVersion());
    }
}

