/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.RowSet;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLStoredProgramsTest
extends MySQLTestBase {
    Vertx vertx;
    MySQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testMultiStatement(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT 1; SELECT 'test';").execute(ctx.asyncAssertSuccess(result -> {
            Row row1 = (Row)result.iterator().next();
            ctx.assertEquals((Object)1, (Object)row1.getInteger(0));
            Row row2 = (Row)result.next().iterator().next();
            ctx.assertEquals((Object)"test", row2.getValue(0));
            ctx.assertEquals((Object)"test", (Object)row2.getString(0));
            conn.close();
        }))));
    }

    @Test
    public void testMultiResult(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("CREATE TEMPORARY TABLE ins ( id INT );").execute(ctx.asyncAssertSuccess(createTable -> conn.query("DROP PROCEDURE IF EXISTS multi;").execute(ctx.asyncAssertSuccess(cleanProcedure -> conn.query("CREATE PROCEDURE multi()\nBEGIN\n    SELECT 123;\n    SELECT 456;\n    INSERT INTO ins VALUES (1);\n    INSERT INTO ins VALUES (2);\nEND;").execute(ctx.asyncAssertSuccess(createProcedure -> conn.query("CALL multi();").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            ctx.assertEquals((Object)123, (Object)((Row)result.iterator().next()).getInteger(0));
            RowSet secondResult = result.next();
            ctx.assertEquals((Object)1, (Object)secondResult.size());
            ctx.assertEquals((Object)456, (Object)((Row)secondResult.iterator().next()).getInteger(0));
            RowSet thirdResult = secondResult.next();
            ctx.assertEquals((Object)0, (Object)thirdResult.size());
            if (rule.isUsingMariaDB()) {
                ctx.assertEquals((Object)2, (Object)thirdResult.rowCount());
            } else {
                ctx.assertEquals((Object)1, (Object)thirdResult.rowCount());
            }
            conn.query("SELECT id FROM ins").execute(ctx.asyncAssertSuccess(queryRes -> {
                ctx.assertEquals((Object)2, (Object)queryRes.size());
                RowIterator rowIterator = queryRes.iterator();
                Row row1 = (Row)rowIterator.next();
                ctx.assertEquals((Object)1, row1.getValue(0));
                Row row2 = (Row)rowIterator.next();
                ctx.assertEquals((Object)2, row2.getValue(0));
                conn.close();
            }));
        }))))))))));
    }

    @Test
    public void testInParameters(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("DROP PROCEDURE IF EXISTS dorepeat;").execute(ctx.asyncAssertSuccess(cleanProcedure -> conn.query("CREATE PROCEDURE dorepeat(p1 INT)\nBEGIN\n    SET @x = 0;\n    REPEAT\n        SET @x = @x + 1;\n    UNTIL @x > p1 END REPEAT;\nend;").execute(ctx.asyncAssertSuccess(createProcedure -> conn.query("CALL dorepeat(1000);").execute(ctx.asyncAssertSuccess(callProcedure -> conn.query("SELECT @x;").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)1001, (Object)row.getInteger(0));
            conn.close();
        }))))))))));
    }

    @Test
    public void testOutParameters(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("DROP PROCEDURE IF EXISTS test_out_parameter;").execute(ctx.asyncAssertSuccess(cleanProcedure -> conn.query("CREATE PROCEDURE test_out_parameter(OUT p1 VARCHAR(20))\nBEGIN\n    SELECT 'hello,world!' INTO p1;\nend;").execute(ctx.asyncAssertSuccess(createProcedure -> conn.query("CALL test_out_parameter(@OUT);").execute(ctx.asyncAssertSuccess(callProcedure -> conn.query("SELECT @OUT;").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)"hello,world!", row.getValue(0));
            ctx.assertEquals((Object)"hello,world!", (Object)row.getString(0));
            conn.close();
        }))))))))));
    }

    @Test
    public void testInOutParameters(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("DROP PROCEDURE IF EXISTS test_inout_parameter;").execute(ctx.asyncAssertSuccess(cleanProcedure -> conn.query("CREATE PROCEDURE test_inout_parameter(INOUT p1 INT)\nBEGIN\n    SET p1 = p1 + 12345;\nend;").execute(ctx.asyncAssertSuccess(createProcedure -> conn.query("SET @INOUT = 98765;\nCALL test_inout_parameter(@INOUT);").execute(ctx.asyncAssertSuccess(callProcedure -> conn.query("SELECT @INOUT;").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)111110, (Object)row.getInteger(0));
            conn.close();
        }))))))))));
    }
}

