/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLAuthOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.mysqlclient.SslMode;
import io.vertx.mysqlclient.junit.MySQLRule;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLTLSTest {
    @ClassRule
    public static MySQLRule rule = MySQLRule.SHARED_TLS_INSTANCE;
    @ClassRule
    public static MySQLRule nonTlsRule = MySQLRule.SHARED_INSTANCE;
    Vertx vertx;
    MySQLConnectOptions options;
    MySQLConnectOptions nonTlsOptions;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(rule.options());
        this.nonTlsOptions = new MySQLConnectOptions(nonTlsRule.options());
        if (rule.isUsingMySQL5_6()) {
            this.options.removeEnabledSecureTransportProtocol("TLSv1.2");
        }
    }

    @After
    public void tearDown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testSuccessWithDisabledSslMode(TestContext ctx) {
        this.options.setSslMode(SslMode.DISABLED);
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertFalse(conn.isSSL());
            conn.query("SELECT 1").execute(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)1, (Object)res.size());
                conn.close();
            }));
        }));
    }

    @Test
    public void testTlsSuccessWithPreferredSslMode(TestContext ctx) {
        this.options.setSslMode(SslMode.PREFERRED);
        this.options.setPemTrustOptions(new PemTrustOptions().addCertPath("tls/files/ca.pem"));
        this.options.setPemKeyCertOptions(new PemKeyCertOptions().setCertPath("tls/files/client-cert.pem").setKeyPath("tls/files/client-key.pem"));
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertTrue(conn.isSSL());
            conn.query("SELECT 1").execute(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)1, (Object)res.size());
                conn.close();
            }));
        }));
    }

    @Test
    public void testTlsHandshakeFailWithPreferredSslMode(TestContext ctx) {
        this.options.setSslMode(SslMode.PREFERRED);
        this.options.setPemTrustOptions(new PemTrustOptions().addCertPath("tls/files/client-cert.pem"));
        this.options.setPemKeyCertOptions(new PemKeyCertOptions().setCertPath("tls/files/client-cert.pem").setKeyPath("tls/files/client-key.pem"));
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertFalse(conn.isSSL());
            conn.query("SELECT 1").execute(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)1, (Object)res.size());
                conn.close();
            }));
        }));
    }

    @Test
    public void testNonTlsConnWithPreferredSslMode(TestContext ctx) {
        this.nonTlsOptions.setSslMode(SslMode.PREFERRED);
        this.nonTlsOptions.setPemTrustOptions(new PemTrustOptions().addCertPath("tls/files/ca.pem"));
        this.nonTlsOptions.setPemKeyCertOptions(new PemKeyCertOptions().setCertPath("tls/files/client-cert.pem").setKeyPath("tls/files/client-key.pem"));
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.nonTlsOptions, (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertFalse(conn.isSSL());
            conn.query("SELECT 1").execute(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)1, (Object)res.size());
                conn.close();
            }));
        }));
    }

    @Test
    public void testSuccessWithRequiredSslMode(TestContext ctx) {
        this.options.setSslMode(SslMode.REQUIRED);
        this.options.setPemTrustOptions(new PemTrustOptions().addCertPath("tls/files/ca.pem"));
        this.options.setPemKeyCertOptions(new PemKeyCertOptions().setCertPath("tls/files/client-cert.pem").setKeyPath("tls/files/client-key.pem"));
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertTrue(conn.isSSL());
            conn.query("SELECT 1").execute(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)1, (Object)res.size());
                conn.close();
            }));
        }));
    }

    @Test
    public void testSuccessWithOnlyCertificate(TestContext ctx) {
        this.options.setSslMode(SslMode.REQUIRED);
        this.options.setPemTrustOptions(new PemTrustOptions().addCertPath("tls/files/ca.pem"));
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertTrue(conn.isSSL());
            conn.query("SELECT 1").execute(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)1, (Object)res.size());
                conn.close();
            }));
        }));
    }

    @Test
    public void testSuccessWithoutCertificate(TestContext ctx) {
        this.options.setSslMode(SslMode.REQUIRED);
        this.options.setTrustAll(true);
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertTrue(conn.isSSL());
            conn.query("SELECT 1").execute(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)1, (Object)res.size());
                conn.close();
            }));
        }));
    }

    @Test
    public void testSuccessWithVerifyCaSslMode(TestContext ctx) {
        this.options.setSslMode(SslMode.VERIFY_CA);
        this.options.setPemTrustOptions(new PemTrustOptions().addCertPath("tls/files/ca.pem"));
        this.options.setPemKeyCertOptions(new PemKeyCertOptions().setCertPath("tls/files/client-cert.pem").setKeyPath("tls/files/client-key.pem"));
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> {
            ctx.assertTrue(conn.isSSL());
            conn.query("SELECT 1").execute(ctx.asyncAssertSuccess(res -> {
                ctx.assertEquals((Object)1, (Object)res.size());
                conn.close();
            }));
        }));
    }

    @Test
    public void testConnFailWithVerifyCaSslMode(TestContext ctx) {
        this.options.setSslMode(SslMode.VERIFY_CA);
        this.options.setTrustAll(true);
        this.options.setPemKeyCertOptions(new PemKeyCertOptions().setCertPath("tls/files/client-cert.pem").setKeyPath("tls/files/client-key.pem"));
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertFailure(error -> ctx.assertEquals((Object)"Trust options must be specified under VERIFY_CA ssl-mode.", (Object)error.getMessage())));
    }

    @Test
    public void testPoolFailWithVerifyCaSslMode(TestContext ctx) {
        this.options.setSslMode(SslMode.VERIFY_CA);
        this.options.setTrustAll(true);
        this.options.setPemKeyCertOptions(new PemKeyCertOptions().setCertPath("tls/files/client-cert.pem").setKeyPath("tls/files/client-key.pem"));
        try {
            MySQLPool.pool((Vertx)this.vertx, (MySQLConnectOptions)this.options, (PoolOptions)new PoolOptions());
        }
        catch (IllegalArgumentException e) {
            ctx.assertEquals((Object)"Trust options must be specified under VERIFY_CA ssl-mode.", (Object)e.getMessage());
        }
    }

    @Test
    public void testConnFailWithVerifyIdentitySslMode(TestContext ctx) {
        this.options.setSslMode(SslMode.VERIFY_IDENTITY);
        this.options.setPemTrustOptions(new PemTrustOptions().addCertPath("tls/files/ca.pem"));
        this.options.setPemKeyCertOptions(new PemKeyCertOptions().setCertPath("tls/files/client-cert.pem").setKeyPath("tls/files/client-key.pem"));
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertFailure(error -> ctx.assertEquals((Object)"Host verification algorithm must be specified under VERIFY_IDENTITY ssl-mode.", (Object)error.getMessage())));
    }

    @Test
    public void testConnFail(TestContext ctx) {
        this.options.setSslMode(SslMode.REQUIRED);
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertFailure(error -> {}));
    }

    @Test
    public void testChangeUser(TestContext ctx) {
        this.options.setSslMode(SslMode.REQUIRED);
        this.options.setPemTrustOptions(new PemTrustOptions().addCertPath("tls/files/ca.pem"));
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT current_user()").execute(ctx.asyncAssertSuccess(res1 -> {
            Row row1 = (Row)res1.iterator().next();
            String username = row1.getString(0);
            ctx.assertEquals((Object)"mysql", (Object)username.substring(0, username.lastIndexOf(64)));
            MySQLAuthOptions changeUserOptions = new MySQLAuthOptions().setUser("superuser").setPassword("password").setDatabase("emptyschema");
            conn.changeUser(changeUserOptions, ctx.asyncAssertSuccess(v2 -> conn.query("SELECT current_user();SELECT database();").execute(ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)"superuser@%", (Object)((Row)res2.iterator().next()).getString(0));
                ctx.assertEquals((Object)"emptyschema", ((Row)res2.next().iterator().next()).getValue(0));
                conn.close();
            }))));
        }))));
    }
}

