/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.mysqlclient.SslMode;
import io.vertx.sqlclient.PoolOptions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLUnixDomainSocketTest
extends MySQLTestBase {
    private static final String unixSocketFile = System.getProperty("unix.socket.file");
    private MySQLPool client;
    private MySQLConnectOptions options;

    @Before
    public void setUp() {
        String osName = System.getProperty("os.name");
        Assume.assumeTrue((osName != null && (osName.startsWith("Linux") || osName.startsWith("LINUX")) ? 1 : 0) != 0);
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
        if (unixSocketFile != null && !unixSocketFile.isEmpty()) {
            this.options.setHost(unixSocketFile);
        } else {
            this.options.setHost(rule.domainSocketPath());
        }
        Assume.assumeTrue((boolean)this.options.isUsingDomainSocket());
    }

    @After
    public void after() {
        if (this.client != null) {
            this.client.close();
        }
    }

    @Test
    public void uriSocketHostTest(TestContext context) throws UnsupportedEncodingException {
        String path = URLEncoder.encode(this.options.getHost(), "UTF-8");
        this.uriTest(context, "mysql://" + this.options.getUser() + ":" + this.options.getPassword() + "@" + path);
    }

    @Test
    public void uriSocketAttributeTest(TestContext context) throws UnsupportedEncodingException {
        String path = URLEncoder.encode(this.options.getHost(), "UTF-8");
        this.uriTest(context, "mysql://" + this.options.getUser() + ":" + this.options.getPassword() + "@192.168.0.67?socket=" + path);
    }

    private void uriTest(TestContext context, String uri) throws UnsupportedEncodingException {
        this.client = MySQLPool.pool((String)uri);
        this.client.getConnection(context.asyncAssertSuccess(conn -> conn.close()));
    }

    @Test
    public void simpleConnect(TestContext context) {
        this.client = MySQLPool.pool((MySQLConnectOptions)new MySQLConnectOptions(this.options), (PoolOptions)new PoolOptions());
        this.client.getConnection(context.asyncAssertSuccess(conn -> conn.close()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void connectWithVertxInstance(TestContext context) {
        try (Vertx vertx = Vertx.vertx((VertxOptions)new VertxOptions().setPreferNativeTransport(true));){
            this.client = MySQLPool.pool((Vertx)vertx, (MySQLConnectOptions)new MySQLConnectOptions(this.options), (PoolOptions)new PoolOptions());
            Async async = context.async();
            this.client.getConnection(context.asyncAssertSuccess(conn -> {
                async.complete();
                conn.close();
            }));
            async.await();
        }
    }

    @Test
    public void testIgnoreSslMode(TestContext context) {
        this.client = MySQLPool.pool((MySQLConnectOptions)new MySQLConnectOptions(this.options).setSslMode(SslMode.REQUIRED), (PoolOptions)new PoolOptions());
        this.client.getConnection(context.asyncAssertSuccess(conn -> {
            Assert.assertFalse((boolean)conn.isSSL());
            conn.close();
        }));
    }
}

