/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLAuthOptions;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLSetOption;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLUtilityCommandTest
extends MySQLTestBase {
    Vertx vertx;
    MySQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    @Test
    public void testPingCommand(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.ping(ctx.asyncAssertSuccess(v -> conn.close()))));
    }

    @Test
    public void testChangeSchema(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT DATABASE();").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)"testschema", (Object)((Row)result.iterator().next()).getString(0));
            conn.specifySchema("emptyschema", ctx.asyncAssertSuccess(v -> conn.query("SELECT DATABASE();").execute(ctx.asyncAssertSuccess(result2 -> {
                ctx.assertEquals((Object)"emptyschema", (Object)((Row)result2.iterator().next()).getString(0));
                conn.close();
            }))));
        }))));
    }

    @Test
    public void testChangeToInvalidSchema(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT DATABASE();").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)"testschema", (Object)((Row)result.iterator().next()).getString(0));
            conn.specifySchema("invalidschema", ctx.asyncAssertFailure(error -> conn.close()));
        }))));
    }

    @Test
    public void testStatistics(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.getInternalStatistics(ctx.asyncAssertSuccess(result -> {
            ctx.assertTrue(!result.isEmpty());
            conn.close();
        }))));
    }

    @Test
    public void testSetOption(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT 1; SELECT 2;").execute(ctx.asyncAssertSuccess(rowSet1 -> {
            ctx.assertEquals((Object)1, (Object)rowSet1.size());
            Row row1 = (Row)rowSet1.iterator().next();
            ctx.assertEquals((Object)1, (Object)row1.getInteger(0));
            RowSet rowSet2 = rowSet1.next();
            ctx.assertEquals((Object)1, (Object)rowSet2.size());
            Row row2 = (Row)rowSet2.iterator().next();
            ctx.assertEquals((Object)2, (Object)row2.getInteger(0));
            conn.setOption(MySQLSetOption.MYSQL_OPTION_MULTI_STATEMENTS_OFF, ctx.asyncAssertSuccess(v -> conn.query("SELECT 1; SELECT 2;").execute(ctx.asyncAssertFailure(error -> conn.close()))));
        }))));
    }

    @Test
    public void testResetConnection(TestContext ctx) {
        Assume.assumeFalse((boolean)rule.isUsingMySQL5_6());
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("CREATE TEMPORARY TABLE temp (temp INTEGER)").execute(ctx.asyncAssertSuccess(res1 -> conn.query("SELECT * FROM temp").execute(ctx.asyncAssertSuccess(res2 -> conn.resetConnection(ctx.asyncAssertSuccess(res3 -> conn.query("SELECT * FROM temp").execute(ctx.asyncAssertFailure(error -> conn.close()))))))))));
    }

    @Test
    public void testChangeUser(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT current_user()").execute(ctx.asyncAssertSuccess(res1 -> {
            Row row1 = (Row)res1.iterator().next();
            String username = row1.getString(0);
            ctx.assertEquals((Object)"mysql", (Object)username.substring(0, username.lastIndexOf(64)));
            MySQLAuthOptions changeUserOptions = new MySQLAuthOptions().setUser("superuser").setPassword("password").setDatabase("emptyschema");
            conn.changeUser(changeUserOptions, ctx.asyncAssertSuccess(v2 -> conn.query("SELECT current_user();SELECT database();").execute(ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)"superuser@%", (Object)((Row)res2.iterator().next()).getString(0));
                ctx.assertEquals((Object)"emptyschema", ((Row)res2.next().iterator().next()).getValue(0));
                conn.close();
            }))));
        }))));
    }

    @Test
    public void testChangeUserAuthWithServerRsaPublicKey(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT current_user()").execute(ctx.asyncAssertSuccess(res1 -> {
            Row row1 = (Row)res1.iterator().next();
            String username = row1.getString(0);
            ctx.assertEquals((Object)"mysql", (Object)username.substring(0, username.lastIndexOf(64)));
            MySQLAuthOptions changeUserOptions = new MySQLAuthOptions().setUser("superuser").setPassword("password").setDatabase("emptyschema").setServerRsaPublicKeyValue(Buffer.buffer((String)"-----BEGIN PUBLIC KEY-----\nMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEA3yvG5s0qrV7jxVlp0sMj\nxP0a6BuLKCMjb0o88hDsJ3xz7PpHNKazuEAfPxiRFVAV3edqfSiXoQw+lJf4haEG\nHQe12Nfhs+UhcAeTKXRlZP/JNmI+BGoBduQ1rCId9bKYbXn4pvyS/a1ft7SwFkhx\naogCur7iIB0WUWvwkQ0fEj/Mlhw93lLVyx7hcGFq4FOAKFYr3A0xrHP1IdgnD8QZ\n0fUbgGLWWLOossKrbUP5HWko1ghLPIbfmU6o890oj1ZWQewj1Rs9Er92/UDj/JXx\n7ha1P+ZOgPBlV037KDQMS6cUh9vTablEHsMLhDZanymXzzjBkL+wH/b9cdL16LkQ\n5QIDAQAB\n-----END PUBLIC KEY-----\n"));
            conn.changeUser(changeUserOptions, ctx.asyncAssertSuccess(v2 -> conn.query("SELECT current_user();SELECT database();").execute(ctx.asyncAssertSuccess(res2 -> {
                ctx.assertEquals((Object)"superuser@%", (Object)((Row)res2.iterator().next()).getString(0));
                ctx.assertEquals((Object)"emptyschema", ((Row)res2.next().iterator().next()).getValue(0));
                conn.close();
            }))));
        }))));
    }
}

