/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.data.MySQLDataTypeTestBase;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class BitCodecTest
extends MySQLDataTypeTestBase {
    @Test
    public void testTextDecodeBit(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_bit", 30L);
    }

    @Test
    public void testBinaryDecodeBit(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_bit", 30L);
    }

    @Test
    public void testBinaryEncodeBit(TestContext ctx) {
        StringBuilder binaryStringBuilder = new StringBuilder();
        for (int i = 0; i < 50; ++i) {
            binaryStringBuilder.append(ThreadLocalRandom.current().nextInt(2));
        }
        Long expected = Long.parseLong(binaryStringBuilder.toString(), 2);
        this.testBinaryEncodeGeneric(ctx, "test_bit", expected);
    }

    @Test
    public void testBinaryEncodeZero(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_bit", 0L);
    }

    @Test
    public void testBinaryEncodeBitMax(TestContext ctx) {
        long maxBitLimit = -1L;
        StringBuilder binaryStringBuilder = new StringBuilder();
        for (int i = 0; i < 64; ++i) {
            binaryStringBuilder.append(1);
        }
        ctx.assertEquals((Object)binaryStringBuilder.toString(), (Object)Long.toBinaryString(maxBitLimit));
        this.testBinaryEncodeGeneric(ctx, "test_bit", maxBitLimit);
    }
}

