/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.data.DateTimeCodecTest;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.Tuple;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Consumer;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class DateTimeBinaryCodecTest
extends DateTimeCodecTest {
    @Test
    public void testBinaryDecodeAll(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT `test_year`, `test_timestamp`, `test_datetime` FROM datatype WHERE id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)3, (Object)row.size());
            ctx.assertEquals((Object)2019, row.getValue(0));
            ctx.assertEquals((Object)LocalDateTime.of(2000, 1, 1, 10, 20, 30), row.getValue(1));
            ctx.assertEquals((Object)LocalDateTime.of(2000, 1, 1, 10, 20, 30, 123456000), row.getValue(2));
            conn.close();
        }))));
    }

    @Test
    public void testEncodeNegative(TestContext ctx) {
        this.testEncodeTime(ctx, Duration.ofHours(-11L).minusMinutes(12L), Duration.ofHours(-11L).minusMinutes(12L));
    }

    @Test
    public void testEncodeMaxTime(TestContext ctx) {
        this.testEncodeTime(ctx, Duration.ofHours(838L).plusMinutes(59L).plusSeconds(59L), Duration.ofHours(838L).plusMinutes(59L).plusSeconds(59L));
    }

    @Test
    public void testEncodeMinTime(TestContext ctx) {
        this.testEncodeTime(ctx, Duration.ofHours(-838L).minusMinutes(59L).minusSeconds(59L), Duration.ofHours(-838L).minusMinutes(59L).minusSeconds(59L));
    }

    @Test
    public void testEncodeMaxTimeOverflow(TestContext ctx) {
        this.testEncodeTime(ctx, Duration.ofDays(120L).plusHours(19L).plusMinutes(27L).plusSeconds(30L), Duration.ofHours(838L).plusMinutes(59L).plusSeconds(59L));
    }

    @Test
    public void testEncodeMinTimeOverflow(TestContext ctx) {
        this.testEncodeTime(ctx, Duration.ofDays(-120L).plusHours(-19L).plusMinutes(-27L).plusSeconds(-30L), Duration.ofHours(-838L).plusMinutes(-59L).plusSeconds(-59L));
    }

    @Test
    public void testEncodeFractionalSecondsPart(TestContext ctx) {
        this.testEncodeTime(ctx, Duration.ofHours(11L).plusMinutes(12L).plusNanos(123456000L), Duration.ofHours(11L).plusMinutes(12L).plusNanos(123456000L));
    }

    @Test
    public void testEncodeTimeFromLocalTimeWithFractionalSecondsPart(TestContext ctx) {
        this.testEncodeTime(ctx, LocalTime.of(11, 12, 0, 123456000), Duration.ofHours(11L).plusMinutes(12L).plusNanos(123456000L), LocalTime.of(11, 12, 0, 123456000));
    }

    @Test
    public void testEncodeTimeFromLocalTimeWithoutFractionalSecondsPart(TestContext ctx) {
        this.testEncodeTime(ctx, LocalTime.of(11, 12, 0, 0), Duration.ofHours(11L).plusMinutes(12L), LocalTime.of(11, 12, 0, 0));
    }

    @Test
    public void testEncodeZeroLocalTime(TestContext ctx) {
        this.testEncodeTime(ctx, LocalTime.of(0, 0, 0, 0), Duration.ofHours(0L), LocalTime.of(0, 0, 0, 0));
    }

    @Test
    public void testDecodeYear(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_year", (short)2019);
    }

    @Test
    public void testEncodeYear(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_year", (short)2008);
    }

    @Test
    public void testDecodeTimestamp(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_timestamp", LocalDateTime.of(2000, 1, 1, 10, 20, 30));
    }

    @Test
    public void testEncodeTimestamp(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_timestamp", LocalDateTime.of(2001, 6, 20, 19, 40, 0));
    }

    @Override
    @Test
    public void testDecodeDatetime(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_datetime", LocalDateTime.of(2000, 1, 1, 10, 20, 30, 123456000));
    }

    @Test
    public void testEncodeDatetimeWithoutTime(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_datetime", LocalDateTime.of(2001, 6, 20, 0, 0, 0, 0));
    }

    @Test
    public void testEncodeDatetimeWithoutMicrosecond(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_datetime", LocalDateTime.of(2001, 6, 20, 19, 40, 10));
    }

    @Test
    public void testEncodeDatetimeWithMicrosecond(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_datetime", LocalDateTime.of(2001, 6, 20, 19, 40, 0, 5000000));
    }

    @Test
    public void testEncodeDatetimeWithOnlyMicrosecond(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_datetime", LocalDateTime.of(2001, 6, 20, 0, 0, 0, 123456000));
    }

    @Test
    public void testEncodeCastStringToDate(TestContext ctx) {
        this.testBinaryDecode(ctx, "SELECT * FROM basicdatatype WHERE id = 1 AND `test_date` = ?", Tuple.of((Object)"2019-01-01"), result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            RowIterator iterator = result.iterator();
            Row row = (Row)iterator.next();
            ctx.assertEquals((Object)1, (Object)row.getInteger("id"));
            ctx.assertEquals((Object)LocalDate.of(2019, 1, 1), (Object)row.getLocalDate("test_date"));
        });
    }

    @Test
    public void testEncodeCastStringToTime(TestContext ctx) {
        this.testBinaryDecode(ctx, "SELECT * FROM basicdatatype WHERE id = 1 AND `test_time` = ?", Tuple.of((Object)"18:45:02"), result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            RowIterator iterator = result.iterator();
            Row row = (Row)iterator.next();
            ctx.assertEquals((Object)1, (Object)row.getInteger("id"));
            Duration expected = Duration.ZERO.plusHours(18L).plusMinutes(45L).plusSeconds(2L);
            ctx.assertEquals((Object)expected, row.getValue("test_time"));
        });
    }

    private void testEncodeTime(TestContext ctx, Duration param, Duration expected) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("UPDATE basicdatatype SET `test_time` = ? WHERE id = 2").execute(Tuple.tuple().addValue((Object)param), ctx.asyncAssertSuccess(updateResult -> conn.preparedQuery("SELECT `test_time` FROM basicdatatype WHERE id = 2").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)expected, row.getValue(0));
            ctx.assertEquals((Object)expected, row.getValue("test_time"));
            conn.close();
        }))))));
    }

    private void testEncodeTime(TestContext ctx, LocalTime param, Duration expectedDuration, LocalTime expectedLocalTime) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("UPDATE basicdatatype SET `test_time` = ? WHERE id = 2").execute(Tuple.tuple().addValue((Object)param), ctx.asyncAssertSuccess(updateResult -> conn.preparedQuery("SELECT `test_time` FROM basicdatatype WHERE id = 2").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)expectedDuration, row.getValue(0));
            ctx.assertEquals((Object)expectedDuration, row.getValue("test_time"));
            ctx.assertEquals((Object)expectedLocalTime, (Object)row.getLocalTime(0));
            ctx.assertEquals((Object)expectedLocalTime, (Object)row.getLocalTime("test_time"));
            conn.close();
        }))))));
    }

    @Override
    protected <T> void testDecodeGeneric(TestContext ctx, String data, String dataType, String columnName, T expected) {
        this.testDecodeGeneric(ctx, data, dataType, (Row row) -> {
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(columnName));
        }, columnName);
    }

    @Override
    protected void testDecodeGeneric(TestContext ctx, String data, String dataType, Consumer<Row> valueAccessor, String columnName) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT CAST('" + data + "' AS " + dataType + ") " + columnName).execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            valueAccessor.accept(row);
            conn.close();
        }))));
    }
}

