/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.mysqlclient.data.MySQLDataTypeTestBase;
import io.vertx.sqlclient.Row;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.function.Consumer;
import org.junit.Assume;
import org.junit.Test;

public abstract class DateTimeCodecTest
extends MySQLDataTypeTestBase {
    @Test
    public void testDecodeAbbreviatedValue(TestContext ctx) {
        this.testDecodeGeneric(ctx, "11:12", "TIME", "test_time", Duration.ofHours(11L).plusMinutes(12L));
    }

    @Test
    public void testDecodeAbbreviatedValueWithoutColons(TestContext ctx) {
        this.testDecodeGeneric(ctx, "1112", "TIME", "test_time", Duration.ofMinutes(11L).plusSeconds(12L));
    }

    @Test
    public void testDecodeAbbreviatedValueWithoutColons2(TestContext ctx) {
        this.testDecodeGeneric(ctx, "12", "TIME", "test_time", Duration.ofSeconds(12L));
    }

    @Test
    public void testDecodeMaxTime(TestContext ctx) {
        this.testDecodeGeneric(ctx, "838:59:59", "TIME", "test_time", Duration.ofHours(838L).plusMinutes(59L).plusSeconds(59L));
    }

    @Test
    public void testDecodeMinTime(TestContext ctx) {
        this.testDecodeGeneric(ctx, "-838:59:59", "TIME", "test_time", Duration.ofHours(-838L).plusMinutes(-59L).plusSeconds(-59L));
    }

    @Test
    public void testDecodeMaxTimeOverflow(TestContext ctx) {
        this.testDecodeGeneric(ctx, "850:00:00", "TIME", "test_time", Duration.ofHours(838L).plusMinutes(59L).plusSeconds(59L));
    }

    @Test
    public void testDecodeMinTimeOverflow(TestContext ctx) {
        this.testDecodeGeneric(ctx, "-850:00:00", "TIME", "test_time", Duration.ofHours(-838L).plusMinutes(-59L).plusSeconds(-59L));
    }

    @Test
    public void testDecodeDefaultFractionalSecondsPart(TestContext ctx) {
        this.testDecodeGeneric(ctx, "11:12:00.123456", "TIME", "test_time", Duration.ofHours(11L).plusMinutes(12L));
    }

    @Test
    public void testDecodeTimeAsLocalTimeWithoutFractionalSecondsPart(TestContext ctx) {
        this.testDecodeGeneric(ctx, "11:12:00.123456", "TIME", (Row row) -> {
            ctx.assertEquals((Object)LocalTime.of(11, 12, 0), (Object)row.getLocalTime(0));
            ctx.assertEquals((Object)LocalTime.of(11, 12, 0), (Object)row.getLocalTime("test_time"));
        }, "test_time");
    }

    @Test
    public void testDecodeFractionalSecondsPart(TestContext ctx) {
        this.testDecodeGeneric(ctx, "11:12:00.123456", "TIME(6)", "test_time", Duration.ofHours(11L).plusMinutes(12L).plusNanos(123456000L));
    }

    @Test
    public void testDecodeTimeAsLocalTimeWithFractionalSecondsPart(TestContext ctx) {
        this.testDecodeGeneric(ctx, "11:12:00.123456", "TIME(6)", (Row row) -> {
            ctx.assertEquals((Object)LocalTime.of(11, 12, 0, 123456000), (Object)row.getLocalTime(0));
            ctx.assertEquals((Object)LocalTime.of(11, 12, 0, 123456000), (Object)row.getLocalTime("test_time"));
        }, "test_time");
    }

    @Test
    public void testDecodeFractionalSecondsPartTruncation(TestContext ctx) {
        Assume.assumeFalse((boolean)rule.isUsingMariaDB());
        this.testDecodeGeneric(ctx, "11:12:00.123456", "TIME(4)", "test_time", Duration.ofHours(11L).plusMinutes(12L).plusNanos(123500000L));
    }

    @Test
    public void testDecodeDatetime(TestContext ctx) {
        this.testDecodeGeneric(ctx, "2000-01-01 10:20:30", "DATETIME", "test_datetime", LocalDateTime.of(2000, 1, 1, 10, 20, 30));
    }

    @Test
    public void testDecodeDatetimeWithFractionalSeconds(TestContext ctx) {
        this.testDecodeGeneric(ctx, "2000-01-01 10:20:30.123456", "DATETIME(6)", "test_datetime", LocalDateTime.of(2000, 1, 1, 10, 20, 30, 123456000));
    }

    @Test
    public void testDecodeDatetimeWithFractionalSecondsTruncation(TestContext ctx) {
        Assume.assumeFalse((boolean)rule.isUsingMariaDB());
        this.testDecodeGeneric(ctx, "2000-01-01 10:20:30.123456", "DATETIME(4)", "test_datetime", LocalDateTime.of(2000, 1, 1, 10, 20, 30, 123500000));
    }

    @Test
    public void testDecodeInvalidDatetime(TestContext ctx) {
        this.testDecodeGeneric(ctx, "2000-00-34 25:20:30", "DATETIME", "test_datetime", null);
    }

    @Test
    public void testDecodeDateEmpty(TestContext ctx) {
        this.testDecodeGeneric(ctx, "0000-00-00", "DATE", "test_date", null);
    }

    @Test
    public void testDecodeDateTimeEmpty(TestContext ctx) {
        this.testDecodeGeneric(ctx, "0000-00-00 00:00:00", "DATETIME", "test_datetime", null);
    }

    protected abstract <T> void testDecodeGeneric(TestContext var1, String var2, String var3, String var4, T var5);

    protected abstract void testDecodeGeneric(TestContext var1, String var2, String var3, Consumer<Row> var4, String var5);
}

