/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.data.DateTimeCodecTest;
import io.vertx.sqlclient.Row;
import java.time.LocalDateTime;
import java.util.function.Consumer;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class DateTimeTextCodecTest
extends DateTimeCodecTest {
    @Test
    public void testTextDecodeAll(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT `test_year`, `test_timestamp`, `test_datetime` FROM datatype WHERE id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)3, (Object)row.size());
            ctx.assertEquals((Object)2019, row.getValue(0));
            ctx.assertEquals((Object)LocalDateTime.of(2000, 1, 1, 10, 20, 30), row.getValue(1));
            ctx.assertEquals((Object)LocalDateTime.of(2000, 1, 1, 10, 20, 30, 123456000), row.getValue(2));
            conn.close();
        }))));
    }

    @Test
    public void testDecodeYear(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_year", (short)2019);
    }

    @Test
    public void testDecodeTimestamp(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_timestamp", LocalDateTime.of(2000, 1, 1, 10, 20, 30));
    }

    @Override
    protected <T> void testDecodeGeneric(TestContext ctx, String data, String dataType, String columnName, T expected) {
        this.testDecodeGeneric(ctx, data, dataType, (Row row) -> {
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(columnName));
        }, columnName);
    }

    @Override
    protected void testDecodeGeneric(TestContext ctx, String data, String dataType, Consumer<Row> valueAccessor, String columnName) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT CAST('" + data + "' AS " + dataType + ") " + columnName).execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            valueAccessor.accept(row);
            conn.close();
        }))));
    }
}

