/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.data.JsonDataTypeTest;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.Tuple;
import java.util.function.Consumer;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class JsonBinaryCodecTest
extends JsonDataTypeTest {
    private static final String CREATE_TABLE = "CREATE TEMPORARY TABLE test_json\n(\n    json JSON\n);";
    private static final String INSERT_JSON_WITHOUT_CAST = "INSERT INTO test_json VALUES (?);";
    private static final String INSERT_JSON_WITH_CAST = "INSERT INTO test_json VALUES (CAST(? AS JSON));";
    private static final String QUERY_JSON = "SELECT json FROM test_json";

    @Test
    public void testEncodeNumber(TestContext ctx) {
        this.testEncodeJsonWithCast(ctx, Tuple.of((Object)12345), 12345, row -> {
            ctx.assertEquals((Object)12345, (Object)row.getInteger(0));
            ctx.assertEquals((Object)12345, (Object)row.getInteger("json"));
        });
    }

    @Test
    public void testEncodeString(TestContext ctx) {
        this.testEncodeJsonWithCast(ctx, Tuple.of((Object)"\"hello, world\""), "hello, world", row -> {
            ctx.assertEquals((Object)"hello, world", (Object)row.getString(0));
            ctx.assertEquals((Object)"hello, world", (Object)row.getString("json"));
        });
    }

    @Test
    public void testEncodeJsonLiteralNull(TestContext ctx) {
        this.testEncodeJson(ctx, Tuple.of((Object)Tuple.JSON_NULL), Tuple.JSON_NULL, null, INSERT_JSON_WITHOUT_CAST);
    }

    @Test
    public void testEncodeSqlNull(TestContext ctx) {
        this.testEncodeJsonWithCast(ctx, Tuple.of(null), null, null);
    }

    @Test
    public void testEncodeBoolean(TestContext ctx) {
        this.testEncodeJsonWithCast(ctx, Tuple.of((Object)true), 1, row -> {
            ctx.assertEquals((Object)true, (Object)row.getBoolean(0));
            ctx.assertEquals((Object)true, (Object)row.getBoolean("json"));
        });
    }

    @Test
    public void testEncodeFullJsonObject(TestContext ctx) {
        JsonObject expected = new JsonObject().put("test_string", (Object)"hello").put("test_number", (Object)12345).put("test_boolean", (Object)true).put("test_null", null).put("test_json_object", (Object)new JsonObject().put("key", (Object)"value")).put("test_json_array", (Object)new JsonArray().add((Object)1).add((Object)2).add((Object)3));
        this.testEncodeJson(ctx, Tuple.of((Object)expected), expected, row -> ctx.assertEquals((Object)expected, row.get(JsonObject.class, 0)), INSERT_JSON_WITHOUT_CAST);
    }

    @Test
    public void testEncodeJsonObject(TestContext ctx) {
        JsonObject expected = new JsonObject().put("test_string", (Object)"hello").put("test_number", (Object)12345).put("test_boolean", (Object)true).put("test_null", null).put("test_json_object", (Object)new JsonObject().put("key", (Object)"value")).put("test_json_array", (Object)new JsonArray().add((Object)1).add((Object)2).add((Object)3));
        this.testEncodeJson(ctx, Tuple.of((Object)"hello", (Object)12345, null), expected, row -> ctx.assertEquals((Object)expected, row.get(JsonObject.class, 0)), "INSERT INTO test_json VALUES (JSON_OBJECT(\n               'test_string', ?,\n               'test_number', ?,\n               'test_boolean', true,\n               'test_null', ?,\n               'test_json_object', JSON_OBJECT('key', 'value'),\n               'test_json_array', JSON_ARRAY(1, 2, 3)\n           ))");
    }

    @Test
    public void testEncodeFullJsonArray(TestContext ctx) {
        JsonArray expected = new JsonArray().add((Object)"hello").add((Object)12345).add((Object)true).add(null).add((Object)new JsonObject().put("key", (Object)"value")).add((Object)new JsonArray().add((Object)1).add((Object)2).add((Object)3));
        this.testEncodeJson(ctx, Tuple.of((Object)expected), expected, row -> ctx.assertEquals((Object)expected, row.get(JsonArray.class, 0)), INSERT_JSON_WITHOUT_CAST);
    }

    @Test
    public void testEncodeJsonArray(TestContext ctx) {
        JsonArray expected = new JsonArray().add((Object)"hello").add((Object)12345).add((Object)true).add(null).add((Object)new JsonObject().put("key", (Object)"value")).add((Object)new JsonArray().add((Object)1).add((Object)2).add((Object)3));
        this.testEncodeJson(ctx, Tuple.of((Object)"hello", (Object)12345, null), expected, row -> ctx.assertEquals((Object)expected, row.get(JsonArray.class, 0)), "INSERT INTO test_json VALUES (JSON_ARRAY(\n               ?, ?, true, ?, JSON_OBJECT('key', 'value'), JSON_ARRAY(1, 2, 3)\n           ))");
    }

    @Test
    public void testDecodeJsonUsingTable(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("CREATE TEMPORARY TABLE json_test(test_json JSON);").execute(ctx.asyncAssertSuccess(c -> conn.query("INSERT INTO json_test VALUE ('{\"phrase\": \"\u00e0 tout \u00e0 l''heure\"}');\nINSERT INTO json_test VALUE ('{\"emoji\": \"\ud83d\ude00\ud83e\udd23\ud83d\ude0a\ud83d\ude07\ud83d\ude33\ud83d\ude31\"}');").execute(ctx.asyncAssertSuccess(i -> conn.preparedQuery("SELECT test_json FROM json_test").execute(ctx.asyncAssertSuccess(res -> {
            ctx.assertEquals((Object)2, (Object)res.size());
            RowIterator iterator = res.iterator();
            Row row1 = (Row)iterator.next();
            JsonObject phrase = new JsonObject().put("phrase", (Object)"\u00e0 tout \u00e0 l'heure");
            ctx.assertEquals((Object)phrase, (Object)row1.getJsonObject(0));
            ctx.assertEquals((Object)phrase, row1.getValue(0));
            ctx.assertEquals((Object)phrase, row1.getJson(0));
            Row row2 = (Row)iterator.next();
            JsonObject emoji = new JsonObject().put("emoji", (Object)"\ud83d\ude00\ud83e\udd23\ud83d\ude0a\ud83d\ude07\ud83d\ude33\ud83d\ude31");
            ctx.assertEquals((Object)emoji, (Object)row2.getJsonObject(0));
            ctx.assertEquals((Object)emoji, row2.getValue(0));
            ctx.assertEquals((Object)emoji, row2.getJson(0));
        }))))))));
    }

    @Override
    protected void testDecodeJson(TestContext ctx, String script, Object expected, Consumer<Row> checker) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(script).execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue("json"));
            ctx.assertEquals(expected, row.getJson(0));
            ctx.assertEquals(expected, row.getJson("json"));
            if (checker != null) {
                checker.accept(row);
            }
            conn.close();
        }))));
    }

    private void testEncodeJsonWithCast(TestContext ctx, Tuple params, Object expected, Consumer<Row> checker) {
        this.testEncodeJson(ctx, params, expected, checker, INSERT_JSON_WITH_CAST);
    }

    private void testEncodeJson(TestContext ctx, Tuple params, Object expected, Consumer<Row> checker, String insertScript) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(CREATE_TABLE).execute(ctx.asyncAssertSuccess(createTable -> conn.preparedQuery(insertScript).execute(params, ctx.asyncAssertSuccess(insert -> conn.preparedQuery(QUERY_JSON).execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue("json"));
            ctx.assertEquals(expected, row.getJson(0));
            ctx.assertEquals(expected, row.getJson("json"));
            if (checker != null) {
                checker.accept(row);
            }
            conn.close();
        }))))))));
    }
}

