/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.TestContext;
import io.vertx.mysqlclient.data.MySQLDataTypeTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import java.util.function.Consumer;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class JsonDataTypeTest
extends MySQLDataTypeTestBase {
    @BeforeClass
    public static void beforeAll() {
        Assume.assumeFalse((boolean)rule.isUsingMySQL5_6());
        Assume.assumeFalse((boolean)rule.isUsingMariaDB());
    }

    @Test
    public void testDecodeString(TestContext ctx) {
        this.testDecodeJsonWithCast(ctx, "'\"test_json_string\"'", "test_json_string", row -> {
            ctx.assertEquals((Object)"test_json_string", (Object)row.getString(0));
            ctx.assertEquals((Object)"test_json_string", (Object)row.getString("json"));
        });
    }

    @Test
    public void testDecodeStringNull(TestContext ctx) {
        this.testDecodeJsonWithCast(ctx, "'\"null\"'", "null", row -> {
            ctx.assertEquals((Object)"null", (Object)row.getString(0));
            ctx.assertEquals((Object)"null", (Object)row.getString("json"));
        });
    }

    @Test
    public void testDecodeJsonLiteralNull(TestContext ctx) {
        this.testDecodeJsonWithCast(ctx, "'null'", Tuple.JSON_NULL, null);
    }

    @Test
    public void testDecodeSqlNull(TestContext ctx) {
        this.testDecodeJsonWithCast(ctx, "NULL", null, null);
    }

    @Test
    public void testDecodeNumber(TestContext ctx) {
        this.testDecodeJsonWithCast(ctx, "12345", 12345, row -> {
            ctx.assertEquals((Object)12345, (Object)row.getInteger(0));
            ctx.assertEquals((Object)12345, (Object)row.getInteger("json"));
        });
    }

    @Test
    public void testDecodeBoolean(TestContext ctx) {
        this.testDecodeJsonWithCast(ctx, "true", true, row -> {
            ctx.assertEquals((Object)true, (Object)row.getBoolean(0));
            ctx.assertEquals((Object)true, (Object)row.getBoolean("json"));
        });
    }

    @Test
    public void testDecodeJsonObject(TestContext ctx) {
        String script = "SELECT JSON_OBJECT(\n               'test_string', 'hello',\n               'test_number', 12345,\n               'test_boolean', true,\n               'test_null', null,\n               'test_json_object', JSON_OBJECT('key', 'value'),\n               'test_json_array', JSON_ARRAY(1, 2, 3)\n           ) json;";
        JsonObject expected = new JsonObject().put("test_string", (Object)"hello").put("test_number", (Object)12345).put("test_boolean", (Object)true).put("test_null", null).put("test_json_object", (Object)new JsonObject().put("key", (Object)"value")).put("test_json_array", (Object)new JsonArray().add((Object)1).add((Object)2).add((Object)3));
        this.testDecodeJson(ctx, script, expected, row -> ctx.assertEquals((Object)expected, row.get(JsonObject.class, 0)));
    }

    @Test
    public void testDecodeJsonArray(TestContext ctx) {
        String script = "SELECT JSON_ARRAY(\n               'hello', 12345, true, null, JSON_OBJECT('key', 'value'), JSON_ARRAY(1, 2, 3)\n           ) json;";
        JsonArray expected = new JsonArray().add((Object)"hello").add((Object)12345).add((Object)true).add(null).add((Object)new JsonObject().put("key", (Object)"value")).add((Object)new JsonArray().add((Object)1).add((Object)2).add((Object)3));
        this.testDecodeJson(ctx, script, expected, row -> ctx.assertEquals((Object)expected, row.get(JsonArray.class, 0)));
    }

    private void testDecodeJsonWithCast(TestContext ctx, String data, Object expected, Consumer<Row> checker) {
        this.testDecodeJson(ctx, "SELECT CAST(" + data + " AS JSON) json;", expected, checker);
    }

    protected abstract void testDecodeJson(TestContext var1, String var2, Object var3, Consumer<Row> var4);
}

