/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.data.JsonDataTypeTest;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import java.util.function.Consumer;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class JsonTextCodecTest
extends JsonDataTypeTest {
    @Test
    public void testDecodeJsonUsingTable(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("CREATE TEMPORARY TABLE json_test(test_json JSON);").execute(ctx.asyncAssertSuccess(c -> conn.query("INSERT INTO json_test VALUE ('{\"phrase\": \"\u00e0 tout \u00e0 l''heure\"}');\nINSERT INTO json_test VALUE ('{\"emoji\": \"\ud83d\ude00\ud83e\udd23\ud83d\ude0a\ud83d\ude07\ud83d\ude33\ud83d\ude31\"}');").execute(ctx.asyncAssertSuccess(i -> conn.query("SELECT test_json FROM json_test").execute(ctx.asyncAssertSuccess(res -> {
            ctx.assertEquals((Object)2, (Object)res.size());
            RowIterator iterator = res.iterator();
            Row row1 = (Row)iterator.next();
            JsonObject phrase = new JsonObject().put("phrase", (Object)"\u00e0 tout \u00e0 l'heure");
            ctx.assertEquals((Object)phrase, (Object)row1.getJsonObject(0));
            ctx.assertEquals((Object)phrase, row1.getValue(0));
            ctx.assertEquals((Object)phrase, row1.getJson(0));
            Row row2 = (Row)iterator.next();
            JsonObject emoji = new JsonObject().put("emoji", (Object)"\ud83d\ude00\ud83e\udd23\ud83d\ude0a\ud83d\ude07\ud83d\ude33\ud83d\ude31");
            ctx.assertEquals((Object)emoji, (Object)row2.getJsonObject(0));
            ctx.assertEquals((Object)emoji, row2.getValue(0));
            ctx.assertEquals((Object)emoji, row2.getJson(0));
        }))))))));
    }

    @Override
    protected void testDecodeJson(TestContext ctx, String script, Object expected, Consumer<Row> checker) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query(script).execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue("json"));
            ctx.assertEquals(expected, row.getJson(0));
            ctx.assertEquals(expected, row.getJson("json"));
            if (checker != null) {
                checker.accept(row);
            }
            conn.close();
        }))));
    }
}

