/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.junit.After;
import org.junit.Before;

public abstract class MySQLDataTypeTestBase
extends MySQLTestBase {
    Vertx vertx;
    MySQLConnectOptions options;

    @Before
    public void setup() {
        this.vertx = Vertx.vertx();
        this.options = new MySQLConnectOptions(MySQLTestBase.options);
    }

    @After
    public void teardown(TestContext ctx) {
        this.vertx.close(ctx.asyncAssertSuccess());
    }

    protected <T> void testTextDecodeGenericWithTable(TestContext ctx, String columnName, T expected) {
        this.testTextDecodeGenericWithTable(ctx, columnName, (row, cn) -> {
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(cn));
        });
    }

    protected <T> void testTextDecodeGenericWithTable(TestContext ctx, String columnName, BiConsumer<Row, String> expected) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query("SELECT `" + columnName + "` FROM datatype WHERE id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            expected.accept(row, columnName);
            conn.close();
        }))));
    }

    protected <T> void testBinaryDecodeGenericWithTable(TestContext ctx, String columnName, T expected) {
        this.testBinaryDecodeGenericWithTable(ctx, columnName, (row, cn) -> {
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(cn));
        });
    }

    protected <T> void testBinaryDecodeGenericWithTable(TestContext ctx, String columnName, BiConsumer<Row, String> expected) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT `" + columnName + "` FROM datatype WHERE id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            expected.accept(row, columnName);
            conn.close();
        }))));
    }

    protected void testBinaryEncodeGeneric(TestContext ctx, String columnName, Object param, BiConsumer<Row, String> valueAccessor) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("UPDATE datatype SET `" + columnName + "` = ? WHERE id = 2").execute(Tuple.tuple().addValue(param), ctx.asyncAssertSuccess(updateResult -> conn.preparedQuery("SELECT `" + columnName + "` FROM datatype WHERE id = 2").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            valueAccessor.accept(row, columnName);
            conn.close();
        }))))));
    }

    protected <T> void testBinaryEncodeGeneric(TestContext ctx, String columnName, T expected) {
        this.testBinaryEncodeGeneric(ctx, columnName, expected, (row, cName) -> {
            ctx.assertEquals(expected, row.getValue(0));
            ctx.assertEquals(expected, row.getValue(columnName));
        });
    }

    protected void testBinaryDecode(TestContext ctx, String sql, Tuple params, Consumer<RowSet<Row>> checker) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(sql).execute(params, ctx.asyncAssertSuccess(result -> {
            checker.accept((RowSet<Row>)result);
            conn.close();
        }))));
    }

    protected void testBinaryDecode(TestContext ctx, String sql, Consumer<RowSet<Row>> checker) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery(sql).execute(ctx.asyncAssertSuccess(result -> {
            checker.accept((RowSet<Row>)result);
            conn.close();
        }))));
    }

    protected void testTextDecode(TestContext ctx, String sql, Consumer<RowSet<Row>> checker) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.query(sql).execute(ctx.asyncAssertSuccess(result -> {
            checker.accept((RowSet<Row>)result);
            conn.close();
        }))));
    }
}

