/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.data.MySQLDataTypeTestBase;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowIterator;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import java.math.BigDecimal;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class NumericDataTypeTest
extends MySQLDataTypeTestBase {
    @Test
    public void testBinaryEncodeCastShortToDecimal(TestContext ctx) {
        this.testBinaryDecode(ctx, "SELECT * FROM basicdatatype WHERE id = 1 AND test_decimal = ?", Tuple.of((Object)12345), result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            RowIterator iterator = result.iterator();
            Row row = (Row)iterator.next();
            ctx.assertEquals((Object)1, (Object)row.getInteger("id"));
            ctx.assertEquals((Object)Numeric.create((Number)12345), row.getValue("test_decimal"));
        });
    }

    @Test
    public void testBinaryEncodeCastLongToShort(TestContext ctx) {
        this.testBinaryDecode(ctx, "SELECT * FROM basicdatatype WHERE id = 1 AND test_int_2 = ?", Tuple.of((Object)32767L), result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            RowIterator iterator = result.iterator();
            Row row = (Row)iterator.next();
            ctx.assertEquals((Object)1, (Object)row.getInteger("id"));
            ctx.assertEquals((Object)Short.MAX_VALUE, row.getValue("test_int_2"));
        });
    }

    @Test
    public void testBinaryEncodeBigDecimal(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_unsigned_bigint", BigDecimal.valueOf(999999999L), (row, columnName) -> {
            ctx.assertEquals((Object)999999999L, (Object)row.getLong(columnName));
            ctx.assertEquals((Object)999999999L, (Object)row.getLong(columnName));
            ctx.assertEquals((Object)BigDecimal.valueOf(999999999L), (Object)row.getBigDecimal(columnName));
            ctx.assertEquals((Object)BigDecimal.valueOf(999999999L), (Object)row.getBigDecimal(columnName));
            ctx.assertEquals((Object)Numeric.parse((String)"999999999"), row.getValue(0));
            ctx.assertEquals((Object)Numeric.parse((String)"999999999"), row.getValue(columnName));
        });
    }

    @Test
    public void testBinaryDecodeUnsignedTinyInt(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_unsigned_tinyint", (row, columnName) -> {
            ctx.assertTrue(row.getValue(0) instanceof Short);
            ctx.assertEquals((Object)255, row.getValue(0));
            ctx.assertEquals((Object)255, row.getValue(columnName));
            ctx.assertEquals((Object)255, (Object)row.getShort(0));
            ctx.assertEquals((Object)255, (Object)row.getShort(columnName));
            ctx.assertEquals((Object)255, (Object)row.getInteger(0));
            ctx.assertEquals((Object)255, (Object)row.getInteger(columnName));
            ctx.assertEquals((Object)255L, (Object)row.getLong(0));
            ctx.assertEquals((Object)255L, (Object)row.getLong(columnName));
            ctx.assertEquals((Object)new BigDecimal(255), (Object)row.getBigDecimal(0));
            ctx.assertEquals((Object)new BigDecimal(255), (Object)row.getBigDecimal(columnName));
        });
    }

    @Test
    public void testBinaryEncodeUnsignedTinyInt(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_unsigned_tinyint", (short)128);
    }

    @Test
    public void testBinaryDecodeUnsignedSmallInt(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_unsigned_smallint", (row, columnName) -> {
            ctx.assertTrue(row.getValue(0) instanceof Integer);
            ctx.assertEquals((Object)65535, row.getValue(0));
            ctx.assertEquals((Object)65535, row.getValue(columnName));
            ctx.assertEquals((Object)65535, (Object)row.getInteger(0));
            ctx.assertEquals((Object)65535, (Object)row.getInteger(columnName));
            ctx.assertEquals((Object)65535L, (Object)row.getLong(0));
            ctx.assertEquals((Object)65535L, (Object)row.getLong(columnName));
            ctx.assertEquals((Object)new BigDecimal(65535), (Object)row.getBigDecimal(0));
            ctx.assertEquals((Object)new BigDecimal(65535), (Object)row.getBigDecimal(columnName));
        });
    }

    @Test
    public void testBinaryEncodeUnsignedSmallInt(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_unsigned_smallint", 32768);
    }

    @Test
    public void testBinaryDecodeUnsignedMediumInt(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_unsigned_mediumint", (row, columnName) -> {
            ctx.assertTrue(row.getValue(0) instanceof Integer);
            ctx.assertEquals((Object)0xFFFFFF, row.getValue(0));
            ctx.assertEquals((Object)0xFFFFFF, row.getValue(columnName));
            ctx.assertEquals((Object)0xFFFFFF, (Object)row.getInteger(0));
            ctx.assertEquals((Object)0xFFFFFF, (Object)row.getInteger(columnName));
            ctx.assertEquals((Object)0xFFFFFFL, (Object)row.getLong(0));
            ctx.assertEquals((Object)0xFFFFFFL, (Object)row.getLong(columnName));
            ctx.assertEquals((Object)new BigDecimal(0xFFFFFF), (Object)row.getBigDecimal(0));
            ctx.assertEquals((Object)new BigDecimal(0xFFFFFF), (Object)row.getBigDecimal(columnName));
        });
    }

    @Test
    public void testBinaryEncodeUnsignedMediumInt(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_unsigned_mediumint", 0x800000);
    }

    @Test
    public void testBinaryDecodeUnsignedInt(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_unsigned_int", (row, columnName) -> {
            ctx.assertTrue(row.getValue(0) instanceof Long);
            ctx.assertEquals((Object)0xFFFFFFFFL, row.getValue(0));
            ctx.assertEquals((Object)0xFFFFFFFFL, row.getValue(columnName));
            ctx.assertEquals((Object)0xFFFFFFFFL, (Object)row.getLong(0));
            ctx.assertEquals((Object)0xFFFFFFFFL, (Object)row.getLong(columnName));
            ctx.assertEquals((Object)new BigDecimal(0xFFFFFFFFL), (Object)row.getBigDecimal(0));
            ctx.assertEquals((Object)new BigDecimal(0xFFFFFFFFL), (Object)row.getBigDecimal(columnName));
        });
    }

    @Test
    public void testBinaryEncodeUnsignedInt(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_unsigned_int", 0x80000000L);
    }

    @Test
    public void testBinaryDecodeUnsignedBigInt(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_unsigned_bigint", (row, columnName) -> {
            ctx.assertTrue(row.getValue(0) instanceof Numeric);
            ctx.assertEquals((Object)Numeric.parse((String)"18446744073709551615"), row.getValue(0));
            ctx.assertEquals((Object)Numeric.parse((String)"18446744073709551615"), row.getValue(columnName));
            ctx.assertEquals((Object)Numeric.parse((String)"18446744073709551615"), row.get(Numeric.class, 0));
            ctx.assertEquals((Object)new BigDecimal("18446744073709551615"), (Object)row.getBigDecimal(0));
            ctx.assertEquals((Object)new BigDecimal("18446744073709551615"), (Object)row.getBigDecimal(columnName));
        });
    }

    @Test
    public void testBinaryEncodeUnsignedBigInt(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_unsigned_bigint", Numeric.parse((String)"9223372036854775808"));
    }

    @Test
    public void testTextDecodeUnsignedTinyInt(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_unsigned_tinyint", (row, columnName) -> {
            ctx.assertTrue(row.getValue(0) instanceof Short);
            ctx.assertEquals((Object)255, row.getValue(0));
            ctx.assertEquals((Object)255, row.getValue(columnName));
            ctx.assertEquals((Object)255, (Object)row.getShort(0));
            ctx.assertEquals((Object)255, (Object)row.getShort(columnName));
            ctx.assertEquals((Object)255, (Object)row.getInteger(0));
            ctx.assertEquals((Object)255, (Object)row.getInteger(columnName));
            ctx.assertEquals((Object)255L, (Object)row.getLong(0));
            ctx.assertEquals((Object)255L, (Object)row.getLong(columnName));
            ctx.assertEquals((Object)new BigDecimal(255), (Object)row.getBigDecimal(0));
            ctx.assertEquals((Object)new BigDecimal(255), (Object)row.getBigDecimal(columnName));
        });
    }

    @Test
    public void testTextDecodeUnsignedSmallInt(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_unsigned_smallint", (row, columnName) -> {
            ctx.assertTrue(row.getValue(0) instanceof Integer);
            ctx.assertEquals((Object)65535, row.getValue(0));
            ctx.assertEquals((Object)65535, row.getValue(columnName));
            ctx.assertEquals((Object)65535, (Object)row.getInteger(0));
            ctx.assertEquals((Object)65535, (Object)row.getInteger(columnName));
            ctx.assertEquals((Object)65535L, (Object)row.getLong(0));
            ctx.assertEquals((Object)65535L, (Object)row.getLong(columnName));
            ctx.assertEquals((Object)new BigDecimal(65535), (Object)row.getBigDecimal(0));
            ctx.assertEquals((Object)new BigDecimal(65535), (Object)row.getBigDecimal(columnName));
        });
    }

    @Test
    public void testTextDecodeUnsignedMediumInt(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_unsigned_mediumint", (row, columnName) -> {
            ctx.assertTrue(row.getValue(0) instanceof Integer);
            ctx.assertEquals((Object)0xFFFFFF, row.getValue(0));
            ctx.assertEquals((Object)0xFFFFFF, row.getValue(columnName));
            ctx.assertEquals((Object)0xFFFFFF, (Object)row.getInteger(0));
            ctx.assertEquals((Object)0xFFFFFF, (Object)row.getInteger(columnName));
            ctx.assertEquals((Object)0xFFFFFFL, (Object)row.getLong(0));
            ctx.assertEquals((Object)0xFFFFFFL, (Object)row.getLong(columnName));
            ctx.assertEquals((Object)new BigDecimal(0xFFFFFF), (Object)row.getBigDecimal(0));
            ctx.assertEquals((Object)new BigDecimal(0xFFFFFF), (Object)row.getBigDecimal(columnName));
        });
    }

    @Test
    public void testTextDecodeUnsignedInt(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_unsigned_int", (row, columnName) -> {
            ctx.assertTrue(row.getValue(0) instanceof Long);
            ctx.assertEquals((Object)0xFFFFFFFFL, row.getValue(0));
            ctx.assertEquals((Object)0xFFFFFFFFL, row.getValue(columnName));
            ctx.assertEquals((Object)0xFFFFFFFFL, (Object)row.getLong(0));
            ctx.assertEquals((Object)0xFFFFFFFFL, (Object)row.getLong(columnName));
            ctx.assertEquals((Object)new BigDecimal(0xFFFFFFFFL), (Object)row.getBigDecimal(0));
            ctx.assertEquals((Object)new BigDecimal(0xFFFFFFFFL), (Object)row.getBigDecimal(columnName));
        });
    }

    @Test
    public void testTextDecodeUnsignedBigInt(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_unsigned_bigint", (row, columnName) -> {
            ctx.assertTrue(row.getValue(0) instanceof Numeric);
            ctx.assertEquals((Object)Numeric.parse((String)"18446744073709551615"), row.getValue(0));
            ctx.assertEquals((Object)Numeric.parse((String)"18446744073709551615"), row.getValue(columnName));
            ctx.assertEquals((Object)Numeric.parse((String)"18446744073709551615"), row.get(Numeric.class, 0));
            ctx.assertEquals((Object)new BigDecimal("18446744073709551615"), (Object)row.getBigDecimal(0));
            ctx.assertEquals((Object)new BigDecimal("18446744073709551615"), (Object)row.getBigDecimal(columnName));
        });
    }
}

