/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.data.SpatialDataTypeCodecTestBase;
import io.vertx.mysqlclient.data.spatial.GeometryCollection;
import io.vertx.mysqlclient.data.spatial.LineString;
import io.vertx.mysqlclient.data.spatial.MultiLineString;
import io.vertx.mysqlclient.data.spatial.MultiPoint;
import io.vertx.mysqlclient.data.spatial.MultiPolygon;
import io.vertx.mysqlclient.data.spatial.Point;
import io.vertx.mysqlclient.data.spatial.Polygon;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.Tuple;
import java.util.ArrayList;
import java.util.function.Consumer;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class SpatialBinaryCodecTest
extends SpatialDataTypeCodecTestBase {
    @Override
    protected void testDecodeGeometry(TestContext ctx, String sql, Consumer<RowSet<Row>> checker) {
        this.testBinaryDecode(ctx, sql, checker);
    }

    @Test
    public void testEncodePoint(TestContext ctx) {
        Point point = new Point(0L, 1.5, 5.1);
        this.testBinaryEncodeGeometry(ctx, point, result -> {
            Row row = (Row)result.iterator().next();
            String text = row.getString(0);
            ctx.assertEquals((Object)"POINT(1.5 5.1)", (Object)text);
        });
    }

    @Test
    public void testEncodeLineString(TestContext ctx) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(0L, 1.1, 1.1));
        points.add(new Point(0L, 2.2, 2.2));
        LineString lineString = new LineString(0L, points);
        this.testBinaryEncodeGeometry(ctx, lineString, result -> {
            Row row = (Row)result.iterator().next();
            String text = row.getString(0);
            ctx.assertEquals((Object)"LINESTRING(1.1 1.1,2.2 2.2)", (Object)text);
        });
    }

    @Test
    public void testEncodePolygon(TestContext ctx) {
        ArrayList<Point> pointsOfFirstLineString = new ArrayList<Point>();
        pointsOfFirstLineString.add(new Point(0L, 0.0, 0.0));
        pointsOfFirstLineString.add(new Point(0L, 10.0, 0.0));
        pointsOfFirstLineString.add(new Point(0L, 10.0, 10.0));
        pointsOfFirstLineString.add(new Point(0L, 0.0, 10.0));
        pointsOfFirstLineString.add(new Point(0L, 0.0, 0.0));
        LineString firstLineString = new LineString(0L, pointsOfFirstLineString);
        ArrayList<Point> pointsOfSecondLineString = new ArrayList<Point>();
        pointsOfSecondLineString.add(new Point(0L, 5.0, 5.0));
        pointsOfSecondLineString.add(new Point(0L, 7.0, 5.0));
        pointsOfSecondLineString.add(new Point(0L, 7.0, 7.0));
        pointsOfSecondLineString.add(new Point(0L, 5.0, 7.0));
        pointsOfSecondLineString.add(new Point(0L, 5.0, 5.0));
        LineString secondLineString = new LineString(0L, pointsOfSecondLineString);
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        lineStrings.add(firstLineString);
        lineStrings.add(secondLineString);
        Polygon polygon = new Polygon(0L, lineStrings);
        this.testBinaryEncodeGeometry(ctx, polygon, result -> {
            Row row = (Row)result.iterator().next();
            String text = row.getString(0);
            ctx.assertEquals((Object)"POLYGON((0 0,10 0,10 10,0 10,0 0),(5 5,7 5,7 7,5 7,5 5))", (Object)text);
        });
    }

    @Test
    public void testEncodeMultiPoint(TestContext ctx) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.add(new Point(0L, 0.0, 0.0));
        points.add(new Point(0L, 1.0, 1.0));
        points.add(new Point(0L, 2.0, 2.0));
        MultiPoint multiPoint = new MultiPoint(0L, points);
        this.testBinaryEncodeGeometry(ctx, multiPoint, result -> {
            Row row = (Row)result.iterator().next();
            String text = row.getString(0);
            boolean expected1 = "MULTIPOINT(0 0,1 1,2 2)".equals(text);
            boolean expected2 = "MULTIPOINT((0 0),(1 1),(2 2))".equals(text);
            ctx.assertTrue(expected1 || expected2);
        });
    }

    @Test
    public void testEncodeMultiLineString(TestContext ctx) {
        ArrayList<Point> pointsOfFirstLineString = new ArrayList<Point>();
        pointsOfFirstLineString.add(new Point(0L, 1.0, 1.0));
        pointsOfFirstLineString.add(new Point(0L, 2.0, 2.0));
        pointsOfFirstLineString.add(new Point(0L, 3.0, 3.0));
        LineString firstLineString = new LineString(0L, pointsOfFirstLineString);
        ArrayList<Point> pointsOfSecondLineString = new ArrayList<Point>();
        pointsOfSecondLineString.add(new Point(0L, 4.0, 4.0));
        pointsOfSecondLineString.add(new Point(0L, 5.0, 5.0));
        LineString secondLineString = new LineString(0L, pointsOfSecondLineString);
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        lineStrings.add(firstLineString);
        lineStrings.add(secondLineString);
        MultiLineString multiLineString = new MultiLineString(0L, lineStrings);
        this.testBinaryEncodeGeometry(ctx, multiLineString, result -> {
            Row row = (Row)result.iterator().next();
            String text = row.getString(0);
            ctx.assertEquals((Object)"MULTILINESTRING((1 1,2 2,3 3),(4 4,5 5))", (Object)text);
        });
    }

    @Test
    public void testEncodeMultiPolygon(TestContext ctx) {
        ArrayList<Point> pointsOfFirstLineStringOfFirstPolygon = new ArrayList<Point>();
        pointsOfFirstLineStringOfFirstPolygon.add(new Point(0L, 0.0, 0.0));
        pointsOfFirstLineStringOfFirstPolygon.add(new Point(0L, 0.0, 3.0));
        pointsOfFirstLineStringOfFirstPolygon.add(new Point(0L, 3.0, 3.0));
        pointsOfFirstLineStringOfFirstPolygon.add(new Point(0L, 3.0, 0.0));
        pointsOfFirstLineStringOfFirstPolygon.add(new Point(0L, 0.0, 0.0));
        LineString firstLineString = new LineString(0L, pointsOfFirstLineStringOfFirstPolygon);
        ArrayList<Point> pointsOfSecondLineStringOfFirstPolygon = new ArrayList<Point>();
        pointsOfSecondLineStringOfFirstPolygon.add(new Point(0L, 1.0, 1.0));
        pointsOfSecondLineStringOfFirstPolygon.add(new Point(0L, 1.0, 2.0));
        pointsOfSecondLineStringOfFirstPolygon.add(new Point(0L, 2.0, 2.0));
        pointsOfSecondLineStringOfFirstPolygon.add(new Point(0L, 2.0, 1.0));
        pointsOfSecondLineStringOfFirstPolygon.add(new Point(0L, 1.0, 1.0));
        LineString secondLineString = new LineString(0L, pointsOfSecondLineStringOfFirstPolygon);
        ArrayList<LineString> lineStrings = new ArrayList<LineString>();
        lineStrings.add(firstLineString);
        lineStrings.add(secondLineString);
        Polygon polygon = new Polygon(0L, lineStrings);
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        polygons.add(polygon);
        MultiPolygon multiPolygon = new MultiPolygon(0L, polygons);
        this.testBinaryEncodeGeometry(ctx, multiPolygon, result -> {
            Row row = (Row)result.iterator().next();
            String text = row.getString(0);
            ctx.assertEquals((Object)"MULTIPOLYGON(((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1)))", (Object)text);
        });
    }

    @Test
    public void testEncodeGeometryCollection(TestContext ctx) {
        Point point = new Point(0L, 1.0, 1.0);
        Point firstPointOfLineString = new Point(0L, 2.0, 2.0);
        Point secondPointOfLineString = new Point(0L, 3.0, 3.0);
        ArrayList<Point> pointsOfLineString = new ArrayList<Point>();
        pointsOfLineString.add(firstPointOfLineString);
        pointsOfLineString.add(secondPointOfLineString);
        LineString lineString = new LineString(0L, pointsOfLineString);
        ArrayList<Object> geometries = new ArrayList<Object>();
        geometries.add(point);
        geometries.add(lineString);
        GeometryCollection geometryCollection = new GeometryCollection(0L, geometries);
        this.testBinaryEncodeGeometry(ctx, geometryCollection, result -> {
            Row row = (Row)result.iterator().next();
            String text = row.getString(0);
            ctx.assertEquals((Object)"GEOMETRYCOLLECTION(POINT(1 1),LINESTRING(2 2,3 3))", (Object)text);
        });
    }

    private void testBinaryEncodeGeometry(TestContext ctx, Object param, Consumer<RowSet<Row>> checker) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT ST_AsText(ST_GeomFromWKB(?)) AS test_geometry;").execute(Tuple.of((Object)param), ctx.asyncAssertSuccess(res -> {
            checker.accept((RowSet<Row>)res);
            conn.close();
        }))));
    }
}

