/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.ext.unit.TestContext;
import io.vertx.mysqlclient.data.MySQLDataTypeTestBase;
import io.vertx.mysqlclient.data.spatial.GeometryCollection;
import io.vertx.mysqlclient.data.spatial.LineString;
import io.vertx.mysqlclient.data.spatial.MultiLineString;
import io.vertx.mysqlclient.data.spatial.MultiPoint;
import io.vertx.mysqlclient.data.spatial.MultiPolygon;
import io.vertx.mysqlclient.data.spatial.Point;
import io.vertx.mysqlclient.data.spatial.Polygon;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import java.util.List;
import java.util.function.Consumer;
import org.junit.Test;

public abstract class SpatialDataTypeCodecTestBase
extends MySQLDataTypeTestBase {
    @Test
    public void testDecodePoint(TestContext ctx) {
        this.testDecodeGeometry(ctx, "SELECT ST_GeometryFromText('POINT(1.5 5.1)', 0) AS test_geometry;", result -> {
            Row row = (Row)result.iterator().next();
            Point point = (Point)row.get(Point.class, 0);
            ctx.assertEquals((Object)0L, (Object)point.getSRID());
            ctx.assertEquals((Object)1.5, (Object)point.getX());
            ctx.assertEquals((Object)5.1, (Object)point.getY());
        });
    }

    @Test
    public void testDecodeLineString(TestContext ctx) {
        this.testDecodeGeometry(ctx, "SELECT ST_GeometryFromText('LINESTRING(0 0,1 1,2 2)', 0) AS test_geometry;", result -> {
            Row row = (Row)result.iterator().next();
            LineString lineString = (LineString)row.get(LineString.class, 0);
            ctx.assertEquals((Object)0L, (Object)lineString.getSRID());
            List points = lineString.getPoints();
            ctx.assertEquals((Object)3, (Object)points.size());
            ctx.assertEquals((Object)0.0, (Object)((Point)points.get(0)).getX());
            ctx.assertEquals((Object)0.0, (Object)((Point)points.get(0)).getY());
            ctx.assertEquals((Object)1.0, (Object)((Point)points.get(1)).getX());
            ctx.assertEquals((Object)1.0, (Object)((Point)points.get(1)).getY());
            ctx.assertEquals((Object)2.0, (Object)((Point)points.get(2)).getX());
            ctx.assertEquals((Object)2.0, (Object)((Point)points.get(2)).getY());
        });
    }

    @Test
    public void testDecodePolygon(TestContext ctx) {
        this.testDecodeGeometry(ctx, "SELECT ST_GeometryFromText('POLYGON((0 0,10 0,10 10,0 10,0 0),(5 5,7 5,7 7,5 7,5 5))', 0) AS test_geometry;", result -> {
            Row row = (Row)result.iterator().next();
            Polygon polygon = (Polygon)row.get(Polygon.class, 0);
            ctx.assertEquals((Object)0L, (Object)polygon.getSRID());
            List lineStrings = polygon.getLineStrings();
            ctx.assertEquals((Object)2, (Object)lineStrings.size());
            List pointsOfFirstLineString = ((LineString)lineStrings.get(0)).getPoints();
            ctx.assertEquals((Object)5, (Object)pointsOfFirstLineString.size());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(0)).getX());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(0)).getY());
            ctx.assertEquals((Object)10.0, (Object)((Point)pointsOfFirstLineString.get(1)).getX());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(1)).getY());
            ctx.assertEquals((Object)10.0, (Object)((Point)pointsOfFirstLineString.get(2)).getX());
            ctx.assertEquals((Object)10.0, (Object)((Point)pointsOfFirstLineString.get(2)).getY());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(3)).getX());
            ctx.assertEquals((Object)10.0, (Object)((Point)pointsOfFirstLineString.get(3)).getY());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(4)).getX());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(4)).getY());
            List pointsOfSecondLineString = ((LineString)lineStrings.get(1)).getPoints();
            ctx.assertEquals((Object)5, (Object)pointsOfSecondLineString.size());
            ctx.assertEquals((Object)5.0, (Object)((Point)pointsOfSecondLineString.get(0)).getX());
            ctx.assertEquals((Object)5.0, (Object)((Point)pointsOfSecondLineString.get(0)).getY());
            ctx.assertEquals((Object)7.0, (Object)((Point)pointsOfSecondLineString.get(1)).getX());
            ctx.assertEquals((Object)5.0, (Object)((Point)pointsOfSecondLineString.get(1)).getY());
            ctx.assertEquals((Object)7.0, (Object)((Point)pointsOfSecondLineString.get(2)).getX());
            ctx.assertEquals((Object)7.0, (Object)((Point)pointsOfSecondLineString.get(2)).getY());
            ctx.assertEquals((Object)5.0, (Object)((Point)pointsOfSecondLineString.get(3)).getX());
            ctx.assertEquals((Object)7.0, (Object)((Point)pointsOfSecondLineString.get(3)).getY());
            ctx.assertEquals((Object)5.0, (Object)((Point)pointsOfSecondLineString.get(4)).getX());
            ctx.assertEquals((Object)5.0, (Object)((Point)pointsOfSecondLineString.get(4)).getY());
        });
    }

    @Test
    public void testDecodeMultiPoint(TestContext ctx) {
        this.testDecodeGeometry(ctx, "SELECT ST_GeometryFromText('MULTIPOINT(0 0,1 1,2 2)', 0) AS test_geometry;", result -> {
            Row row = (Row)result.iterator().next();
            MultiPoint multiPoint = (MultiPoint)row.get(MultiPoint.class, 0);
            ctx.assertEquals((Object)0L, (Object)multiPoint.getSRID());
            List points = multiPoint.getPoints();
            ctx.assertEquals((Object)3, (Object)points.size());
            ctx.assertEquals((Object)0.0, (Object)((Point)points.get(0)).getX());
            ctx.assertEquals((Object)0.0, (Object)((Point)points.get(0)).getY());
            ctx.assertEquals((Object)1.0, (Object)((Point)points.get(1)).getX());
            ctx.assertEquals((Object)1.0, (Object)((Point)points.get(1)).getY());
            ctx.assertEquals((Object)2.0, (Object)((Point)points.get(2)).getX());
            ctx.assertEquals((Object)2.0, (Object)((Point)points.get(2)).getY());
        });
    }

    @Test
    public void testDecodeMultiLineString(TestContext ctx) {
        this.testDecodeGeometry(ctx, "SELECT ST_GeometryFromText('MULTILINESTRING((1 1,2 2,3 3),(4 4,5 5))', 0) AS test_geometry;", result -> {
            Row row = (Row)result.iterator().next();
            MultiLineString multiLineString = (MultiLineString)row.get(MultiLineString.class, 0);
            ctx.assertEquals((Object)0L, (Object)multiLineString.getSRID());
            List lineStrings = multiLineString.getLineStrings();
            ctx.assertEquals((Object)2, (Object)lineStrings.size());
            List pointsOfFirstLineString = ((LineString)lineStrings.get(0)).getPoints();
            ctx.assertEquals((Object)3, (Object)pointsOfFirstLineString.size());
            ctx.assertEquals((Object)1.0, (Object)((Point)pointsOfFirstLineString.get(0)).getX());
            ctx.assertEquals((Object)1.0, (Object)((Point)pointsOfFirstLineString.get(0)).getY());
            ctx.assertEquals((Object)2.0, (Object)((Point)pointsOfFirstLineString.get(1)).getX());
            ctx.assertEquals((Object)2.0, (Object)((Point)pointsOfFirstLineString.get(1)).getY());
            ctx.assertEquals((Object)3.0, (Object)((Point)pointsOfFirstLineString.get(2)).getX());
            ctx.assertEquals((Object)3.0, (Object)((Point)pointsOfFirstLineString.get(2)).getY());
            List pointsOfSecondLineString = ((LineString)lineStrings.get(1)).getPoints();
            ctx.assertEquals((Object)2, (Object)pointsOfSecondLineString.size());
            ctx.assertEquals((Object)4.0, (Object)((Point)pointsOfSecondLineString.get(0)).getX());
            ctx.assertEquals((Object)4.0, (Object)((Point)pointsOfSecondLineString.get(0)).getY());
            ctx.assertEquals((Object)5.0, (Object)((Point)pointsOfSecondLineString.get(1)).getX());
            ctx.assertEquals((Object)5.0, (Object)((Point)pointsOfSecondLineString.get(1)).getY());
        });
    }

    @Test
    public void testDecodeMultiPolygon(TestContext ctx) {
        this.testDecodeGeometry(ctx, "SELECT ST_GeometryFromText('MULTIPOLYGON(((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1)))', 0) AS test_geometry;", result -> {
            Row row = (Row)result.iterator().next();
            MultiPolygon multiPolygon = (MultiPolygon)row.get(MultiPolygon.class, 0);
            ctx.assertEquals((Object)0L, (Object)multiPolygon.getSRID());
            List polygons = multiPolygon.getPolygons();
            ctx.assertEquals((Object)1, (Object)polygons.size());
            Polygon polygon = (Polygon)polygons.get(0);
            List lineStrings = polygon.getLineStrings();
            ctx.assertEquals((Object)2, (Object)lineStrings.size());
            List pointsOfFirstLineString = ((LineString)lineStrings.get(0)).getPoints();
            ctx.assertEquals((Object)5, (Object)pointsOfFirstLineString.size());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(0)).getX());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(0)).getY());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(1)).getX());
            ctx.assertEquals((Object)3.0, (Object)((Point)pointsOfFirstLineString.get(1)).getY());
            ctx.assertEquals((Object)3.0, (Object)((Point)pointsOfFirstLineString.get(2)).getX());
            ctx.assertEquals((Object)3.0, (Object)((Point)pointsOfFirstLineString.get(2)).getY());
            ctx.assertEquals((Object)3.0, (Object)((Point)pointsOfFirstLineString.get(3)).getX());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(3)).getY());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(4)).getX());
            ctx.assertEquals((Object)0.0, (Object)((Point)pointsOfFirstLineString.get(4)).getY());
            List pointsOfSecondLineString = ((LineString)lineStrings.get(1)).getPoints();
            ctx.assertEquals((Object)5, (Object)pointsOfSecondLineString.size());
            ctx.assertEquals((Object)1.0, (Object)((Point)pointsOfSecondLineString.get(0)).getX());
            ctx.assertEquals((Object)1.0, (Object)((Point)pointsOfSecondLineString.get(0)).getY());
            ctx.assertEquals((Object)1.0, (Object)((Point)pointsOfSecondLineString.get(1)).getX());
            ctx.assertEquals((Object)2.0, (Object)((Point)pointsOfSecondLineString.get(1)).getY());
            ctx.assertEquals((Object)2.0, (Object)((Point)pointsOfSecondLineString.get(2)).getX());
            ctx.assertEquals((Object)2.0, (Object)((Point)pointsOfSecondLineString.get(2)).getY());
            ctx.assertEquals((Object)2.0, (Object)((Point)pointsOfSecondLineString.get(3)).getX());
            ctx.assertEquals((Object)1.0, (Object)((Point)pointsOfSecondLineString.get(3)).getY());
            ctx.assertEquals((Object)1.0, (Object)((Point)pointsOfSecondLineString.get(4)).getX());
            ctx.assertEquals((Object)1.0, (Object)((Point)pointsOfSecondLineString.get(4)).getY());
        });
    }

    @Test
    public void testDecodeGeometryCollection(TestContext ctx) {
        this.testDecodeGeometry(ctx, "SELECT ST_GeometryFromText('GEOMETRYCOLLECTION(Point(1 1),LineString(2 2, 3 3))', 0) AS test_geometry;", result -> {
            Row row = (Row)result.iterator().next();
            GeometryCollection geometryCollection = (GeometryCollection)row.get(GeometryCollection.class, 0);
            ctx.assertEquals((Object)0L, (Object)geometryCollection.getSRID());
            List geometries = geometryCollection.getGeometries();
            ctx.assertEquals((Object)2, (Object)geometries.size());
            ctx.assertTrue(geometries.get(0) instanceof Point);
            Point firstGeometry = (Point)geometries.get(0);
            ctx.assertEquals((Object)1.0, (Object)firstGeometry.getX());
            ctx.assertEquals((Object)1.0, (Object)firstGeometry.getY());
            ctx.assertTrue(geometries.get(1) instanceof LineString);
            LineString secondGeometry = (LineString)geometries.get(1);
            List pointsOfSecondGeometry = secondGeometry.getPoints();
            ctx.assertEquals((Object)2, (Object)pointsOfSecondGeometry.size());
            ctx.assertEquals((Object)2.0, (Object)((Point)pointsOfSecondGeometry.get(0)).getX());
            ctx.assertEquals((Object)2.0, (Object)((Point)pointsOfSecondGeometry.get(0)).getY());
            ctx.assertEquals((Object)3.0, (Object)((Point)pointsOfSecondGeometry.get(1)).getY());
            ctx.assertEquals((Object)3.0, (Object)((Point)pointsOfSecondGeometry.get(1)).getY());
        });
    }

    protected abstract void testDecodeGeometry(TestContext var1, String var2, Consumer<RowSet<Row>> var3);
}

