/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.data;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.data.MySQLDataTypeTestBase;
import io.vertx.sqlclient.Row;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class StringDataTypeTest
extends MySQLDataTypeTestBase {
    @Test
    public void testBinaryDecodeAll(TestContext ctx) {
        MySQLConnection.connect((Vertx)this.vertx, (MySQLConnectOptions)this.options, (Handler)ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT * FROM datatype WHERE id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)1, row.getValue(0));
            ctx.assertEquals((Object)Buffer.buffer((String)"HELLO"), row.getValue(1));
            ctx.assertEquals((Object)Buffer.buffer((String)"HELLO, WORLD"), row.getValue(2));
            ctx.assertEquals((Object)Buffer.buffer((String)"TINYBLOB"), row.getValue(3));
            ctx.assertEquals((Object)Buffer.buffer((String)"BLOB"), row.getValue(4));
            ctx.assertEquals((Object)Buffer.buffer((String)"MEDIUMBLOB"), row.getValue(5));
            ctx.assertEquals((Object)Buffer.buffer((String)"LONGBLOB"), row.getValue(6));
            ctx.assertEquals((Object)"TINYTEXT", row.getValue(7));
            ctx.assertEquals((Object)"TEXT", row.getValue(8));
            ctx.assertEquals((Object)"MEDIUMTEXT", row.getValue(9));
            ctx.assertEquals((Object)"LONGTEXT", row.getValue(10));
            ctx.assertEquals((Object)"small", row.getValue(11));
            ctx.assertEquals((Object)"a,b", row.getValue(12));
            conn.close();
        }))));
    }

    @Test
    public void testTextDecodeBinary(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "Binary", Buffer.buffer((String)"HELLO"));
    }

    @Test
    public void testBinaryDecodeBinary(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "Binary", Buffer.buffer((String)"HELLO"));
    }

    @Test
    public void testBinaryEncodeBinary(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "Binary", Buffer.buffer((String)"HELLO"));
    }

    @Test
    public void testBinaryEncodeVarBinary(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "VarBinary", Buffer.buffer((String)"HELLO, WORLD"));
    }

    @Test
    public void testTextDecodeVarBinary(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "VarBinary", Buffer.buffer((String)"HELLO, WORLD"));
    }

    @Test
    public void testBinaryDecodeVarBinary(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "VarBinary", Buffer.buffer((String)"HELLO, WORLD"));
    }

    @Test
    public void testBinaryEncodeTinyBlob(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "TinyBlob", Buffer.buffer((String)"TINYBLOB"));
    }

    @Test
    public void testTextDecodeTinyBlob(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "TinyBlob", Buffer.buffer((String)"TINYBLOB"));
    }

    @Test
    public void testBinaryDecodeTinyBlob(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "TinyBlob", Buffer.buffer((String)"TINYBLOB"));
    }

    @Test
    public void testBinaryEncodeBlob(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "Blob", Buffer.buffer((String)"BLOB"));
    }

    @Test
    public void testTextDecodeBlob(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "Blob", Buffer.buffer((String)"BLOB"));
    }

    @Test
    public void testTextDecodeBlobDoesNotLeakDirectBuffer(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "Blob", (row, columnName) -> {
            boolean isDirectBuffer = ((Buffer)row.getValue(0)).getByteBuf().isDirect();
            ctx.assertFalse(isDirectBuffer);
        });
    }

    @Test
    public void testBinaryDecodeBlob(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "Blob", Buffer.buffer((String)"BLOB"));
    }

    @Test
    public void testBinaryDecodeBlobDoesNotLeakDirectBuffer(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "Blob", (row, columnName) -> {
            boolean isDirectBuffer = ((Buffer)row.getValue(0)).getByteBuf().isDirect();
            ctx.assertFalse(isDirectBuffer);
        });
    }

    @Test
    public void testBinaryEncodeMediumBlob(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "MediumBlob", Buffer.buffer((String)"MEDIUMBLOB"));
    }

    @Test
    public void testTextDecodeMediumBlob(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "MediumBlob", Buffer.buffer((String)"MEDIUMBLOB"));
    }

    @Test
    public void testBinaryDecodeMediumBlob(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "MediumBlob", Buffer.buffer((String)"MEDIUMBLOB"));
    }

    @Test
    public void testBinaryEncodeLongBlob(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "LongBlob", Buffer.buffer((String)"LONGBLOB"));
    }

    @Test
    public void testTextDecodeLongBlob(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "LongBlob", Buffer.buffer((String)"LONGBLOB"));
    }

    @Test
    public void testBinaryDecodeLongBlob(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "LongBlob", Buffer.buffer((String)"LONGBLOB"));
    }

    @Test
    public void testBinaryEncodeTinyText(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "TinyText", "TINYTEXT");
    }

    @Test
    public void testTextDecodeTinyText(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "TinyText", "TINYTEXT");
    }

    @Test
    public void testBinaryDecodeTinyText(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "TinyText", "TINYTEXT");
    }

    @Test
    public void testBinaryEncodeText(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "Text", "TEXT");
    }

    @Test
    public void testTextDecodeText(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "Text", "TEXT");
    }

    @Test
    public void testBinaryDecodeText(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "Text", "TEXT");
    }

    @Test
    public void testBinaryEncodeMediumText(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "MediumText", "MEDIUMTEXT");
    }

    @Test
    public void testTextDecodeMediumText(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "MediumText", "MEDIUMTEXT");
    }

    @Test
    public void testBinaryDecodeMediumText(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "MediumText", "MEDIUMTEXT");
    }

    @Test
    public void testBinaryEncodeLongText(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "LongText", "LONGTEXT");
    }

    @Test
    public void testTextDecodeLongText(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "LongText", "LONGTEXT");
    }

    @Test
    public void testBinaryDecodeLongText(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "LongText", "LONGTEXT");
    }

    @Test
    public void testBinaryEncodeEnumWithString(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_enum", "medium");
    }

    @Test
    public void testTextDecodeEnumToString(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_enum", "small");
    }

    @Test
    public void testBinaryDecodeEnumToString(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_enum", "small");
    }

    @Test
    public void testBinaryEncodeEnumWithJavaEnum(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_enum", (Object)Size.medium, (row, colName) -> {
            ctx.assertEquals((Object)Size.medium, row.get(Size.class, colName));
            ctx.assertEquals((Object)Size.medium, row.get(Size.class, 0));
        });
    }

    @Test
    public void testTextDecodeEnumToJavaEnum(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_enum", (row, colName) -> {
            ctx.assertEquals((Object)Size.small, row.get(Size.class, colName));
            ctx.assertEquals((Object)Size.small, row.get(Size.class, 0));
        });
    }

    @Test
    public void testBinaryDecodeEnumToJavaEnum(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_enum", (row, colName) -> {
            ctx.assertEquals((Object)Size.small, row.get(Size.class, colName));
            ctx.assertEquals((Object)Size.small, row.get(Size.class, 0));
        });
    }

    @Test
    public void testBinaryEncodeSet(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_set", "a,b,c");
    }

    @Test
    public void testTextDecodeSet(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_set", "a,b");
    }

    @Test
    public void testBinaryDecodeSet(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_set", "a,b");
    }

    @Test
    public void testBinaryEncodeVarcharBinary(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_varchar_binary", "Hello, world!");
    }

    @Test
    public void testTextDecodeVarcharBinary(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_varchar_binary", "VARCHAR binary");
    }

    @Test
    public void testBinaryDecodeVarcharBinary(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_varchar_binary", "VARCHAR binary");
    }

    @Test
    public void testBinaryEncodeVarcharWithBinaryCollation(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_varchar_with_binary_collation", Buffer.buffer((String)"Hello, world!"));
    }

    @Test
    public void testTextDecodeVarcharWithBinaryCollation(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_varchar_with_binary_collation", Buffer.buffer((String)"VARCHAR with binary collation"));
    }

    @Test
    public void testBinaryDecodeVarcharWithBinaryCollation(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_varchar_with_binary_collation", Buffer.buffer((String)"VARCHAR with binary collation"));
    }

    @Test
    public void testBinaryEncodeTextBinary(TestContext ctx) {
        this.testBinaryEncodeGeneric(ctx, "test_text_binary", "Hello, world!");
    }

    @Test
    public void testTextDecodeTextBinary(TestContext ctx) {
        this.testTextDecodeGenericWithTable(ctx, "test_text_binary", "TEXT binary");
    }

    @Test
    public void testBinaryDecodeTextBinary(TestContext ctx) {
        this.testBinaryDecodeGenericWithTable(ctx, "test_text_binary", "TEXT binary");
    }

    private static enum Size {
        x_small,
        small,
        medium,
        large,
        x_large;

    }
}

