/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.impl;

import io.vertx.core.json.JsonObject;
import io.vertx.mysqlclient.impl.MySQLConnectionUriParser;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.junit.Assert;
import org.junit.Test;

public class MySQLConnectionUriParserTest {
    private String uri;
    private JsonObject actualParsedResult;
    private JsonObject expectedParsedResult;

    @Test
    public void testParsingUriSchemeDesignator() {
        this.uri = "mysql://localhost";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingMariaDBUriSchemeDesignator() {
        this.uri = "mariadb://localhost";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUriSchemeDesignator() {
        this.uri = "mysqle://localhost";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingUserWithoutPassword() {
        this.uri = "mysql://user@localhost";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingUserWithEmptyPassword() {
        this.uri = "mysql://user:@localhost";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("password", (Object)"").put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingUserWithPassword() {
        this.uri = "mysql://user:secret@localhost";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user").put("password", (Object)"secret").put("host", (Object)"localhost");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingPasswordWithoutUser() {
        this.uri = "mysql://:secret@localhost";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingHostName() {
        this.uri = "mysql://vertx.io";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"vertx.io");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingIpv4Address() {
        this.uri = "mysql://192.168.1.1";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"192.168.1.1");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingIpv6Address() {
        this.uri = "mysql://[2001:db8::1234]";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"2001:db8::1234");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingPort() {
        this.uri = "mysql://localhost:1234";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingSchemaName() {
        this.uri = "mysql://localhost/mydb";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("database", (Object)"mydb");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingOneAttribute() {
        this.uri = "mysql://localhost?user=other";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("user", (Object)"other");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingParameters() {
        this.uri = "mysql://localhost?user=other&password=secret&port=1234";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("user", (Object)"other").put("password", (Object)"secret").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingHostWithPort() {
        this.uri = "mysql://localhost:1234";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"localhost").put("port", (Object)1234);
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingEncodedSchema() {
        this.uri = "mysql://user_name@198.51.100.2:3306/world%5Fx";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user_name").put("host", (Object)"198.51.100.2").put("port", (Object)3306).put("database", (Object)"world_x");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingHostSocket() throws UnsupportedEncodingException {
        this.uri = "mysql://user_name@" + URLEncoder.encode("/var/run/mysql/mysql.sock", "UTF-8") + ":3306/world%5Fx";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user_name").put("host", (Object)"/var/run/mysql/mysql.sock").put("port", (Object)3306).put("database", (Object)"world_x");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingSocketAttribute() throws UnsupportedEncodingException {
        this.uri = "mysql://localhost?socket=" + URLEncoder.encode("/var/run/mysql/mysql.sock", "UTF-8");
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("host", (Object)"/var/run/mysql/mysql.sock");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri1() {
        this.uri = "mysql://us@er@@";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri2() {
        this.uri = "mysql://user/mydb//";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri3() {
        this.uri = "mysql:///dbname/?host=localhost";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri4() {
        this.uri = "mysql://user::1234";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri5() {
        this.uri = "mysql://@:1234";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri6() {
        this.uri = "mysql://:123:";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testParsingInvalidUri7() {
        this.uri = "mysql://@@/dbname?host";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingUserInfoContainExclamationMark() {
        this.uri = "mysql://user!name:dd!dd@127.0.0.1:3306/dbname";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingSchemaContainExclamationMark() {
        this.uri = "mysql://username:dddd@127.0.0.1:3306/!dbname";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
    }

    @Test
    public void testParsingUserInfoContainAsterisk() {
        this.uri = "mysql://user*name:dd*dd@127.0.0.1:1234/dbname";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"user*name").put("password", (Object)"dd*dd").put("host", (Object)"127.0.0.1").put("port", (Object)1234).put("database", (Object)"dbname");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testParsingSchemaContainAsterisk() {
        this.uri = "mysql://username:dddd@127.0.0.1:1234/*dbname";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri);
        this.expectedParsedResult = new JsonObject().put("user", (Object)"username").put("password", (Object)"dddd").put("host", (Object)"127.0.0.1").put("port", (Object)1234).put("database", (Object)"*dbname");
        Assert.assertEquals((Object)this.expectedParsedResult, (Object)this.actualParsedResult);
    }

    @Test
    public void testPartialMatching() {
        this.uri = "not_mysql://username:dddd@127.0.0.1:1234/*dbname";
        this.actualParsedResult = MySQLConnectionUriParser.parse((String)this.uri, (boolean)false);
        Assert.assertNull((Object)this.actualParsedResult);
    }
}

