/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.junit;

import com.github.dockerjava.api.model.Ulimit;
import io.vertx.mysqlclient.MySQLConnectOptions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.junit.rules.ExternalResource;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;

public class MySQLRule
extends ExternalResource {
    private static final String connectionUri = System.getProperty("connection.uri");
    private static final String tlsConnectionUri = System.getProperty("tls.connection.uri");
    private Network network;
    private GenericContainer<?> server;
    private MySQLConnectOptions options;
    private DatabaseServerInfo databaseServerInfo;
    private File mysqldDir;
    private boolean ssl;
    public static final MySQLRule SHARED_INSTANCE = new MySQLRule();
    public static final MySQLRule SHARED_TLS_INSTANCE = new MySQLRule().ssl(true);

    public MySQLRule ssl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public synchronized MySQLConnectOptions startServer() throws Exception {
        this.initServer();
        this.server.start();
        return new MySQLConnectOptions().setPort(this.server.getMappedPort(3306).intValue()).setHost(this.server.getContainerIpAddress()).setDatabase("testschema").setUser("mysql").setPassword("password");
    }

    public synchronized void stopServer() throws Exception {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            finally {
                this.server = null;
            }
        }
    }

    private void initServer() throws IOException {
        this.network = Network.builder().driver("bridge").build();
        this.server = new GenericContainer(this.databaseServerInfo.getDatabaseType().toDockerImageName() + ":" + this.databaseServerInfo.getDockerImageTag()).withEnv("MYSQL_USER", "mysql").withEnv("MYSQL_PASSWORD", "password").withEnv("MYSQL_ROOT_PASSWORD", "password").withEnv("MYSQL_DATABASE", "testschema").withCreateContainerCmdModifier(createContainerCmd -> createContainerCmd.getHostConfig().withUlimits(new Ulimit[]{new Ulimit("nofile", 262144L, 262144L)})).withNetwork(this.network).withNetworkAliases(new String[]{this.networkAlias()}).withExposedPorts(new Integer[]{3306}).withClasspathResourceMapping("init.sql", "/docker-entrypoint-initdb.d/init.sql", BindMode.READ_ONLY).withReuse(true);
        this.mysqldDir = Files.createTempDirectory("mysqld", new FileAttribute[0]).toFile();
        this.mysqldDir.deleteOnExit();
        this.mysqldDir.setReadable(true, false);
        this.mysqldDir.setWritable(true, false);
        this.mysqldDir.setExecutable(true, false);
        this.server.withFileSystemBind(this.mysqldDir.getAbsolutePath(), "/var/run/mysqld");
        if (this.ssl) {
            this.server.withClasspathResourceMapping("tls/conf", "/etc/mysql/conf.d", BindMode.READ_ONLY);
            this.server.withClasspathResourceMapping("tls/files", "/etc/mysql/tls", BindMode.READ_ONLY);
        } else {
            this.server.withClasspathResourceMapping("tls/files", "/etc/mysql/tls", BindMode.READ_ONLY);
            String cmd = "--disable-ssl --max_allowed_packet=33554432 --max_prepared_stmt_count=1024 --local_infile=true --character-set-server=utf8mb4 --collation-server=utf8mb4_general_ci";
            if (this.isUsingMySQL8()) {
                cmd = cmd + " --caching-sha2-password-public-key-path=/etc/mysql/tls/public_key.pem --caching-sha2-password-private-key-path=/etc/mysql/tls/private_key.pem";
            }
            this.server.withCommand(cmd);
        }
    }

    public String network() {
        return this.network != null ? this.network.getId() : "mysql_default";
    }

    public String networkAlias() {
        return this.network != null ? Integer.toHexString(System.identityHashCode((Object)this)) : "test-mysql";
    }

    private static DatabaseType parseDatabaseTypeString(String databaseInfo) throws IllegalArgumentException {
        switch (databaseInfo.toLowerCase()) {
            case "mysql": {
                return DatabaseType.MySQL;
            }
            case "mariadb": {
                return DatabaseType.MariaDB;
            }
        }
        throw new IllegalArgumentException("Unknown database: " + databaseInfo);
    }

    public static boolean isTestingWithExternalDatabase() {
        return MySQLRule.isSystemPropertyValid(connectionUri);
    }

    public static boolean isTlsTestingWithExternalDatabase() {
        return MySQLRule.isSystemPropertyValid(tlsConnectionUri);
    }

    private static boolean isSystemPropertyValid(String systemProperty) {
        return systemProperty != null && !systemProperty.isEmpty();
    }

    public boolean isUsingMariaDB() {
        return this.databaseServerInfo.getDatabaseType() == DatabaseType.MariaDB;
    }

    public boolean isUsingMySQL5_6() {
        return this.databaseServerInfo == DatabaseServerInfo.MySQL_V5_6;
    }

    public boolean isUsingMySQL8() {
        return this.databaseServerInfo == DatabaseServerInfo.MySQL_V8_0;
    }

    public MySQLConnectOptions options() {
        return new MySQLConnectOptions(this.options);
    }

    public String domainSocketPath() {
        return new File(this.mysqldDir, "mysqld.sock").getAbsolutePath();
    }

    protected void before() throws Throwable {
        if (MySQLRule.isTestingWithExternalDatabase() && !this.ssl) {
            this.options = MySQLConnectOptions.fromUri((String)connectionUri);
            this.databaseServerInfo = DatabaseServerInfo.EXTERNAL;
            return;
        }
        if (MySQLRule.isTlsTestingWithExternalDatabase() && this.ssl) {
            this.options = MySQLConnectOptions.fromUri((String)tlsConnectionUri);
            this.databaseServerInfo = DatabaseServerInfo.EXTERNAL;
            return;
        }
        if (this.server != null) {
            return;
        }
        String databaseTypeString = System.getProperty("testing.mysql.database.server");
        DatabaseType databaseType = MySQLRule.isSystemPropertyValid(databaseTypeString) ? MySQLRule.parseDatabaseTypeString(databaseTypeString) : DatabaseType.MySQL;
        String databaseVersionString = System.getProperty("testing.mysql.database.version");
        if (MySQLRule.isSystemPropertyValid(databaseVersionString)) {
            this.databaseServerInfo = DatabaseServerInfo.valueOf(databaseType, databaseVersionString);
        } else if (databaseType == DatabaseType.MySQL) {
            this.databaseServerInfo = DatabaseServerInfo.MySQL_V5_7;
        } else if (databaseType == DatabaseType.MariaDB) {
            this.databaseServerInfo = DatabaseServerInfo.MariaDB_V10_4;
        } else {
            throw new IllegalStateException("Unimplemented default version for: " + (Object)((Object)databaseType));
        }
        this.options = this.startServer();
    }

    protected void after() {
        if (!MySQLRule.isTestingWithExternalDatabase()) {
            try {
                if (this != SHARED_INSTANCE) {
                    this.stopServer();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static enum DatabaseServerInfo {
        MySQL_V5_6(DatabaseType.MySQL, "5.6"),
        MySQL_V5_7(DatabaseType.MySQL, "5.7"),
        MySQL_V8_0(DatabaseType.MySQL, "8.0"),
        MySQL_LATEST(DatabaseType.MySQL, "latest"),
        MariaDB_V10_4(DatabaseType.MariaDB, "10.4"),
        MariaDB_LATEST(DatabaseType.MariaDB, "latest"),
        EXTERNAL(null, null);

        private final DatabaseType databaseType;
        private final String dockerImageTag;

        private DatabaseServerInfo(DatabaseType databaseType, String dockerImageTag) {
            this.databaseType = databaseType;
            this.dockerImageTag = dockerImageTag;
        }

        public String getDockerImageTag() {
            return this.dockerImageTag;
        }

        public DatabaseType getDatabaseType() {
            return this.databaseType;
        }

        public static DatabaseServerInfo valueOf(DatabaseType databaseType, String dockerImageTag) {
            switch (databaseType) {
                case MySQL: {
                    if (dockerImageTag.startsWith("5.6")) {
                        return MySQL_V5_6;
                    }
                    if (dockerImageTag.startsWith("5.7")) {
                        return MySQL_V5_7;
                    }
                    if (dockerImageTag.startsWith("8")) {
                        return MySQL_V8_0;
                    }
                    if (dockerImageTag.equalsIgnoreCase("latest")) {
                        return MySQL_LATEST;
                    }
                    throw new IllegalArgumentException("Unsupported docker image tag for MySQL server, tag: " + dockerImageTag);
                }
                case MariaDB: {
                    if (dockerImageTag.startsWith("10.4")) {
                        return MariaDB_V10_4;
                    }
                    if (!dockerImageTag.equalsIgnoreCase("latest")) break;
                    return MariaDB_LATEST;
                }
            }
            throw new IllegalStateException("Unsupported database type: " + databaseType.toDockerImageName());
        }
    }

    private static enum DatabaseType {
        MySQL,
        MariaDB;


        public String toDockerImageName() {
            return this.name().toLowerCase();
        }
    }
}

