/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.junit;

import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.junit.MySQLRule;
import java.util.concurrent.TimeUnit;
import org.junit.rules.ExternalResource;
import org.testcontainers.containers.Container;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

public class ProxySQLRule
extends ExternalResource {
    private static final String MONITORING_USER = "proxysql";
    private static final String MONITORING_USER_PASSWORD = "proxysql1234#";
    private final MySQLRule mySQLRule;
    private GenericContainer<?> proxySql;

    public ProxySQLRule(MySQLRule mySQLRule) {
        this.mySQLRule = mySQLRule;
    }

    protected void before() throws Throwable {
        this.proxySql = new GenericContainer("proxysql/proxysql").withCreateContainerCmdModifier(createContainerCmd -> createContainerCmd.getHostConfig().withNetworkMode(this.mySQLRule.network())).withExposedPorts(new Integer[]{6032, 6033, 6070}).waitingFor((WaitStrategy)Wait.forLogMessage((String)".*Latest ProxySQL version available.*\\n", (int)1));
        this.proxySql.start();
        this.execStatement("UPDATE global_variables SET variable_value='false' WHERE variable_name='admin-hash_passwords'", 10);
        this.execStatement("LOAD ADMIN VARIABLES TO RUNTIME");
        this.execStatement(String.format("UPDATE global_variables SET variable_value='%s' WHERE variable_name='mysql-monitor_username'", MONITORING_USER));
        this.execStatement(String.format("UPDATE global_variables SET variable_value='%s' WHERE variable_name='mysql-monitor_password'", MONITORING_USER_PASSWORD));
        this.execStatement("LOAD MYSQL VARIABLES TO RUNTIME");
        this.execStatement(String.format("INSERT INTO mysql_servers(hostgroup_id, hostname, port) VALUES (0,'%s',3306)", this.mySQLRule.networkAlias()));
        this.execStatement("LOAD MYSQL SERVERS TO RUNTIME");
        this.execStatement(String.format("INSERT INTO mysql_users (username,password) VALUES ('%s','%s')", this.mySQLRule.options().getUser(), this.mySQLRule.options().getPassword()));
        this.execStatement("LOAD MYSQL USERS TO RUNTIME");
    }

    private void execStatement(String statement) throws Exception {
        this.execStatement(statement, 0);
    }

    private void execStatement(String statement, int retry) throws Exception {
        Container.ExecResult result;
        int i = 0;
        while (true) {
            if ((result = this.proxySql.execInContainer(new String[]{"mysql", "-u", "admin", "-padmin", "-h", "127.0.0.1", "-P", "6032", "-e", statement})).getExitCode() == 0) {
                return;
            }
            if (i >= retry && !result.getStderr().contains("ERROR 2002")) break;
            TimeUnit.MILLISECONDS.sleep(200L);
            ++i;
        }
        RuntimeException failure = new RuntimeException("Failed to execute statement: " + statement + "\n" + result.getStderr());
        throw failure;
    }

    public MySQLConnectOptions options(MySQLConnectOptions other) {
        return new MySQLConnectOptions(other).setHost(this.proxySql.getHost()).setPort(this.proxySql.getMappedPort(6033).intValue());
    }

    protected void after() {
        if (this.proxySql != null) {
            this.proxySql.stop();
        }
    }
}

