/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.tck;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.mysqlclient.MySQLConnectOptions;
import io.vertx.mysqlclient.MySQLConnection;
import io.vertx.mysqlclient.MySQLPool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.tck.Connector;

public enum ClientConfig {
    CONNECT{

        Connector<SqlConnection> connect(final Vertx vertx, final SqlConnectOptions options) {
            return new Connector<SqlConnection>(){

                public void connect(Handler<AsyncResult<SqlConnection>> handler) {
                    MySQLConnection.connect((Vertx)vertx, (MySQLConnectOptions)new MySQLConnectOptions(options), ar -> {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    });
                }

                public void close() {
                }
            };
        }
    }
    ,
    POOLED{

        Connector<SqlConnection> connect(Vertx vertx, SqlConnectOptions options) {
            final MySQLPool pool = MySQLPool.pool((Vertx)vertx, (MySQLConnectOptions)new MySQLConnectOptions(options), (PoolOptions)new PoolOptions().setMaxSize(1));
            return new Connector<SqlConnection>(){

                public void connect(Handler<AsyncResult<SqlConnection>> handler) {
                    pool.getConnection(ar -> {
                        if (ar.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
                        }
                    });
                }

                public void close() {
                    pool.close();
                }
            };
        }
    };


    abstract <C extends SqlClient> Connector<C> connect(Vertx var1, SqlConnectOptions var2);
}

