/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.tck;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.junit.MySQLRule;
import io.vertx.mysqlclient.tck.ClientConfig;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.tck.BinaryDataTypeDecodeTestBase;
import java.sql.JDBCType;
import java.time.Duration;
import java.time.LocalDate;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLBinaryDataTypeDecodeTest
extends BinaryDataTypeDecodeTestBase {
    @ClassRule
    public static MySQLRule rule = MySQLRule.SHARED_INSTANCE;

    protected JDBCType getNumericJDBCType() {
        return JDBCType.DECIMAL;
    }

    protected Class<? extends Number> getNumericClass() {
        return Numeric.class;
    }

    protected Number getNumericValue(Number value) {
        return Numeric.create((Number)value);
    }

    protected Number getNumericValue(String value) {
        return Numeric.parse((String)value);
    }

    protected void initConnector() {
        this.connector = ClientConfig.CONNECT.connect(this.vertx, (SqlConnectOptions)rule.options());
    }

    @Test
    public void testBoolean(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT test_boolean FROM basicdatatype WHERE id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)true, (Object)row.getBoolean(0));
            ctx.assertEquals((Object)true, (Object)row.getBoolean("test_boolean"));
            ctx.assertEquals((Object)1, row.getValue(0));
            ctx.assertEquals((Object)1, row.getValue("test_boolean"));
        }))));
    }

    @Test
    public void testTime(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_time", Duration.class, JDBCType.TIME, Duration.ofHours(18L).plusMinutes(45L).plusSeconds(2L));
    }

    @Test
    public void testSelectAll(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.preparedQuery("SELECT test_int_2,test_int_4,test_int_8,test_float_4,test_float_8,test_numeric,test_decimal,test_boolean,test_char,test_varchar,test_date,test_time from basicdatatype where id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)12, (Object)row.size());
            ctx.assertEquals((Object)Short.MAX_VALUE, (Object)row.getShort(0));
            ctx.assertEquals((Object)Short.MAX_VALUE, (Object)row.getShort("test_int_2"));
            ctx.assertEquals((Object)Integer.MAX_VALUE, (Object)row.getInteger(1));
            ctx.assertEquals((Object)Integer.MAX_VALUE, (Object)row.getInteger("test_int_4"));
            ctx.assertEquals((Object)Long.MAX_VALUE, (Object)row.getLong(2));
            ctx.assertEquals((Object)Long.MAX_VALUE, (Object)row.getLong("test_int_8"));
            ctx.assertEquals((Object)Float.valueOf(3.40282E38f), (Object)row.getFloat(3));
            ctx.assertEquals((Object)Float.valueOf(3.40282E38f), (Object)row.getFloat("test_float_4"));
            ctx.assertEquals((Object)Double.MAX_VALUE, (Object)row.getDouble(4));
            ctx.assertEquals((Object)Double.MAX_VALUE, (Object)row.getDouble("test_float_8"));
            ctx.assertEquals((Object)Numeric.create((Number)999.99), row.get(Numeric.class, 5));
            ctx.assertEquals((Object)Numeric.create((Number)999.99), row.getValue("test_numeric"));
            ctx.assertEquals((Object)Numeric.create((Number)12345), row.get(Numeric.class, 6));
            ctx.assertEquals((Object)Numeric.create((Number)12345), row.getValue("test_decimal"));
            ctx.assertEquals((Object)true, (Object)row.getBoolean(7));
            ctx.assertEquals((Object)true, (Object)row.getBoolean("test_boolean"));
            ctx.assertEquals((Object)"testchar", (Object)row.getString(8));
            ctx.assertEquals((Object)"testchar", (Object)row.getString("test_char"));
            ctx.assertEquals((Object)"testvarchar", (Object)row.getString(9));
            ctx.assertEquals((Object)"testvarchar", (Object)row.getString("test_varchar"));
            ctx.assertEquals((Object)LocalDate.parse("2019-01-01"), row.getValue(10));
            ctx.assertEquals((Object)LocalDate.parse("2019-01-01"), row.getValue("test_date"));
            ctx.assertEquals((Object)Duration.ofHours(18L).plusMinutes(45L).plusSeconds(2L), row.getValue(11));
            ctx.assertEquals((Object)Duration.ofHours(18L).plusMinutes(45L).plusSeconds(2L), row.getValue("test_time"));
            conn.close();
        }))));
    }
}

