/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.tck;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.junit.MySQLRule;
import io.vertx.mysqlclient.tck.ClientConfig;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import io.vertx.sqlclient.tck.ConnectionTestBase;
import org.junit.ClassRule;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLConnectionTest
extends ConnectionTestBase {
    @ClassRule
    public static MySQLRule rule = MySQLRule.SHARED_INSTANCE;

    public void setUp() throws Exception {
        super.setUp();
        this.options = rule.options();
        this.connector = ClientConfig.CONNECT.connect(this.vertx, this.options);
    }

    public void tearDown(TestContext ctx) {
        this.connector.close();
        super.tearDown(ctx);
    }

    protected void validateDatabaseMetaData(TestContext ctx, DatabaseMetadata md) {
        if (rule.isUsingMariaDB()) {
            ctx.assertEquals((Object)"MariaDB", (Object)md.productName());
            ctx.assertTrue(md.majorVersion() >= 10, "Expected DB major version >= 10 but was " + md.majorVersion());
        } else if (rule.isUsingMySQL5_6()) {
            ctx.assertEquals((Object)"MySQL", (Object)md.productName());
            ctx.assertEquals((Object)5, (Object)md.majorVersion());
            ctx.assertEquals((Object)6, (Object)md.minorVersion());
        } else if (rule.isUsingMySQL8()) {
            ctx.assertEquals((Object)"MySQL", (Object)md.productName());
            ctx.assertEquals((Object)8, (Object)md.majorVersion());
            ctx.assertEquals((Object)0, (Object)md.minorVersion());
        } else {
            ctx.assertFalse(md.fullVersion().isEmpty());
        }
    }
}

