/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mysqlclient.tck;

import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.mysqlclient.junit.MySQLRule;
import io.vertx.mysqlclient.tck.ClientConfig;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.tck.TextDataTypeDecodeTestBase;
import java.sql.JDBCType;
import java.time.Duration;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class MySQLTextDataTypeDecodeTest
extends TextDataTypeDecodeTestBase {
    @ClassRule
    public static MySQLRule rule = MySQLRule.SHARED_INSTANCE;

    protected JDBCType getNumericJDBCType() {
        return JDBCType.DECIMAL;
    }

    protected Class<? extends Number> getNumericClass() {
        return Numeric.class;
    }

    protected Number getNumericValue(Number value) {
        return Numeric.create((Number)value);
    }

    protected Number getNumericValue(String value) {
        return Numeric.parse((String)value);
    }

    protected void initConnector() {
        this.connector = ClientConfig.CONNECT.connect(this.vertx, (SqlConnectOptions)rule.options());
    }

    @Test
    public void testBoolean(TestContext ctx) {
        this.connector.connect(ctx.asyncAssertSuccess(conn -> conn.query("SELECT test_boolean FROM basicdatatype WHERE id = 1").execute(ctx.asyncAssertSuccess(result -> {
            ctx.assertEquals((Object)1, (Object)result.size());
            Row row = (Row)result.iterator().next();
            ctx.assertEquals((Object)true, (Object)row.getBoolean(0));
            ctx.assertEquals((Object)true, (Object)row.getBoolean("test_boolean"));
            ctx.assertEquals((Object)1, row.getValue(0));
            ctx.assertEquals((Object)1, row.getValue("test_boolean"));
        }))));
    }

    @Test
    public void testTime(TestContext ctx) {
        this.testDecodeGeneric(ctx, "test_time", Duration.class, Duration.ofHours(18L).plusMinutes(45L).plusSeconds(2L));
    }
}

