/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.core.AsyncResult;
import io.vertx.test.redis.AbstractRedisClientBase;
import org.junit.Test;

public class NullableTest
extends AbstractRedisClientBase {
    private static final String notExistsKey = "notExistsKey";

    @Test
    public void testGetNullable() {
        this.makeSureKeyNotExists(() -> this.redis.get(notExistsKey, this::handle));
        this.await();
    }

    @Test
    public void testGetBinaryNullable() {
        this.makeSureKeyNotExists(() -> this.redis.getBinary(notExistsKey, asyncResult -> {
            if (asyncResult.failed()) {
                this.fail(asyncResult.cause());
            } else {
                this.assertNull(asyncResult.result());
                this.testComplete();
            }
        }));
        this.await();
    }

    @Test
    public void testGetSetNullable() {
        this.makeSureKeyNotExists(() -> this.redis.getset(notExistsKey, "value", this::handle));
        this.await();
    }

    @Test
    public void testHGetNullable() {
        this.makeSureKeyNotExists(() -> {
            String notExistsField = "notExistsField";
            this.redis.hget(notExistsKey, notExistsField, this::handle);
        });
        this.await();
    }

    @Test
    public void testLPopNullable() {
        this.makeSureKeyNotExists(() -> this.redis.lpop(notExistsKey, this::handle));
        this.await();
    }

    @Test
    public void testSPopNullable() {
        this.makeSureKeyNotExists(() -> this.redis.spop(notExistsKey, this::handle));
        this.await();
    }

    private void makeSureKeyNotExists(Runnable task) {
        this.redis.del(notExistsKey, r -> {
            if (r.failed()) {
                this.fail(r.cause());
            } else {
                task.run();
            }
        });
    }

    private void handle(AsyncResult<String> asyncResult) {
        if (asyncResult.failed()) {
            this.fail(asyncResult.cause());
        } else {
            this.assertNull(asyncResult.result());
            this.testComplete();
        }
    }
}

