/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.core.Vertx;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.test.redis.AbstractRedisClientBase;
import org.junit.Test;
import redis.embedded.RedisServer;

public class RedisAuthRecoverTest
extends AbstractRedisClientBase {
    @Test
    public void testAutoAuth() throws Exception {
        RedisServer server = RedisServer.builder().port(Integer.valueOf(6381)).setting("requirepass foobar").build();
        server.start();
        RedisOptions job = new RedisOptions().setHost("localhost").setPort(6381).setAuth("foobar");
        RedisClient rdx = RedisClient.create((Vertx)this.vertx, (RedisOptions)job);
        String key = RedisAuthRecoverTest.makeKey();
        rdx.set(key, "1", set -> {
            this.assertTrue(set.succeeded());
            rdx.get(key, get -> {
                this.assertTrue(get.succeeded());
                this.assertEquals("1", get.result());
                try {
                    server.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.testComplete();
            });
        });
        this.await();
    }

    @Test
    public void testRecover() {
        RedisServer server = RedisServer.builder().port(Integer.valueOf(6381)).setting("requirepass foobar").build();
        server.start();
        RedisOptions job = new RedisOptions().setHost("localhost").setPort(6381).setAuth("foobar");
        RedisClient rdx = RedisClient.create((Vertx)this.vertx, (RedisOptions)job);
        String key = RedisAuthRecoverTest.makeKey();
        rdx.set(key, "1", set -> {
            this.assertTrue(set.succeeded());
            server.stop();
            server.start();
            rdx.get(key, x -> this.vertx.runOnContext(v -> rdx.get(key, get -> {
                this.assertTrue(get.succeeded());
                try {
                    server.stop();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.testComplete();
            })));
        });
        this.await();
    }
}

