/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.sentinel.RedisSentinel;
import io.vertx.test.redis.RedisSentinelClientTestBase;
import java.util.concurrent.CountDownLatch;

public class RedisSentinelTest
extends RedisSentinelClientTestBase {
    public void setUp() throws Exception {
        super.setUp();
        CountDownLatch latch = new CountDownLatch(1);
        Handler blockingCodeHandler = future -> {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                future.complete();
            }
        };
        this.vertx.executeBlocking(blockingCodeHandler, asyncResult -> {
            this.redisSentinel = RedisSentinel.create((Vertx)this.vertx, (RedisOptions)this.getSentinelConfig());
            latch.countDown();
        });
        this.awaitLatch(latch);
    }

    public void tearDown() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        this.redisSentinel.close(asyncResult -> {
            if (!asyncResult.succeeded()) {
                throw new RuntimeException("failed to setup", asyncResult.cause());
            }
            latch.countDown();
        });
        this.awaitLatch(latch);
        super.tearDown();
    }
}

