/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

final class ArrayQueue {
    private int cur;
    private int front;
    private int back;
    private final Object[] queue;

    ArrayQueue(int capacity) {
        this.queue = new Object[capacity];
        this.back = -1;
        this.front = 0;
    }

    boolean isEmpty() {
        return this.cur == 0;
    }

    <T> void offer(T value) {
        if (this.isFull()) {
            throw new IndexOutOfBoundsException();
        }
        ++this.back;
        if (this.back == Integer.MAX_VALUE) {
            this.back = 0;
        }
        this.queue[this.back % this.queue.length] = value;
        ++this.cur;
    }

    <T> T peek() {
        if (this.isEmpty()) {
            return null;
        }
        return (T)this.queue[this.front % this.queue.length];
    }

    <T> T poll() {
        T e = this.peek();
        this.queue[this.front % this.queue.length] = null;
        ++this.front;
        if (this.front == Integer.MAX_VALUE) {
            this.front = 0;
        }
        --this.cur;
        return e;
    }

    int freeSlots() {
        return this.queue.length - this.cur;
    }

    boolean isFull() {
        return this.cur == this.queue.length;
    }
}

