/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.ArrayStack;
import io.vertx.redis.client.impl.ParserHandler;
import io.vertx.redis.client.impl.ReadableBuffer;
import io.vertx.redis.client.impl.types.BulkType;
import io.vertx.redis.client.impl.types.ErrorType;
import io.vertx.redis.client.impl.types.IntegerType;
import io.vertx.redis.client.impl.types.MultiType;
import io.vertx.redis.client.impl.types.SimpleStringType;
import java.nio.charset.StandardCharsets;

public final class RESPParser
implements Handler<Buffer> {
    private static final long MAX_STRING_LENGTH = 0x20000000L;
    private final ParserHandler handler;
    private final ReadableBuffer buffer = new ReadableBuffer();
    private final ArrayStack stack;
    private boolean eol = true;
    private int bytesNeeded = 0;

    RESPParser(ParserHandler handler, int maxStack) {
        this.handler = handler;
        this.stack = new ArrayStack(maxStack);
    }

    public void handle(Buffer chunk) {
        this.buffer.append(chunk);
        block12: while (this.buffer.readableBytes() >= (this.eol ? 3 : this.bytesNeeded + 2)) {
            this.buffer.mark();
            if (this.eol) {
                byte type = this.buffer.readByte();
                int start = this.buffer.offset();
                int eol = this.buffer.findLineEnd();
                if (eol == -1) {
                    this.buffer.reset();
                    break;
                }
                if (type == 13 && start == eol) {
                    if (this.buffer.skip(1)) continue;
                    this.buffer.reset();
                    break;
                }
                switch (type) {
                    case 43: {
                        int length = eol - start;
                        if (length == 2 && this.buffer.getByte(start) == 79 && this.buffer.getByte(start + 1) == 75) {
                            this.handleResponse(SimpleStringType.OK);
                            continue block12;
                        }
                        this.handleResponse(SimpleStringType.create(this.buffer.readLine(eol, StandardCharsets.ISO_8859_1)));
                        continue block12;
                    }
                    case 45: {
                        this.handleResponse(ErrorType.create(this.buffer.readLine(eol, StandardCharsets.ISO_8859_1)));
                        continue block12;
                    }
                    case 36: 
                    case 42: 
                    case 58: {
                        long integer;
                        try {
                            integer = this.buffer.readLong(eol);
                        }
                        catch (RuntimeException e) {
                            this.handler.fatal(e);
                            return;
                        }
                        switch (type) {
                            case 58: {
                                this.handleResponse(IntegerType.create(integer));
                                break;
                            }
                            case 36: {
                                if (integer > 0x20000000L) {
                                    this.handler.fatal(ErrorType.create("ILLEGAL_STATE Redis Bulk cannot be larger than 512MB"));
                                    return;
                                }
                                if (integer < 0L) {
                                    if (integer == -1L) {
                                        this.handleResponse(null);
                                        break;
                                    }
                                    this.handler.fatal(ErrorType.create("ILLEGAL_STATE Redis Bulk cannot have negative length"));
                                    return;
                                }
                                this.bytesNeeded = (int)integer;
                                this.eol = false;
                                break;
                            }
                            case 42: {
                                if (integer > Integer.MAX_VALUE) {
                                    this.handler.fatal(ErrorType.create("ILLEGAL_STATE Redis Multi cannot be larger 2GB elements"));
                                    return;
                                }
                                if (integer < 0L) {
                                    if (integer == -1L) {
                                        this.handleResponse(null);
                                        break;
                                    }
                                    this.handler.fatal(ErrorType.create("ILLEGAL_STATE Redis Multi cannot have negative length"));
                                }
                                if (integer == 0L) {
                                    this.handleResponse(MultiType.EMPTY);
                                    break;
                                }
                                this.handleResponse(MultiType.create((int)integer), true);
                            }
                        }
                        continue block12;
                    }
                }
                this.handler.fatal(ErrorType.create("ILLEGAL_STATE Unknown RESP type " + (char)type));
                return;
            }
            if (this.bytesNeeded == 0) {
                this.handleResponse(BulkType.EMPTY);
            } else {
                this.handleResponse(BulkType.create(this.buffer.readBytes(this.bytesNeeded)));
            }
            if (this.buffer.skip(2)) {
                this.eol = true;
                continue;
            }
            this.buffer.reset();
        }
    }

    private void handleResponse(Response response) {
        this.handleResponse(response, false);
    }

    private void handleResponse(Response response, boolean push) {
        MultiType multi = (MultiType)this.stack.peek();
        if (multi != null) {
            multi.add(response);
            if (push) {
                this.stack.push(response);
            } else {
                MultiType m = multi;
                while (m.complete()) {
                    this.stack.pop();
                    if (this.stack.empty()) {
                        this.handler.handle(m);
                        return;
                    }
                    m = (MultiType)this.stack.peek();
                    if (m != null) continue;
                    this.handler.fatal(ErrorType.create("ILLEGAL_STATE Multi can't be null"));
                    return;
                }
            }
        } else if (push) {
            this.stack.push(response);
        } else {
            this.handler.handle(response);
        }
    }
}

