/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class RedisURI {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 6379;
    private final String connectionString;
    private final SocketAddress socketAddress;
    private final String password;
    private final Integer select;

    public RedisURI(String connectionString) {
        this.connectionString = connectionString;
        try {
            String[] userInfoArray;
            URI uri = new URI(connectionString);
            String host = uri.getHost() == null ? DEFAULT_HOST : uri.getHost();
            int port = uri.getPort() == -1 ? 6379 : uri.getPort();
            String path = uri.getPath() == null || uri.getPath().isEmpty() ? "/" : uri.getPath();
            Map<String, String> query = RedisURI.parseQuery(uri);
            switch (uri.getScheme()) {
                case "rediss": 
                case "redis": {
                    this.socketAddress = SocketAddress.inetSocketAddress((int)port, (String)host);
                    if (path.length() > 1) {
                        this.select = Integer.parseInt(uri.getPath().substring(1));
                        break;
                    }
                    if (query.containsKey("db")) {
                        this.select = Integer.parseInt(query.get("db"));
                        break;
                    }
                    this.select = null;
                    break;
                }
                case "unix": {
                    this.socketAddress = SocketAddress.domainSocketAddress((String)path);
                    if (query.containsKey("db")) {
                        this.select = Integer.parseInt(query.get("db"));
                        break;
                    }
                    this.select = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported Redis connection string scheme [" + uri.getScheme() + "]");
                }
            }
            String userInfo = uri.getUserInfo();
            this.password = userInfo != null ? ((userInfoArray = userInfo.split(":")).length > 0 ? userInfoArray[userInfoArray.length - 1] : (String)query.getOrDefault("password", null)) : (String)query.getOrDefault("password", null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to parse the connection string", e);
        }
    }

    private static Map<String, String> parseQuery(URI uri) {
        if (uri.getQuery() != null) {
            HashMap<String, String> query = new HashMap<String, String>();
            for (String kv : uri.getQuery().split("&")) {
                int eq = kv.indexOf(61);
                if (eq == -1) continue;
                query.put(kv.substring(0, eq), kv.substring(eq + 1));
            }
            return query;
        }
        return Collections.emptyMap();
    }

    public SocketAddress socketAddress() {
        return this.socketAddress;
    }

    public String password() {
        return this.password;
    }

    public Integer select() {
        return this.select;
    }

    public String connectionString() {
        return this.connectionString;
    }

    public String toString() {
        return this.connectionString;
    }
}

