/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.op;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;

@Deprecated
@DataObject
public class SetOptions {
    public static final SetOptions NONE = new SetOptions();
    private Long ex;
    private Long px;
    private Boolean nx;
    private Boolean xx;

    public SetOptions() {
    }

    public SetOptions(SetOptions obj) {
        this.ex = obj.ex;
        this.px = obj.px;
        this.nx = obj.nx;
        this.xx = obj.xx;
    }

    public SetOptions(JsonObject json) {
        Boolean bval;
        Long lval = json.getLong("ex");
        if (lval != null) {
            this.ex = lval;
        }
        if ((lval = json.getLong("px")) != null) {
            this.px = lval;
        }
        if ((bval = json.getBoolean("nx")) != null) {
            this.nx = bval;
        }
        if ((bval = json.getBoolean("xx")) != null) {
            this.xx = bval;
        }
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        if (this.ex != null) {
            json.put("ex", this.ex);
        }
        if (this.px != null) {
            json.put("px", this.px);
        }
        if (this.nx != null && this.nx.booleanValue()) {
            json.put("nx", this.nx);
        }
        if (this.xx != null && this.xx.booleanValue()) {
            json.put("xx", this.xx);
        }
        return json;
    }

    public SetOptions setEX(long seconds) {
        if (this.px != null) {
            throw new IllegalStateException("PX is already set - can't have both");
        }
        this.ex = seconds;
        return this;
    }

    public SetOptions setPX(long millis) {
        if (this.ex != null) {
            throw new IllegalStateException("EX is already set - can't have both");
        }
        this.px = millis;
        return this;
    }

    public SetOptions setNX(boolean unlessExists) {
        if (!unlessExists) {
            this.nx = null;
        }
        if (this.xx != null && this.xx.booleanValue()) {
            throw new IllegalStateException("XX is already set - can't have both");
        }
        this.nx = unlessExists;
        return this;
    }

    public SetOptions setXX(boolean onlyIfExists) {
        if (!onlyIfExists) {
            this.xx = null;
        }
        if (this.nx != null && this.nx.booleanValue()) {
            throw new IllegalStateException("NX is already set - can't have both");
        }
        this.xx = onlyIfExists;
        return this;
    }

    public JsonArray toJsonArray() {
        JsonArray result = new JsonArray();
        if (this.ex != null) {
            result.add("EX").add(this.ex);
        }
        if (this.px != null) {
            result.add("PX").add(this.px);
        }
        if (this.nx != null && this.nx.booleanValue()) {
            result.add("NX");
        }
        if (this.xx != null && this.xx.booleanValue()) {
            result.add("XX");
        }
        return result;
    }
}

