/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.impl.RequestImpl;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.junit.Test;

public class BufferTest {
    private static final int iterations = 50000;

    @Test
    public void testAppendString() {
        Request hmset = Request.cmd((Command)Command.HMSET);
        String key = "mykey";
        for (int i = 0; i < 50000; ++i) {
            hmset.arg(key).arg(i);
        }
        System.out.println(((RequestImpl)hmset).encode().length());
        for (int j = 0; j < 5; ++j) {
            long t0 = System.nanoTime();
            hmset = Request.cmd((Command)Command.HMSET);
            for (int i = 0; i < 50000; ++i) {
                hmset.arg(key).arg(i);
            }
            long t1 = System.nanoTime();
            System.out.println(((RequestImpl)hmset).encode().length() + "| t " + (t1 - t0));
        }
        System.out.println("---");
    }

    @Test
    public void testAppendBytes() {
        Request hmset = Request.cmd((Command)Command.HMSET);
        byte[] key = "my-key".getBytes(StandardCharsets.US_ASCII);
        for (int i = 0; i < 50000; ++i) {
            hmset.arg(key).arg(i);
        }
        System.out.println(((RequestImpl)hmset).encode().length());
        for (int j = 0; j < 5; ++j) {
            long t0 = System.nanoTime();
            hmset = Request.cmd((Command)Command.HMSET);
            for (int i = 0; i < 50000; ++i) {
                hmset.arg(key).arg(i);
            }
            long t1 = System.nanoTime();
            System.out.println(((RequestImpl)hmset).encode().length() + "| t " + (t1 - t0));
        }
        System.out.println("---");
    }

    @Test
    public void testAppendBuffer() {
        Request hmset = Request.cmd((Command)Command.HMSET);
        Buffer key = Buffer.buffer((String)"my-key");
        for (int i = 0; i < 50000; ++i) {
            hmset.arg(key).arg(i);
        }
        System.out.println(((RequestImpl)hmset).encode().length());
        for (int j = 0; j < 5; ++j) {
            long t0 = System.nanoTime();
            hmset = Request.cmd((Command)Command.HMSET);
            for (int i = 0; i < 50000; ++i) {
                hmset.arg(key).arg(i);
            }
            long t1 = System.nanoTime();
            System.out.println(((RequestImpl)hmset).encode().length() + "| t " + (t1 - t0));
        }
        System.out.println("---");
    }

    @Test
    public void testAppendStringToBytes() {
        Request hmset = Request.cmd((Command)Command.HMSET);
        String key = "mykey";
        for (int i = 0; i < 50000; ++i) {
            hmset.arg(key.getBytes()).arg(i);
        }
        System.out.println(((RequestImpl)hmset).encode().length());
        for (int j = 0; j < 5; ++j) {
            long t0 = System.nanoTime();
            hmset = Request.cmd((Command)Command.HMSET);
            for (int i = 0; i < 50000; ++i) {
                hmset.arg(key.getBytes()).arg(i);
            }
            long t1 = System.nanoTime();
            System.out.println(((RequestImpl)hmset).encode().length() + "| t " + (t1 - t0));
        }
        System.out.println("---");
    }

    @Test
    public void testAppendBufferWrapped() {
        Charset UTF8 = StandardCharsets.UTF_8;
        Request hmset = Request.cmd((Command)Command.HMSET);
        Buffer key = Buffer.buffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuffer)UTF8.encode("my-key")));
        for (int i = 0; i < 50000; ++i) {
            hmset.arg(key).arg(i);
        }
        System.out.println(((RequestImpl)hmset).encode().length());
        for (int j = 0; j < 5; ++j) {
            long t0 = System.nanoTime();
            hmset = Request.cmd((Command)Command.HMSET);
            for (int i = 0; i < 50000; ++i) {
                hmset.arg(key).arg(i);
            }
            long t1 = System.nanoTime();
            System.out.println(((RequestImpl)hmset).encode().length() + "| t " + (t1 - t0));
        }
        System.out.println("---");
    }
}

