/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.redis.client.Command;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.impl.KeyExtractor;
import io.vertx.redis.client.impl.RequestImpl;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class KeyExtractorTest {
    @Test
    public void geoRadius() {
        String key = "Sicily";
        Request req = Request.cmd((Command)Command.GEORADIUS).arg(key).arg(15).arg(37).arg(200).arg("km").arg("WITHDIST");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)key, (Object)new String(keys[0], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusWithStore() {
        String key = "Sicily";
        String storeKey = "sicily_store_key";
        Request req = Request.cmd((Command)Command.GEORADIUS).arg("Sicily").arg(15).arg(37).arg(200).arg("km").arg("WITHDIST").arg(KeyExtractor.STORE_UPPER_CASE).arg("sicily_store_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_store_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusWithStoreDist() {
        String key = "Sicily";
        String storeDistKey = "sicily_storedist_key";
        Request req = Request.cmd((Command)Command.GEORADIUS).arg("Sicily").arg(15).arg(37).arg(200).arg("km").arg("WITHDIST").arg(KeyExtractor.STOREDIST_UPPER_CASE).arg("sicily_storedist_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_storedist_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusWithStoreAndStoreDist() {
        String key = "Sicily";
        String storeKey = "sicily_store_key";
        String storeDistKey = "sicily_storedist_key";
        Request req = Request.cmd((Command)Command.GEORADIUS).arg("Sicily").arg(15).arg(37).arg(200).arg("km").arg("WITHDIST").arg(KeyExtractor.STORE_LOWER_CASE).arg("sicily_store_key").arg(KeyExtractor.STOREDIST_LOWER_CASE).arg("sicily_storedist_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)3L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_store_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_storedist_key", (Object)new String(keys[2], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusRo() {
        String key = "Sicily";
        Request req = Request.cmd((Command)Command.GEORADIUS_RO).arg(key).arg(15).arg(37).arg(200).arg("km").arg("WITHDIST");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)key, (Object)new String(keys[0], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusWithStoreRo() {
        String key = "Sicily";
        String storeKey = "sicily_store_key";
        Request req = Request.cmd((Command)Command.GEORADIUS_RO).arg("Sicily").arg(15).arg(37).arg(200).arg("km").arg("WITHDIST").arg(KeyExtractor.STORE_UPPER_CASE).arg("sicily_store_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_store_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusWithStoreDistRo() {
        String key = "Sicily";
        String storeDistKey = "sicily_storedist_key";
        Request req = Request.cmd((Command)Command.GEORADIUS_RO).arg("Sicily").arg(15).arg(37).arg(200).arg("km").arg("WITHDIST").arg(KeyExtractor.STOREDIST_UPPER_CASE).arg("sicily_storedist_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_storedist_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusWithStoreAndStoreDistRo() {
        String key = "Sicily";
        String storeKey = "sicily_store_key";
        String storeDistKey = "sicily_storedist_key";
        Request req = Request.cmd((Command)Command.GEORADIUS_RO).arg("Sicily").arg(15).arg(37).arg(200).arg("km").arg("WITHDIST").arg(KeyExtractor.STORE_LOWER_CASE).arg("sicily_store_key").arg(KeyExtractor.STOREDIST_LOWER_CASE).arg("sicily_storedist_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)3L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_store_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_storedist_key", (Object)new String(keys[2], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusByMember() {
        String key = "Sicily";
        Request req = Request.cmd((Command)Command.GEORADIUSBYMEMBER).arg(key).arg("Agrigento").arg(100).arg("km");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)key, (Object)new String(keys[0], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusByMemberWithStore() {
        String key = "Sicily";
        String storeKey = "sicily_store_key";
        Request req = Request.cmd((Command)Command.GEORADIUSBYMEMBER).arg("Sicily").arg("Agrigento").arg(100).arg("km").arg(KeyExtractor.STORE_UPPER_CASE).arg("sicily_store_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_store_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusByMemberWithStoreDist() {
        String key = "Sicily";
        String storeDistKey = "sicily_storedist_key";
        Request req = Request.cmd((Command)Command.GEORADIUSBYMEMBER).arg("Sicily").arg("Agrigento").arg(100).arg("km").arg(KeyExtractor.STOREDIST_UPPER_CASE).arg("sicily_storedist_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_storedist_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusByMemberWithStoreAndStoreDist() {
        String key = "Sicily";
        String storeKey = "sicily_store_key";
        String storeDistKey = "sicily_storedist_key";
        Request req = Request.cmd((Command)Command.GEORADIUSBYMEMBER).arg("Sicily").arg("Agrigento").arg(100).arg("km").arg(KeyExtractor.STORE_LOWER_CASE).arg("sicily_store_key").arg(KeyExtractor.STOREDIST_LOWER_CASE).arg("sicily_storedist_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)3L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_store_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_storedist_key", (Object)new String(keys[2], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusByMemberRo() {
        String key = "Sicily";
        Request req = Request.cmd((Command)Command.GEORADIUSBYMEMBER_RO).arg(key).arg("Agrigento").arg(100).arg("km");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)key, (Object)new String(keys[0], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusByMemberWithStoreRo() {
        String key = "Sicily";
        String storeKey = "sicily_store_key";
        Request req = Request.cmd((Command)Command.GEORADIUSBYMEMBER_RO).arg("Sicily").arg("Agrigento").arg(100).arg("km").arg(KeyExtractor.STORE_UPPER_CASE).arg("sicily_store_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_store_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusByMemberWithStoreDistRo() {
        String key = "Sicily";
        String storeDistKey = "sicily_storedist_key";
        Request req = Request.cmd((Command)Command.GEORADIUSBYMEMBER_RO).arg("Sicily").arg("Agrigento").arg(100).arg("km").arg(KeyExtractor.STOREDIST_UPPER_CASE).arg("sicily_storedist_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_storedist_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void geoRadiusByMemberWithStoreAndStoreDistRo() {
        String key = "Sicily";
        String storeKey = "sicily_store_key";
        String storeDistKey = "sicily_storedist_key";
        Request req = Request.cmd((Command)Command.GEORADIUSBYMEMBER_RO).arg("Sicily").arg("Agrigento").arg(100).arg("km").arg(KeyExtractor.STORE_LOWER_CASE).arg("sicily_store_key").arg(KeyExtractor.STOREDIST_LOWER_CASE).arg("sicily_storedist_key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)3L, (long)keys.length);
        Assert.assertEquals((Object)"Sicily", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_store_key", (Object)new String(keys[1], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"sicily_storedist_key", (Object)new String(keys[2], StandardCharsets.UTF_8));
    }

    @Test
    public void sort() {
        String key = "sort-key";
        Request req = Request.cmd((Command)Command.SORT).arg("sort-key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)"sort-key", (Object)new String(keys[0], StandardCharsets.UTF_8));
    }

    @Test
    public void sortWithStoreLowerCase() {
        String key = "sort-key";
        String storeKey = "store-key";
        Request req = Request.cmd((Command)Command.SORT).arg("sort-key").arg(KeyExtractor.STORE_LOWER_CASE).arg("store-key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"sort-key", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"store-key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void sortWithStoreUpperCase() {
        String key = "some-key";
        String storeKey = "store-key";
        Request req = Request.cmd((Command)Command.SORT).arg("some-key").arg(KeyExtractor.STORE_UPPER_CASE).arg("store-key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"some-key", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"store-key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void migrateSingleKey() {
        String key = "some-key";
        Request req = Request.cmd((Command)Command.MIGRATE).arg("127.0.0.1").arg(6379).arg("some-key");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)"some-key", (Object)new String(keys[0], StandardCharsets.UTF_8));
    }

    @Test
    public void migrateSingleKeyKeysList() {
        String[] migrationKeys = new String[]{"first-key"};
        Request req = Request.cmd((Command)Command.MIGRATE).arg("127.0.0.1").arg(6379).arg(0).arg(5000).arg(KeyExtractor.KEYS_LOWER_CASE).arg(migrationKeys[0]);
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)migrationKeys.length, (long)keys.length);
        for (int i = 0; i < migrationKeys.length; ++i) {
            String migrationKey = migrationKeys[i];
            Assert.assertEquals((Object)migrationKey, (Object)new String(keys[i], StandardCharsets.UTF_8));
        }
    }

    @Test
    public void migrateTwoKeys() {
        String[] migrationKeys = new String[]{"first-key", "second-key"};
        Request req = Request.cmd((Command)Command.MIGRATE).arg("127.0.0.1").arg(6379).arg(0).arg(5000).arg(KeyExtractor.KEYS_LOWER_CASE).arg(migrationKeys[0]).arg(migrationKeys[1]);
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)migrationKeys.length, (long)keys.length);
        for (int i = 0; i < migrationKeys.length; ++i) {
            String migrationKey = migrationKeys[i];
            Assert.assertEquals((Object)migrationKey, (Object)new String(keys[i], StandardCharsets.UTF_8));
        }
    }

    @Test
    public void migrateThreeKeys() {
        String[] migrationKeys = new String[]{"first-key", "second-key", "third-key"};
        Request req = Request.cmd((Command)Command.MIGRATE).arg("127.0.0.1").arg(6379).arg(0).arg(5000).arg(KeyExtractor.KEYS_UPPER_CASE).arg(migrationKeys[0]).arg(migrationKeys[1]).arg(migrationKeys[2]);
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)migrationKeys.length, (long)keys.length);
        for (int i = 0; i < migrationKeys.length; ++i) {
            String migrationKey = migrationKeys[i];
            Assert.assertEquals((Object)migrationKey, (Object)new String(keys[i], StandardCharsets.UTF_8));
        }
    }

    @Test
    public void xreadSingleKey() {
        String streamName = "mystream";
        Request req = Request.cmd((Command)Command.XREAD).arg("COUNT").arg(2).arg(KeyExtractor.STREAMS_UPPER_CASE).arg("mystream").arg("0-0");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)"mystream", (Object)new String(keys[0], StandardCharsets.UTF_8));
        req = Request.cmd((Command)Command.XREAD).arg("COUNT").arg(2).arg(KeyExtractor.STREAMS_LOWER_CASE).arg("mystream").arg("0");
        keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)"mystream", (Object)new String(keys[0], StandardCharsets.UTF_8));
        req = Request.cmd((Command)Command.XREAD).arg("COUNT").arg(2).arg(KeyExtractor.STREAMS_UPPER_CASE).arg("mystream").arg("$");
        keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)"mystream", (Object)new String(keys[0], StandardCharsets.UTF_8));
    }

    @Test
    public void xreadTwoKeys() {
        String[] streamNames = new String[]{"my-stream", "other-stream"};
        Request req = Request.cmd((Command)Command.XREAD).arg("COUNT").arg(2).arg(KeyExtractor.STREAMS_UPPER_CASE).arg(streamNames[0]).arg(streamNames[1]).arg("0-0").arg("$");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)streamNames.length, (long)keys.length);
        for (int i = 0; i < streamNames.length; ++i) {
            String streamName = streamNames[i];
            Assert.assertEquals((Object)streamName, (Object)new String(keys[i], StandardCharsets.UTF_8));
        }
    }

    @Test
    public void xreadThreeKeys() {
        String[] streamNames = new String[]{"my-stream", "other-stream", "further_stream"};
        Request req = Request.cmd((Command)Command.XREAD).arg("COUNT").arg(2).arg(KeyExtractor.STREAMS_UPPER_CASE).arg(streamNames[0]).arg(streamNames[1]).arg(streamNames[2]).arg("0-0").arg("$").arg("0");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)streamNames.length, (long)keys.length);
        for (int i = 0; i < streamNames.length; ++i) {
            String streamName = streamNames[i];
            Assert.assertEquals((Object)streamName, (Object)new String(keys[i], StandardCharsets.UTF_8));
        }
    }

    @Test
    public void xreadGroupSingleKey() {
        String streamName = "mystream";
        Request req = Request.cmd((Command)Command.XREADGROUP).arg("GROUP").arg("group-name").arg("consumer-name").arg("COUNT").arg(2).arg(KeyExtractor.STREAMS_UPPER_CASE).arg("mystream").arg("0-0");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)"mystream", (Object)new String(keys[0], StandardCharsets.UTF_8));
        req = Request.cmd((Command)Command.XREADGROUP).arg("GROUP").arg("group-name").arg("consumer-name").arg("COUNT").arg(2).arg(KeyExtractor.STREAMS_LOWER_CASE).arg("mystream").arg("0");
        keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)"mystream", (Object)new String(keys[0], StandardCharsets.UTF_8));
        req = Request.cmd((Command)Command.XREADGROUP).arg("GROUP").arg("group-name").arg("consumer-name").arg("COUNT").arg(2).arg(KeyExtractor.STREAMS_UPPER_CASE).arg("mystream").arg("$");
        keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)1L, (long)keys.length);
        Assert.assertEquals((Object)"mystream", (Object)new String(keys[0], StandardCharsets.UTF_8));
    }

    @Test
    public void xreadGroupTwoKeys() {
        String[] streamNames = new String[]{"my-stream", "other-stream"};
        Request req = Request.cmd((Command)Command.XREADGROUP).arg("GROUP").arg("group-name").arg("consumer-name").arg("COUNT").arg(2).arg(KeyExtractor.STREAMS_UPPER_CASE).arg(streamNames[0]).arg(streamNames[1]).arg("0-0").arg("$");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)streamNames.length, (long)keys.length);
        for (int i = 0; i < streamNames.length; ++i) {
            String streamName = streamNames[i];
            Assert.assertEquals((Object)streamName, (Object)new String(keys[i], StandardCharsets.UTF_8));
        }
    }

    @Test
    public void xreadGroupThreeKeys() {
        String[] streamNames = new String[]{"my-stream", "other-stream", "further_stream"};
        Request req = Request.cmd((Command)Command.XREADGROUP).arg("GROUP").arg("group-name").arg("consumer-name").arg("COUNT").arg(2).arg(KeyExtractor.STREAMS_UPPER_CASE).arg(streamNames[0]).arg(streamNames[1]).arg(streamNames[2]).arg("0-0").arg("$").arg("0");
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)streamNames.length, (long)keys.length);
        for (int i = 0; i < streamNames.length; ++i) {
            String streamName = streamNames[i];
            Assert.assertEquals((Object)streamName, (Object)new String(keys[i], StandardCharsets.UTF_8));
        }
    }

    @Test
    public void zInterstoreSingleKey() {
        String destination = "destination";
        String key = "some-key";
        Request req = Request.cmd((Command)Command.ZINTERSTORE).arg("destination").arg(1).arg("some-key").arg("WEIGHTS").arg(1);
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"destination", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"some-key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void zInterstoreTwoKeys() {
        String destination = "destination";
        String[] keys = new String[]{"some-key", "other-key"};
        Request req = Request.cmd((Command)Command.ZINTERSTORE).arg("destination").arg(keys.length).arg(keys[0]).arg(keys[1]).arg("WEIGHTS").arg(1).arg(2).arg("AGGREGATE").arg("SUM");
        byte[][] movableKeys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)(keys.length + 1), (long)movableKeys.length);
        Assert.assertEquals((Object)"destination", (Object)new String(movableKeys[0], StandardCharsets.UTF_8));
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Assert.assertEquals((Object)key, (Object)new String(movableKeys[i + 1], StandardCharsets.UTF_8));
        }
    }

    @Test
    public void zInterstoreThreeKeys() {
        String destination = "destination";
        String[] keys = new String[]{"some-key", "other-key", "further-key"};
        Request req = Request.cmd((Command)Command.ZINTERSTORE).arg("destination").arg(keys.length).arg(keys[0]).arg(keys[1]).arg(keys[2]).arg("WEIGHTS").arg(1).arg(2).arg("AGGREGATE").arg("SUM");
        byte[][] movableKeys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)(keys.length + 1), (long)movableKeys.length);
        Assert.assertEquals((Object)"destination", (Object)new String(movableKeys[0], StandardCharsets.UTF_8));
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Assert.assertEquals((Object)key, (Object)new String(movableKeys[i + 1], StandardCharsets.UTF_8));
        }
    }

    @Test
    public void zUnionstoreSingleKey() {
        String destination = "destination";
        String key = "some-key";
        Request req = Request.cmd((Command)Command.ZUNIONSTORE).arg("destination").arg(1).arg("some-key").arg("WEIGHTS").arg(1);
        byte[][] keys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)2L, (long)keys.length);
        Assert.assertEquals((Object)"destination", (Object)new String(keys[0], StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"some-key", (Object)new String(keys[1], StandardCharsets.UTF_8));
    }

    @Test
    public void zUnionstoreTwoKeys() {
        String destination = "destination";
        String[] keys = new String[]{"some-key", "other-key"};
        Request req = Request.cmd((Command)Command.ZUNIONSTORE).arg("destination").arg(keys.length).arg(keys[0]).arg(keys[1]).arg("WEIGHTS").arg(1).arg(2).arg("AGGREGATE").arg("SUM");
        byte[][] movableKeys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)(keys.length + 1), (long)movableKeys.length);
        Assert.assertEquals((Object)"destination", (Object)new String(movableKeys[0], StandardCharsets.UTF_8));
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Assert.assertEquals((Object)key, (Object)new String(movableKeys[i + 1], StandardCharsets.UTF_8));
        }
    }

    @Test
    public void zUnionstoreThreeKeys() {
        String destination = "destination";
        String[] keys = new String[]{"some-key", "other-key", "further-key"};
        Request req = Request.cmd((Command)Command.ZUNIONSTORE).arg("destination").arg(keys.length).arg(keys[0]).arg(keys[1]).arg(keys[2]).arg("WEIGHTS").arg(1).arg(2).arg("AGGREGATE").arg("SUM");
        byte[][] movableKeys = KeyExtractor.extractMovableKeys((RequestImpl)((RequestImpl)req));
        Assert.assertEquals((long)(keys.length + 1), (long)movableKeys.length);
        Assert.assertEquals((Object)"destination", (Object)new String(movableKeys[0], StandardCharsets.UTF_8));
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            Assert.assertEquals((Object)key, (Object)new String(movableKeys[i + 1], StandardCharsets.UTF_8));
        }
    }
}

