/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.redis.client.impl.RedisURI;
import org.junit.Assert;
import org.junit.Test;

public class RedisURITest {
    @Test
    public void testHostAndPort() {
        RedisURI redisURI = new RedisURI("redis://redis-1234.hosted.com:1234");
        Assert.assertEquals((String)"Host address is not correct", (Object)"redis-1234.hosted.com", (Object)redisURI.socketAddress().host());
        Assert.assertEquals((String)"Port is not correct", (long)1234L, (long)redisURI.socketAddress().port());
    }

    @Test
    public void testOnlyPasswordGiven() {
        RedisURI redisURI = new RedisURI("redis://:p%40ssw0rd@redis-1234.hosted.com:1234/0");
        Assert.assertEquals((String)"Password is not correct", (Object)"p@ssw0rd", (Object)redisURI.password());
    }

    @Test
    public void testOnlyPasswordInQueryGiven() {
        RedisURI redisURI = new RedisURI("redis://redis-1234.hosted.com:1234/0?password=p%40ssw0rd");
        Assert.assertEquals((String)"Password is not correct", (Object)"p@ssw0rd", (Object)redisURI.password());
    }

    @Test
    public void testTwoPasswordsAreGiven() {
        RedisURI redisURI = new RedisURI("redis://:pass@redis-1234.hosted.com:1234/0?password=p%40ssw0rd");
        Assert.assertEquals((String)"Password is not correct", (Object)"pass", (Object)redisURI.password());
    }

    @Test
    public void testLoginAndPasswordGiven() {
        RedisURI redisURI = new RedisURI("redis://redundantName:p%40ssw0rd@redis-1234.hosted.com:1234/0");
        Assert.assertEquals((String)"Password is not correct", (Object)"p@ssw0rd", (Object)redisURI.password());
    }

    @Test
    public void testPasswordNotGiven() {
        RedisURI redisURI = new RedisURI("redis://redis-1234.hosted.com:1234/0");
        Assert.assertNull((String)"Password is not null", (Object)redisURI.password());
    }

    @Test
    public void testDbNumberGiven() {
        RedisURI redisURI = new RedisURI("redis://redundantName:p%40ssw0rd@redis-1234.hosted.com:1234/2");
        Assert.assertEquals((String)"DB number is not correct", (long)2L, (long)redisURI.select().intValue());
    }

    @Test
    public void testDbNumberGivenInQuery() {
        RedisURI redisURI = new RedisURI("redis://redundantName:p%40ssw0rd@redis-1234.hosted.com:1234?db=2");
        Assert.assertEquals((String)"DB number is not correct", (long)2L, (long)redisURI.select().intValue());
    }

    @Test
    public void testDbNumberPriorityPathOverQuery() {
        RedisURI redisURI = new RedisURI("redis://redundantName:p%40ssw0rd@redis-1234.hosted.com:1234/1?db=2");
        Assert.assertEquals((String)"DB number is not correct", (long)1L, (long)redisURI.select().intValue());
    }

    @Test
    public void testUNIX() {
        RedisURI redisURI = new RedisURI("unix:///some/file.sock?db=2&password=p%40ssw0rd");
        Assert.assertEquals((String)"Password is not correct", (Object)"p@ssw0rd", (Object)redisURI.password());
        Assert.assertEquals((String)"UNIX file is not correct", (Object)"/some/file.sock", (Object)redisURI.socketAddress().path());
        Assert.assertEquals((String)"DB number is not correct", (long)2L, (long)redisURI.select().intValue());
    }

    @Test
    public void testRedundantQuery() {
        RedisURI redisURI = new RedisURI("unix:///some/file.sock?");
        Assert.assertEquals((String)"UNIX file is not correct", (Object)"/some/file.sock", (Object)redisURI.socketAddress().path());
    }

    @Test
    public void testIPV6() {
        RedisURI redisURI = new RedisURI("redis://[::1]:1234/0");
        Assert.assertEquals((Object)"[::1]:1234", (Object)redisURI.socketAddress().toString());
    }
}

