/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.ParserHandler;
import io.vertx.redis.client.impl.RESPParser;
import io.vertx.redis.client.impl.types.BulkType;
import io.vertx.redis.client.impl.types.MultiType;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class ReplyParserTest {
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();

    @Test(timeout=30000L)
    public void testParseSimple(final TestContext should) {
        final Async test = should.async();
        final AtomicInteger counter = new AtomicInteger();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                System.out.println(response.toString());
                if (counter.incrementAndGet() == 4) {
                    test.complete();
                }
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"+PONG\r\n+PONG\r\n+PONG\r\n+PONG\r\n"));
    }

    @Test(timeout=30000L)
    public void testParseSimpleInChunks(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                System.out.println(response.toString());
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"+"));
        parser.handle(Buffer.buffer((String)"P"));
        parser.handle(Buffer.buffer((String)"O"));
        parser.handle(Buffer.buffer((String)"N"));
        parser.handle(Buffer.buffer((String)"G"));
        parser.handle(Buffer.buffer((String)"\r"));
        parser.handle(Buffer.buffer((String)"\n"));
    }

    @Test(timeout=30000L)
    public void testIntegerType(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertEquals((Object)1000L, (Object)response.toLong());
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)":1000\r\n"));
    }

    @Test(timeout=30000L)
    public void testNegIntegerType(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertEquals((Object)-1L, (Object)response.toLong());
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)":-1\r\n"));
    }

    @Test(timeout=30000L)
    public void testBulk(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertEquals((Object)"foobar", (Object)response.toString());
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"$6\r\nfoobar\r\n"));
    }

    @Test(timeout=30000L)
    public void testEmptyBulk(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertEquals((Object)"", (Object)response.toString());
                should.assertTrue(response == BulkType.EMPTY);
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"$0\r\n\r\n"));
    }

    @Test(timeout=30000L)
    public void testNullBulk(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertTrue(response == null);
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"$-1\r\n"));
    }

    @Test(timeout=30000L)
    public void testEmptyMulti(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertEquals((Object)0, (Object)response.size());
                should.assertTrue(response == MultiType.EMPTY);
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"*0\r\n"));
    }

    @Test(timeout=30000L)
    public void testNullMulti(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertTrue(response == null);
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"*-1\r\n"));
    }

    @Test(timeout=30000L)
    public void testMulti(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertEquals((Object)2, (Object)response.size());
                should.assertEquals((Object)"foo", (Object)response.get(0).toString());
                should.assertEquals((Object)"bar", (Object)response.get(1).toString());
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"*2\r\n$3\r\nfoo\r\n$3\r\nbar\r\n"));
    }

    @Test(timeout=30000L)
    public void testMultiOfInteger(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertEquals((Object)3, (Object)response.size());
                should.assertEquals((Object)1, (Object)response.get(0).toInteger());
                should.assertEquals((Object)2, (Object)response.get(1).toInteger());
                should.assertEquals((Object)3, (Object)response.get(2).toInteger());
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"*3\r\n:1\r\n:2\r\n:3\r\n"));
    }

    @Test(timeout=30000L)
    public void testMultiOfMixed(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertEquals((Object)5, (Object)response.size());
                should.assertEquals((Object)1, (Object)response.get(0).toInteger());
                should.assertEquals((Object)2, (Object)response.get(1).toInteger());
                should.assertEquals((Object)3, (Object)response.get(2).toInteger());
                should.assertEquals((Object)4, (Object)response.get(3).toInteger());
                should.assertEquals((Object)"foobar", (Object)response.get(4).toString());
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"*5\r\n:1\r\n:2\r\n:3\r\n:4\r\n$6\r\nfoobar\r\n"));
    }

    @Test(timeout=30000L)
    public void testMultiOfMulti(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertEquals((Object)2, (Object)response.size());
                should.assertEquals((Object)1, (Object)response.get(0).get(0).toInteger());
                should.assertEquals((Object)2, (Object)response.get(0).get(1).toInteger());
                should.assertEquals((Object)3, (Object)response.get(0).get(2).toInteger());
                should.assertEquals((Object)"Foo", (Object)response.get(1).get(0).toString());
                should.assertEquals((Object)"Bar", (Object)response.get(1).get(1).toString());
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"*2\r\n*3\r\n:1\r\n:2\r\n:3\r\n*2\r\n+Foo\r\n-Bar\r\n"));
    }

    @Test
    public void testMultiWithNull(final TestContext should) {
        final Async test = should.async();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                should.assertEquals((Object)3, (Object)response.size());
                should.assertEquals((Object)"foo", (Object)response.get(0).toString());
                should.assertTrue(response.get(1) == null);
                should.assertEquals((Object)"bar", (Object)response.get(2).toString());
                test.complete();
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"*3\r\n$3\r\nfoo\r\n$-1\r\n$3\r\nbar\r\n"));
    }

    @Test(timeout=30000L)
    public void parseLargePayload(final TestContext should) {
        final Async test = should.async();
        final AtomicInteger counter = new AtomicInteger();
        RESPParser parser = new RESPParser(new ParserHandler(){

            public void handle(Response response) {
                System.out.println(response);
                if (counter.incrementAndGet() == 17) {
                    test.complete();
                }
            }

            public void fatal(Throwable t) {
                should.fail(t);
            }

            public void fail(Throwable t) {
                should.fail(t);
            }
        }, 16);
        parser.handle(Buffer.buffer((String)"+OK\r\n+OK\r\n$1\r\n1\r\n+OK\r\n+OK\r\n+OK\r\n$5\r\n91600\r\n$6\r\n104099\r\n+OK\r\n$6\r\n104099\r\n$6\r\n104099\r\n+OK\r\n+OK\r\n+OK\r\n$5\r\n77347\r\n$5\r\n91600\r\n$5\r\n91600\r\n"));
    }
}

