/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.impl;

import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.Slots;
import io.vertx.redis.client.impl.types.IntegerType;
import io.vertx.redis.client.impl.types.MultiType;
import io.vertx.redis.client.impl.types.SimpleStringType;
import org.junit.Assert;
import org.junit.Test;

public class SlotsTest {
    private static final MultiType SLOTS_RESPONSE = MultiType.create((Response[])new Response[]{MultiType.create((Response[])new Response[]{IntegerType.create((Long)0L), IntegerType.create((Long)8191L), MultiType.create((Response[])new Response[]{SimpleStringType.create((String)"redis-0001-001.redis.k9mgrw.euw1.cache.amazonaws.com"), IntegerType.create((Long)7011L)}), MultiType.create((Response[])new Response[]{SimpleStringType.create((String)"redis-0001-002.redis.k9mgrw.euw1.cache.amazonaws.com"), IntegerType.create((Long)7012L)})}), MultiType.create((Response[])new Response[]{IntegerType.create((Long)8192L), IntegerType.create((Long)16383L), MultiType.create((Response[])new Response[]{SimpleStringType.create((String)"redis-0002-001.redis.k9mgrw.euw1.cache.amazonaws.com"), IntegerType.create((Long)7021L)}), MultiType.create((Response[])new Response[]{SimpleStringType.create((String)"redis-0002-002.redis.k9mgrw.euw1.cache.amazonaws.com"), IntegerType.create((Long)7022L)})})});

    @Test
    public void testExtractsSlotsWithMastersAndReplicas() {
        Slots slots = new Slots("redis://clustercfg.redis.k9mgrw.euw1.cache.amazonaws.com:7000", (Response)SLOTS_RESPONSE);
        Assert.assertEquals((long)2L, (long)slots.size());
        Assert.assertTrue((boolean)slots.contains("redis://redis-0001-001.redis.k9mgrw.euw1.cache.amazonaws.com:7011"));
        Assert.assertTrue((boolean)slots.contains("redis://redis-0001-002.redis.k9mgrw.euw1.cache.amazonaws.com:7012"));
        Assert.assertTrue((boolean)slots.contains("redis://redis-0002-001.redis.k9mgrw.euw1.cache.amazonaws.com:7021"));
        Assert.assertTrue((boolean)slots.contains("redis://redis-0002-002.redis.k9mgrw.euw1.cache.amazonaws.com:7022"));
    }

    @Test
    public void shouldPatchExtractedEndpointsWithUserinfo() {
        Slots slots = new Slots("redis://:password@clustercfg.redis.k9mgrw.euw1.cache.amazonaws.com:7000", (Response)SLOTS_RESPONSE);
        Assert.assertEquals((long)2L, (long)slots.size());
        Assert.assertTrue((boolean)slots.contains("redis://:password@redis-0001-001.redis.k9mgrw.euw1.cache.amazonaws.com:7011"));
        Assert.assertTrue((boolean)slots.contains("redis://:password@redis-0001-002.redis.k9mgrw.euw1.cache.amazonaws.com:7012"));
        Assert.assertTrue((boolean)slots.contains("redis://:password@redis-0002-001.redis.k9mgrw.euw1.cache.amazonaws.com:7021"));
        Assert.assertTrue((boolean)slots.contains("redis://:password@redis-0002-002.redis.k9mgrw.euw1.cache.amazonaws.com:7022"));
    }
}

