/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.test;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import java.util.UUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RedisClientPubSubTest {
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();
    private Redis redisPublish;
    private Redis redisSubscribe;
    private RedisConnection pubConn;
    private RedisConnection subConn;

    @Before
    public void before(TestContext should) {
        Async test = should.async();
        this.redisPublish = Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://localhost:7006").connect(connectPub -> {
            should.assertTrue(connectPub.succeeded());
            this.pubConn = (RedisConnection)connectPub.result();
            this.redisSubscribe = Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://localhost:7006").connect(connectSub -> {
                should.assertTrue(connectSub.succeeded());
                this.subConn = (RedisConnection)connectSub.result();
                test.complete();
            });
        });
    }

    @After
    public void after(TestContext should) {
        this.redisPublish.close();
        this.redisSubscribe.close();
    }

    private static String makeKey() {
        return UUID.randomUUID().toString();
    }

    @Test
    public void testPublishSubscribe(TestContext should) {
        Async test = should.async();
        this.redisSubscribe.send(Request.cmd((Command)Command.SUBSCRIBE).arg("news"), reply -> {
            should.assertTrue(reply.succeeded());
            this.rule.vertx().eventBus().consumer("io.vertx.redis.news", msg -> test.complete());
            this.redisPublish.send(Request.cmd((Command)Command.PUBLISH).arg("news").arg("foo"), preply -> should.assertTrue(preply.succeeded()));
        });
    }

    @Test
    public void testPublishPSubscribe(TestContext should) {
        Async test = should.async();
        this.redisSubscribe.send(Request.cmd((Command)Command.PSUBSCRIBE).arg("new*"), reply -> {
            should.assertTrue(reply.succeeded());
            this.rule.vertx().eventBus().consumer("io.vertx.redis.new*", msg -> test.complete());
            this.redisPublish.send(Request.cmd((Command)Command.PUBLISH).arg("news").arg("foo"), preply -> should.assertTrue(preply.succeeded()));
        });
    }
}

