/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.test;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisSlaves;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RedisClusterTest {
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();
    private final RedisOptions options = new RedisOptions().setType(RedisClientType.CLUSTER).setUseSlave(RedisSlaves.SHARE).setMaxWaitingHandlers(131072).addConnectionString("redis://127.0.0.1:7000").addConnectionString("redis://127.0.0.1:7001").addConnectionString("redis://127.0.0.1:7002").addConnectionString("redis://127.0.0.1:7003").addConnectionString("redis://127.0.0.1:7004").addConnectionString("redis://127.0.0.1:7005").setMaxPoolSize(8).setMaxPoolWaiting(16);
    private Redis client;

    private static String makeKey() {
        return UUID.randomUUID().toString();
    }

    private static String[] toStringArray(String ... params) {
        return params;
    }

    @Before
    public void createClient() {
        this.client = Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)this.options);
    }

    @After
    public void cleanRedis(TestContext should) {
        Async test = should.async();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.send(Request.cmd((Command)Command.FLUSHDB), flushDB -> {
                should.assertTrue(flushDB.succeeded());
                this.client.close();
                test.complete();
            });
        });
    }

    @Test
    public void testContextReturn(TestContext should) {
        Async test = should.async();
        Context context = this.rule.vertx().getOrCreateContext();
        this.client.connect(onCreate -> {
            should.assertEquals((Object)context, (Object)this.rule.vertx().getOrCreateContext());
            test.complete();
        });
    }

    @Test(timeout=30000L)
    public void runTheSlotScope(TestContext should) {
        Async test = should.async();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            int len = (int)Math.pow(2.0, 17.0);
            AtomicInteger counter = new AtomicInteger();
            for (int i = 0; i < len; ++i) {
                String id = Integer.toString(i);
                cluster.send(Request.cmd((Command)Command.SET).arg(id).arg(id), set -> {
                    should.assertTrue(set.succeeded());
                    cluster.send(Request.cmd((Command)Command.GET).arg(id), get -> {
                        if (get.failed()) {
                            get.cause().printStackTrace();
                        }
                        should.assertTrue(get.succeeded());
                        should.assertEquals((Object)id, (Object)((Response)get.result()).toString());
                        int cnt = counter.incrementAndGet();
                        if (cnt % 1024 == 0) {
                            System.out.print('.');
                        }
                        if (cnt == len) {
                            test.complete();
                        }
                    });
                });
            }
        });
    }

    @Test(timeout=30000L)
    public void autoFindNodeByMOVEDAndASK(TestContext should) {
        Async test = should.async();
        RedisOptions options = new RedisOptions().setType(RedisClientType.CLUSTER).setMaxWaitingHandlers(131072).addConnectionString("redis://127.0.0.1:7000").addConnectionString("redis://127.0.0.1:7002").addConnectionString("redis://127.0.0.1:7004").setMaxPoolSize(8).setMaxPoolWaiting(16);
        Redis client2 = Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)options);
        client2.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            int len = (int)Math.pow(2.0, 17.0);
            AtomicInteger counter = new AtomicInteger();
            for (int i = 0; i < len; ++i) {
                String id = Integer.toString(i);
                cluster.send(Request.cmd((Command)Command.SET).arg(id).arg(id), set -> {
                    should.assertTrue(set.succeeded());
                    cluster.send(Request.cmd((Command)Command.GET).arg(id), get -> {
                        should.assertTrue(get.succeeded());
                        should.assertEquals((Object)id, (Object)((Response)get.result()).toString());
                        int cnt = counter.incrementAndGet();
                        if (cnt % 1024 == 0) {
                            System.out.print('.');
                        }
                        if (cnt == len) {
                            client2.close();
                            test.complete();
                        }
                    });
                });
            }
        });
    }

    @Test(timeout=30000L)
    public void autoFindNodes(TestContext should) {
        Async test = should.async();
        RedisOptions options = new RedisOptions().setType(RedisClientType.CLUSTER).setMaxWaitingHandlers(131072).addConnectionString("redis://127.0.0.1:7000").setMaxPoolSize(8).setMaxPoolWaiting(16);
        Redis client2 = Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)options);
        client2.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            int len = (int)Math.pow(2.0, 17.0);
            AtomicInteger counter = new AtomicInteger();
            for (int i = 0; i < len; ++i) {
                String id = Integer.toString(i);
                cluster.send(Request.cmd((Command)Command.SET).arg(id).arg(id), set -> {
                    should.assertTrue(set.succeeded());
                    cluster.send(Request.cmd((Command)Command.GET).arg(id), get -> {
                        should.assertTrue(get.succeeded());
                        should.assertEquals((Object)id, (Object)((Response)get.result()).toString());
                        int cnt = counter.incrementAndGet();
                        if (cnt % 1024 == 0) {
                            System.out.print('.');
                        }
                        if (cnt == len) {
                            client2.close();
                            test.complete();
                        }
                    });
                });
            }
        });
    }

    @Test(timeout=30000L)
    public void autoFindNodesAcross24Instances(TestContext should) {
        Async test = should.async();
        RedisOptions options = new RedisOptions().setType(RedisClientType.CLUSTER).setMaxWaitingHandlers(131072).addConnectionString("redis://127.0.0.1:7000").setMaxPoolSize(8).setMaxPoolWaiting(16);
        ArrayList<Future> futures = new ArrayList<Future>(24);
        for (int i = 0; i < 24; ++i) {
            Promise p = Promise.promise();
            Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)options).connect((Handler)p);
            futures.add(p.future());
        }
        CompositeFuture.all(futures).setHandler(all -> {
            should.assertFalse(all.failed());
            Random rnd = new Random();
            List clients = ((CompositeFuture)all.result()).list();
            clients.forEach(client -> client.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0)));
            System.out.println("We have " + clients.size() + " clients");
            int len = (int)Math.pow(2.0, 17.0);
            AtomicInteger counter = new AtomicInteger();
            for (int i = 0; i < len; ++i) {
                String id = Integer.toString(i);
                ((RedisConnection)clients.get(rnd.nextInt(clients.size()))).send(Request.cmd((Command)Command.SET).arg(id).arg(id), set -> {
                    should.assertTrue(set.succeeded());
                    ((RedisConnection)clients.get(rnd.nextInt(clients.size()))).send(Request.cmd((Command)Command.GET).arg(id), get -> {
                        should.assertTrue(get.succeeded());
                        should.assertEquals((Object)id, (Object)((Response)get.result()).toString());
                        int cnt = counter.incrementAndGet();
                        if (cnt % 1024 == 0) {
                            System.out.print('.');
                        }
                        if (cnt == len) {
                            test.complete();
                        }
                    });
                });
            }
        });
    }

    @Test(timeout=30000L)
    public void testHgetall(TestContext should) {
        Async test = should.async();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.HSET).arg("testKey").arg("field1").arg("Hello"), hset1 -> {
                should.assertTrue(hset1.succeeded());
                cluster.send(Request.cmd((Command)Command.HSET).arg("testKey").arg("field2").arg("World"), hset2 -> {
                    should.assertTrue(hset2.succeeded());
                    cluster.send(Request.cmd((Command)Command.HGETALL).arg("testKey"), hGetAll -> {
                        should.assertTrue(hGetAll.succeeded());
                        try {
                            Response obj = (Response)hGetAll.result();
                            should.assertEquals((Object)"Hello", (Object)obj.get("field1").toString());
                            should.assertEquals((Object)"World", (Object)obj.get("field2").toString());
                            test.complete();
                        }
                        catch (Exception ex) {
                            should.fail((Throwable)ex);
                        }
                    });
                });
            });
        });
    }

    @Test
    public void testAppend(TestContext should) {
        Async test = should.async();
        String key = RedisClusterTest.makeKey();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.DEL).arg(key), del -> {
                should.assertTrue(del.succeeded());
                cluster.send(Request.cmd((Command)Command.APPEND).arg(key).arg("Hello"), append1 -> {
                    should.assertTrue(append1.succeeded());
                    should.assertEquals((Object)5L, (Object)((Response)append1.result()).toLong());
                    cluster.send(Request.cmd((Command)Command.APPEND).arg(key).arg(" World"), append2 -> {
                        should.assertTrue(append2.succeeded());
                        should.assertEquals((Object)11L, (Object)((Response)append2.result()).toLong());
                        cluster.send(Request.cmd((Command)Command.GET).arg(key), get -> {
                            should.assertTrue(get.succeeded());
                            should.assertEquals((Object)"Hello World", (Object)((Response)get.result()).toString());
                            test.complete();
                        });
                    });
                });
            });
        });
    }

    @Test
    public void testBitCount(TestContext should) {
        Async test = should.async();
        String key = RedisClusterTest.makeKey();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.SET).arg(key).arg("foobar"), set -> {
                should.assertTrue(set.succeeded());
                cluster.send(Request.cmd((Command)Command.BITCOUNT).arg(key), bitCount1 -> {
                    should.assertTrue(bitCount1.succeeded());
                    should.assertEquals((Object)26L, (Object)((Response)bitCount1.result()).toLong());
                    cluster.send(Request.cmd((Command)Command.BITCOUNT).arg(key).arg(0).arg(0), bitCount2 -> {
                        should.assertTrue(bitCount2.succeeded());
                        should.assertEquals((Object)4L, (Object)((Response)bitCount2.result()).toLong());
                        cluster.send(Request.cmd((Command)Command.BITCOUNT).arg(key).arg(1).arg(1), bitCount3 -> {
                            should.assertTrue(bitCount3.succeeded());
                            should.assertEquals((Object)6L, (Object)((Response)bitCount3.result()).toLong());
                            test.complete();
                        });
                    });
                });
            });
        });
    }

    @Test
    @Ignore
    public void testBitTop(TestContext should) {
        Async test = should.async();
        String key1 = RedisClusterTest.makeKey();
        String key2 = RedisClusterTest.makeKey();
        String destkey = RedisClusterTest.makeKey();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.SET).arg(key1).arg("foobar"), set1 -> {
                should.assertTrue(set1.succeeded());
                cluster.send(Request.cmd((Command)Command.SET).arg(key1).arg("abcdef"), set2 -> {
                    should.assertTrue(set2.succeeded());
                    cluster.send(Request.cmd((Command)Command.BITOP).arg("AND").arg(destkey).arg(key1).arg(key2), bitTop -> {
                        should.assertTrue(bitTop.succeeded());
                        cluster.send(Request.cmd((Command)Command.GET).arg(destkey), get -> {
                            should.assertTrue(get.succeeded());
                            test.complete();
                        });
                    });
                });
            });
        });
    }

    @Test
    public void testBlPop(TestContext should) {
        Async test = should.async();
        String list1 = RedisClusterTest.makeKey();
        String list2 = RedisClusterTest.makeKey();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.DEL).arg(list1), del1 -> {
                should.assertTrue(del1.succeeded());
                cluster.send(Request.cmd((Command)Command.DEL).arg(list2), del2 -> {
                    should.assertTrue(del2.succeeded());
                    cluster.send(Request.cmd((Command)Command.RPUSH).arg(list1).arg("a").arg("b").arg("c"), rPush -> {
                        should.assertTrue(rPush.succeeded());
                        cluster.send(Request.cmd((Command)Command.BLPOP).arg(list1).arg(0), blPop -> {
                            should.assertTrue(blPop.succeeded());
                            should.assertEquals((Object)list1, (Object)((Response)blPop.result()).get(0).toString());
                            should.assertEquals((Object)"a", (Object)((Response)blPop.result()).get(1).toString());
                            should.assertEquals((Object)("[" + String.join((CharSequence)", ", RedisClusterTest.toStringArray(list1, "a")) + "]"), (Object)((Response)blPop.result()).toString());
                            test.complete();
                        });
                    });
                });
            });
        });
    }

    @Test
    public void testBitPos(TestContext should) {
        Async test = should.async();
        String key = RedisClusterTest.makeKey();
        byte[] value1 = new byte[]{-1, -16, 0};
        byte[] value2 = new byte[]{0, 0, 0};
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.SET).arg(key).arg(Buffer.buffer((byte[])value1)), set1 -> {
                should.assertTrue(set1.succeeded());
                cluster.send(Request.cmd((Command)Command.BITPOS).arg(key).arg(0), bitPos1 -> {
                    should.assertTrue(bitPos1.succeeded());
                    should.assertEquals((Object)12L, (Object)((Response)bitPos1.result()).toLong());
                    cluster.send(Request.cmd((Command)Command.SET).arg(key).arg(Buffer.buffer((byte[])value2)), set2 -> {
                        should.assertTrue(set2.succeeded());
                        cluster.send(Request.cmd((Command)Command.BITPOS).arg(key).arg(1), bitPos2 -> {
                            should.assertTrue(bitPos2.succeeded());
                            should.assertEquals((Object)-1L, (Object)((Response)bitPos2.result()).toLong());
                            test.complete();
                        });
                    });
                });
            });
        });
    }

    @Test(timeout=5000L)
    @Ignore
    public void testBrPop(TestContext should) {
        Async test = should.async();
        String list1 = RedisClusterTest.makeKey();
        String list2 = RedisClusterTest.makeKey();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.DEL).arg(list1), del1 -> {
                should.assertTrue(del1.succeeded());
                cluster.send(Request.cmd((Command)Command.DEL).arg(list2), del2 -> {
                    should.assertTrue(del2.succeeded());
                    cluster.send(Request.cmd((Command)Command.RPUSH).arg(list1).arg("a").arg("b").arg("c"), rPush -> {
                        should.assertTrue(rPush.succeeded());
                        cluster.send(Request.cmd((Command)Command.BRPOP).arg(list1).arg(list2).arg(0), brPop -> {
                            should.assertTrue(brPop.succeeded());
                            should.assertEquals((Object)String.join((CharSequence)",", RedisClusterTest.toStringArray(list1, "a")), (Object)((Response)brPop.result()).toString());
                            test.complete();
                        });
                    });
                });
            });
        });
    }

    @Test
    public void testDecr(TestContext should) {
        Async test = should.async();
        String key = RedisClusterTest.makeKey();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.SET).arg(key).arg(10), set -> {
                should.assertTrue(set.succeeded());
                cluster.send(Request.cmd((Command)Command.DECR).arg(key), decr -> {
                    should.assertTrue(decr.succeeded());
                    should.assertEquals((Object)9L, (Object)((Response)decr.result()).toLong());
                    test.complete();
                });
            });
        });
    }

    @Test
    public void testDecrBy(TestContext should) {
        Async test = should.async();
        String key = RedisClusterTest.makeKey();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.SET).arg(key).arg(10), set -> {
                should.assertTrue(set.succeeded());
                cluster.send(Request.cmd((Command)Command.DECRBY).arg(key).arg(5), decrBy -> {
                    should.assertTrue(decrBy.succeeded());
                    should.assertEquals((Object)5L, (Object)((Response)decrBy.result()).toLong());
                    test.complete();
                });
            });
        });
    }

    @Test
    public void testDel(TestContext should) {
        Async test = should.async();
        String key1 = RedisClusterTest.makeKey();
        String key2 = RedisClusterTest.makeKey();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.SET).arg(key1).arg("Hello"), set1 -> {
                should.assertTrue(set1.succeeded());
                cluster.send(Request.cmd((Command)Command.SET).arg(key2).arg("Hello"), set2 -> {
                    should.assertTrue(set2.succeeded());
                    cluster.send(Request.cmd((Command)Command.DEL).arg(key1).arg(key2), del -> {
                        should.assertTrue(del.succeeded());
                        should.assertEquals((Object)2, (Object)((Response)del.result()).toInteger());
                        test.complete();
                    });
                });
            });
        });
    }

    @Test
    public void testEcho(TestContext should) {
        Async test = should.async();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.ECHO).arg("Hello Wordl"), echo -> {
                should.assertTrue(echo.succeeded());
                should.assertEquals((Object)"Hello Wordl", (Object)((Response)echo.result()).toString());
                test.complete();
            });
        });
    }

    @Test
    public void testExists(TestContext should) {
        Async test = should.async();
        String key1 = RedisClusterTest.makeKey();
        String key2 = RedisClusterTest.makeKey();
        AtomicInteger counter = new AtomicInteger();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.SET).arg(key1).arg("Hello"), set -> {
                should.assertTrue(set.succeeded());
                cluster.send(Request.cmd((Command)Command.EXISTS).arg(key1), exists -> {
                    should.assertTrue(exists.succeeded());
                    should.assertEquals((Object)1L, (Object)((Response)exists.result()).toLong());
                    if (counter.incrementAndGet() == 2) {
                        test.complete();
                    }
                });
            });
            cluster.send(Request.cmd((Command)Command.EXISTS).arg(key2), exists -> {
                should.assertTrue(exists.succeeded());
                should.assertEquals((Object)0L, (Object)((Response)exists.result()).toLong());
                if (counter.incrementAndGet() == 2) {
                    test.complete();
                }
            });
        });
    }

    @Test
    public void testExpire(TestContext should) {
        Async test = should.async();
        String key = RedisClusterTest.makeKey();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.SET).arg(key).arg("Hello"), set1 -> {
                should.assertTrue(set1.succeeded());
                cluster.send(Request.cmd((Command)Command.EXPIRE).arg(key).arg(10), expire -> {
                    should.assertTrue(expire.succeeded());
                    should.assertEquals((Object)1L, (Object)((Response)expire.result()).toLong());
                    cluster.send(Request.cmd((Command)Command.TTL).arg(key), ttl1 -> {
                        should.assertTrue(ttl1.succeeded());
                        should.assertEquals((Object)10L, (Object)((Response)ttl1.result()).toLong());
                        cluster.send(Request.cmd((Command)Command.SET).arg(key).arg("Hello World"), set2 -> {
                            should.assertTrue(set2.succeeded());
                            cluster.send(Request.cmd((Command)Command.TTL).arg(key), ttl2 -> {
                                should.assertTrue(ttl2.succeeded());
                                should.assertEquals((Object)-1L, (Object)((Response)ttl2.result()).toLong());
                                test.complete();
                            });
                        });
                    });
                });
            });
        });
    }

    @Test
    public void testExpireAt(TestContext should) {
        Async test = should.async();
        String key = RedisClusterTest.makeKey();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.SET).arg(key).arg("Hello"), set1 -> {
                should.assertTrue(set1.succeeded());
                cluster.send(Request.cmd((Command)Command.EXISTS).arg(key), exists1 -> {
                    should.assertTrue(exists1.succeeded());
                    should.assertEquals((Object)1L, (Object)((Response)exists1.result()).toLong());
                    cluster.send(Request.cmd((Command)Command.EXPIREAT).arg(key).arg(1293840000), expireAt -> {
                        should.assertTrue(expireAt.succeeded());
                        should.assertEquals((Object)1L, (Object)((Response)expireAt.result()).toLong());
                        cluster.send(Request.cmd((Command)Command.EXISTS).arg(key), exists2 -> {
                            should.assertTrue(exists2.succeeded());
                            should.assertEquals((Object)0L, (Object)((Response)exists2.result()).toLong());
                            test.complete();
                        });
                    });
                });
            });
        });
    }

    @Test(timeout=10000L)
    public void testGet(TestContext should) {
        Async test = should.async();
        String key = RedisClusterTest.makeKey();
        String nonExistentKey = "---";
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.GET).arg("---"), get1 -> {
                should.assertTrue(get1.succeeded());
                should.assertNull(get1.result());
                cluster.send(Request.cmd((Command)Command.SET).arg(key).arg("Hello"), set -> {
                    should.assertTrue(set.succeeded());
                    cluster.send(Request.cmd((Command)Command.GET).arg(key), get2 -> {
                        should.assertTrue(get2.succeeded());
                        should.assertEquals((Object)"Hello", (Object)((Response)get2.result()).toString());
                        test.complete();
                    });
                });
            });
        });
    }

    @Test(timeout=30000L)
    public void dbSize(TestContext should) {
        Async test = should.async();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            int len = (int)Math.pow(2.0, 17.0);
            AtomicInteger counter = new AtomicInteger(len);
            for (int i = 0; i < len; ++i) {
                String id = Integer.toString(i);
                cluster.send(Request.cmd((Command)Command.SET).arg(id).arg(id), set -> {
                    should.assertTrue(set.succeeded());
                    if (counter.decrementAndGet() == 0) {
                        cluster.send(Request.cmd((Command)Command.DBSIZE), dbSize -> {
                            should.assertTrue(dbSize.succeeded());
                            should.assertEquals((Object)len, (Object)((Response)dbSize.result()).toInteger());
                            test.complete();
                        });
                    }
                });
            }
        });
    }

    @Test(timeout=30000L)
    public void flushDB(TestContext should) {
        Async test = should.async();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            int len = (int)Math.pow(2.0, 17.0);
            AtomicInteger counter = new AtomicInteger();
            for (int i = 0; i < len; ++i) {
                String id = Integer.toString(i);
                cluster.send(Request.cmd((Command)Command.SET).arg(id).arg(id), set -> should.assertTrue(set.succeeded()));
            }
            cluster.send(Request.cmd((Command)Command.FLUSHDB), flushDb -> {
                should.assertTrue(flushDb.succeeded());
                cluster.send(Request.cmd((Command)Command.DBSIZE), dbSize -> {
                    should.assertTrue(dbSize.succeeded());
                    should.assertEquals((Object)0L, (Object)((Response)dbSize.result()).toLong());
                    test.complete();
                });
            });
        });
    }

    @Test(timeout=30000L)
    public void keys(TestContext should) {
        Async test = should.async();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.MSET).arg("1").arg("1").arg("2").arg("2").arg("3").arg("3").arg("key").arg("value"), mset -> {
                should.assertTrue(mset.succeeded());
                cluster.send(Request.cmd((Command)Command.KEYS).arg("[0-9]"), keys -> {
                    should.assertTrue(keys.succeeded());
                    should.assertEquals((Object)3, (Object)((Response)keys.result()).size());
                    test.complete();
                });
            });
        });
    }

    @Test(timeout=30000L)
    public void mget(TestContext should) {
        Async test = should.async();
        this.client.connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            RedisConnection cluster = (RedisConnection)onCreate.result();
            cluster.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            cluster.send(Request.cmd((Command)Command.SET).arg("key1").arg("Hello"), set1 -> {
                should.assertTrue(set1.succeeded());
                cluster.send(Request.cmd((Command)Command.SET).arg("key2").arg("World"), set2 -> {
                    should.assertTrue(set2.succeeded());
                    cluster.send(Request.cmd((Command)Command.MGET).arg("key1").arg("key2").arg("nonexisting"), mget -> {
                        should.assertTrue(mget.succeeded());
                        should.assertEquals((Object)3, (Object)((Response)mget.result()).size());
                        ArrayList values = new ArrayList();
                        ((Response)mget.result()).forEach(value -> {
                            if (value != null) {
                                values.add(value.toString());
                            } else {
                                values.add(null);
                            }
                        });
                        should.assertTrue(values.contains("Hello"));
                        should.assertTrue(values.contains("World"));
                        should.assertTrue(values.contains(null));
                        test.complete();
                    });
                });
            });
        });
    }

    @Test(timeout=30000L)
    public void evalSingleKey(TestContext should) {
        Async test = should.async();
        String key = "{hash_tag}.some-key";
        String argv = "some-value";
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)this.options).connect(should.asyncAssertSuccess(cluster -> cluster.send(Request.cmd((Command)Command.EVAL).arg("return redis.call('SET', KEYS[1], ARGV[1])").arg(1).arg("{hash_tag}.some-key").arg("some-value"), should.asyncAssertSuccess(response -> {
            should.assertEquals((Object)"OK", (Object)response.toString());
            test.complete();
        }))));
    }

    @Test(timeout=30000L)
    public void evalSingleKeyBatch(TestContext should) {
        Async test = should.async();
        String key = "{hash_tag}.some-key";
        String argv = "some-value";
        Request req = Request.cmd((Command)Command.EVAL).arg("return redis.call('SET', KEYS[1], ARGV[1])").arg(1).arg("{hash_tag}.some-key").arg("some-value");
        ArrayList<Request> cmdList = new ArrayList<Request>();
        cmdList.add(req);
        cmdList.add(req);
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)this.options).connect(should.asyncAssertSuccess(cluster -> cluster.batch(cmdList, should.asyncAssertSuccess(response -> {
            should.assertEquals((Object)2, (Object)response.size());
            response.forEach(r -> should.assertEquals((Object)"OK", (Object)r.toString()));
            test.complete();
        }))));
    }

    @Test(timeout=30000L)
    public void evalMultiKey(TestContext should) {
        Async test = should.async();
        String key1 = "{hash_tag}.some-key";
        String argv1 = "some-value";
        String key2 = "{hash_tag}.other-key";
        String argv2 = "other-value";
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)this.options).connect(should.asyncAssertSuccess(cluster -> cluster.send(Request.cmd((Command)Command.EVAL).arg("local r1 = redis.call('SET', KEYS[1], ARGV[1]) \nlocal r2 = redis.call('SET', KEYS[2], ARGV[2]) \nreturn {r1, r2}").arg(2).arg("{hash_tag}.some-key").arg("{hash_tag}.other-key").arg("some-value").arg("other-value"), should.asyncAssertSuccess(response -> {
            should.assertEquals((Object)2, (Object)response.size());
            response.forEach(r -> should.assertEquals((Object)"OK", (Object)r.toString()));
            test.complete();
        }))));
    }

    @Test(timeout=30000L)
    public void evalMultiKeyDifferentSlots(TestContext should) {
        Async test = should.async();
        String key1 = "{hash_tag}.some-key";
        String argv1 = "some-value";
        String key2 = "{other_hash_tag}.other-key";
        String argv2 = "other-value";
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)this.options).connect(should.asyncAssertSuccess(cluster -> cluster.send(Request.cmd((Command)Command.EVAL).arg("local r1 = redis.call('SET', KEYS[1], ARGV[1]) \nlocal r2 = redis.call('SET', KEYS[2], ARGV[2]) \nreturn {r1, r2}").arg(2).arg("{hash_tag}.some-key").arg("{other_hash_tag}.other-key").arg("some-value").arg("other-value"), should.asyncAssertFailure(throwable -> {
            should.assertTrue(throwable.getMessage().startsWith("Keys of command or batch"));
            test.complete();
        }))));
    }

    @Test(timeout=30000L)
    public void evalSingleKeyDifferentSlotsBatch(TestContext should) {
        Async test = should.async();
        String argv = "some-value";
        ArrayList<Request> cmdList = new ArrayList<Request>();
        cmdList.add(Request.cmd((Command)Command.EVAL).arg("return redis.call('SET', KEYS[1], ARGV[1])").arg(1).arg("{hash_tag}.some-key").arg("some-value"));
        cmdList.add(Request.cmd((Command)Command.EVAL).arg("return redis.call('SET', KEYS[1], ARGV[1])").arg(1).arg("{other_hash_tag}.some-key").arg("some-value"));
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)this.options).connect(should.asyncAssertSuccess(cluster -> cluster.batch(cmdList, should.asyncAssertFailure(throwable -> {
            should.assertTrue(throwable.getMessage().startsWith("Keys of command or batch"));
            test.complete();
        }))));
    }

    @Test(timeout=30000L)
    public void setAndWait(TestContext should) {
        int runs = 10;
        Async test = should.async(10);
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)this.options).connect(should.asyncAssertSuccess(cluster -> {
            for (int i = 0; i < 10; ++i) {
                cluster.send(Request.cmd((Command)Command.SET).arg("key").arg("value"), should.asyncAssertSuccess(setResponse -> {
                    should.assertEquals((Object)"OK", (Object)setResponse.toString().toUpperCase());
                    cluster.send(Request.cmd((Command)Command.WAIT).arg(1).arg(2000), should.asyncAssertSuccess(waitResponse -> {
                        should.assertEquals((Object)1, (Object)waitResponse.toInteger());
                        test.countDown();
                    }));
                }));
            }
        }));
    }

    @Test(timeout=30000L)
    public void setAndWaitBatch(TestContext should) {
        int runs = 10;
        Async test = should.async(10);
        ArrayList<Request> cmdList = new ArrayList<Request>();
        cmdList.add(Request.cmd((Command)Command.SET).arg("key").arg("value"));
        cmdList.add(Request.cmd((Command)Command.WAIT).arg(1).arg(2000));
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)this.options).connect(should.asyncAssertSuccess(cluster -> {
            for (int i = 0; i < 10; ++i) {
                cluster.batch(cmdList, should.asyncAssertSuccess(responses -> {
                    should.assertEquals((Object)2, (Object)responses.size());
                    Response setResponse = (Response)responses.get(0);
                    should.assertEquals((Object)"OK", (Object)setResponse.toString().toUpperCase());
                    Response waitResponse = (Response)responses.get(1);
                    should.assertEquals((Object)1, (Object)waitResponse.toInteger());
                    test.countDown();
                }));
            }
        }));
    }
}

