/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.test;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RedisPooledTest {
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();

    @Test
    public void simpleTest(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://localhost:7006").send(Request.cmd((Command)Command.PING), send -> {
            should.assertTrue(send.succeeded());
            should.assertNotNull(send.result());
            should.assertEquals((Object)"PONG", (Object)((Response)send.result()).toString());
            test.complete();
        });
    }

    @Test
    public void emptyStringTest(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://localhost:7006").send(Request.cmd((Command)Command.SET).arg(UUID.randomUUID().toString()).arg(""), send -> {
            should.assertTrue(send.succeeded());
            should.assertNotNull(send.result());
            should.assertEquals((Object)"OK", (Object)((Response)send.result()).toString());
            test.complete();
        });
    }

    @Test
    public void simpleSelectTest(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)new RedisOptions().addEndpoint("redis://localhost:7006/0")).send(Request.cmd((Command)Command.PING), send -> {
            should.assertTrue(send.succeeded());
            should.assertNotNull(send.result());
            should.assertEquals((Object)"PONG", (Object)((Response)send.result()).toString());
            test.complete();
        });
    }

    @Test
    public void batchTest(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://localhost:7006").batch(Arrays.asList(Request.cmd((Command)Command.MULTI), Request.cmd((Command)Command.SET).arg("a").arg(3), Request.cmd((Command)Command.LPOP).arg("a"), Request.cmd((Command)Command.EXEC)), batch -> {
            should.assertTrue(batch.succeeded());
            test.complete();
        });
    }

    @Test
    public void simpleTestAPI(TestContext should) {
        Async test = should.async();
        RedisAPI redis = RedisAPI.api((Redis)Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://localhost:7006"));
        redis.set(Arrays.asList("key1", "value1"), set -> {
            should.assertTrue(set.succeeded());
            should.assertNotNull(set.result());
            should.assertEquals((Object)"OK", (Object)((Response)set.result()).toString());
            test.complete();
        });
    }

    @Test
    public void simpleStream(TestContext should) {
        AtomicInteger cnt = new AtomicInteger(5);
        Async test = should.async();
        Vertx vertx = this.rule.vertx();
        RedisAPI redis = RedisAPI.api((Redis)Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)new RedisOptions().setMaxPoolWaiting(8).setEndpoint("redis://localhost:7006")));
        IntStream.range(0, 5).forEach(i -> vertx.setTimer(1L, timerid -> {
            redis.set(Arrays.asList("foo", "bar"), res -> {});
            redis.get("redis_test", res -> {
                if (res.failed()) {
                    should.fail(res.cause());
                } else {
                    should.assertNull(res.result());
                }
                if (cnt.decrementAndGet() == 0) {
                    test.complete();
                }
            });
        }));
    }

    @Test(timeout=30000L)
    public void acquireConnectionsTest(TestContext should) {
        Vertx vertx = this.rule.vertx();
        Async test = should.async();
        Redis client = Redis.createClient((Vertx)vertx, (RedisOptions)new RedisOptions().addConnectionString("redis://localhost:7006").setMaxPoolSize(5).setMaxPoolWaiting(10));
        AtomicInteger counter = new AtomicInteger();
        AtomicBoolean done = new AtomicBoolean();
        vertx.setPeriodic(500L, event -> {
            counter.incrementAndGet();
            client.connect(event1 -> {
                if (event1.succeeded()) {
                    should.assertTrue(counter.get() <= 5);
                } else {
                    should.assertTrue(counter.get() == 16);
                    vertx.cancelTimer(event.longValue());
                    if (done.compareAndSet(false, true)) {
                        test.complete();
                    }
                }
            });
        });
    }
}

