/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.test;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.ResponseType;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RedisPubSubTest {
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();
    private RedisConnection pub;
    private RedisConnection sub;

    @Before
    public void setUp(TestContext should) {
        Async setUp = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://127.0.0.1:7006").connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            this.pub = (RedisConnection)onCreate.result();
            this.pub.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://127.0.0.1:7006").connect(onCreate2 -> {
                should.assertTrue(onCreate2.succeeded());
                this.sub = (RedisConnection)onCreate2.result();
                this.sub.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
                setUp.complete();
            });
        });
    }

    @After
    public void tearDown() {
        this.pub.close();
        this.sub.close();
    }

    @Test
    public void simpleTest(TestContext should) {
        Async test = should.async();
        AtomicInteger psubscribeCnt = new AtomicInteger(0);
        AtomicInteger pmessageCnt = new AtomicInteger(0);
        this.sub.handler(message -> {
            System.out.println(message);
            should.assertTrue(message.type() == ResponseType.MULTI);
            if (message.get(0).toString().equals("message")) {
                should.assertEquals((Object)3, (Object)message.size());
                pmessageCnt.incrementAndGet();
            }
            if (message.get(0).toString().equals("subscribe")) {
                should.assertEquals((Object)3, (Object)message.size());
                psubscribeCnt.incrementAndGet();
            }
            if (psubscribeCnt.get() + pmessageCnt.get() == 2) {
                test.complete();
            }
        });
        this.sub.send(Request.cmd((Command)Command.SUBSCRIBE).arg("mychannel"), subscribe -> {
            should.assertTrue(subscribe.succeeded());
            this.rule.vertx().setTimer(100L, t -> this.pub.send(Request.cmd((Command)Command.PUBLISH).arg("mychannel").arg(123456), publish -> {
                should.assertTrue(publish.succeeded());
                should.assertNotNull(publish.result());
            }));
        });
    }

    @Test
    public void simpleMultiplePsubTest(TestContext should) {
        Async test = should.async();
        AtomicInteger psubscribeCnt = new AtomicInteger(0);
        AtomicInteger pmessageCnt = new AtomicInteger(0);
        this.sub.handler(message -> {
            System.out.println(message);
            should.assertTrue(message.type() == ResponseType.MULTI);
            if (message.get(0).toString().equals("pmessage")) {
                should.assertEquals((Object)4, (Object)message.size());
                pmessageCnt.incrementAndGet();
            }
            if (message.get(0).toString().equals("psubscribe")) {
                should.assertEquals((Object)3, (Object)message.size());
                psubscribeCnt.incrementAndGet();
            }
            if (psubscribeCnt.get() + pmessageCnt.get() == 12) {
                test.complete();
            }
        });
        final String REDIS_KEYSPACE_EVENT_CHANNEL_SET = "__keyspace@0__:";
        HashSet<String> patterns = new HashSet<String>(){
            {
                this.add(REDIS_KEYSPACE_EVENT_CHANNEL_SET + "A*");
                this.add(REDIS_KEYSPACE_EVENT_CHANNEL_SET + "B*");
                this.add(REDIS_KEYSPACE_EVENT_CHANNEL_SET + "C*");
                this.add(REDIS_KEYSPACE_EVENT_CHANNEL_SET + "D*");
                this.add(REDIS_KEYSPACE_EVENT_CHANNEL_SET + "E*");
                this.add(REDIS_KEYSPACE_EVENT_CHANNEL_SET + "F*");
            }
        };
        Request psub_request = Request.cmd((Command)Command.PSUBSCRIBE);
        patterns.stream().forEach(arg_0 -> ((Request)psub_request).arg(arg_0));
        this.sub.send(psub_request, subscribe -> {
            should.assertTrue(subscribe.succeeded());
            this.rule.vertx().setTimer(100L, t -> patterns.stream().forEach(p -> this.pub.send(Request.cmd((Command)Command.PUBLISH).arg(p).arg(System.nanoTime()), publish -> {
                should.assertTrue(publish.succeeded());
                should.assertNotNull(publish.result());
            })));
        });
    }
}

