/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.test;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisClientType;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.RedisRole;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RedisSentinelTest {
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();

    @Test
    public void testGetClientToMaster(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)new RedisOptions().setType(RedisClientType.SENTINEL).addConnectionString("redis://localhost:5000").addConnectionString("redis://localhost:5001").addConnectionString("redis://localhost:5002").setMasterName("sentinel7000").setRole(RedisRole.MASTER).setMaxPoolSize(4).setMaxPoolWaiting(16)).connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            ((RedisConnection)onCreate.result()).send(Request.cmd((Command)Command.INFO), info -> {
                should.assertTrue(info.succeeded());
                should.assertTrue(((Response)info.result()).toString().contains("tcp_port:7000"));
                test.complete();
            });
        });
    }

    @Test
    public void testGetClientToSlave(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)new RedisOptions().setType(RedisClientType.SENTINEL).addConnectionString("redis://localhost:5000").addConnectionString("redis://localhost:5001").addConnectionString("redis://localhost:5002").setMasterName("sentinel7000").setRole(RedisRole.SLAVE).setMaxPoolSize(4).setMaxPoolWaiting(16)).connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            ((RedisConnection)onCreate.result()).send(Request.cmd((Command)Command.INFO), info -> {
                should.assertTrue(info.succeeded());
                should.assertTrue(((Response)info.result()).toString().contains("tcp_port:700"));
                test.complete();
            });
        });
    }

    @Test
    public void testGetClientToSentinel(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)new RedisOptions().setType(RedisClientType.SENTINEL).addConnectionString("redis://localhost:5000").addConnectionString("redis://localhost:5001").addConnectionString("redis://localhost:5002").setMasterName("sentinel7000").setRole(RedisRole.SENTINEL).setMaxPoolSize(4).setMaxPoolWaiting(16)).connect(onCreate -> {
            should.assertTrue(onCreate.succeeded());
            ((RedisConnection)onCreate.result()).send(Request.cmd((Command)Command.INFO), info -> {
                should.assertTrue(info.succeeded());
                String res = ((Response)info.result()).toString();
                System.out.println(res);
                should.assertTrue(res.contains("tcp_port:5000") || res.contains("tcp_port:5001") || res.contains("tcp_port:5002"));
                test.complete();
            });
        });
    }
}

