/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.client.test;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.redis.client.Command;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Request;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RedisTest {
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();

    @Test
    public void simpleTest(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://localhost:7006").connect(create -> {
            should.assertTrue(create.succeeded());
            RedisConnection redis = (RedisConnection)create.result();
            redis.exceptionHandler(ex -> {});
            redis.send(Request.cmd((Command)Command.PING), send -> {
                should.assertTrue(send.succeeded());
                should.assertNotNull(send.result());
                should.assertEquals((Object)"PONG", (Object)((Response)send.result()).toString());
                test.complete();
            });
        });
    }

    @Test
    public void emptyStringTest(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://localhost:7006").connect(create -> {
            should.assertTrue(create.succeeded());
            RedisConnection redis = (RedisConnection)create.result();
            redis.exceptionHandler(arg_0 -> ((TestContext)should).fail(arg_0));
            redis.send(Request.cmd((Command)Command.SET).arg(UUID.randomUUID().toString()).arg(""), send -> {
                should.assertTrue(send.succeeded());
                should.assertNotNull(send.result());
                should.assertEquals((Object)"OK", (Object)((Response)send.result()).toString());
                test.complete();
            });
        });
    }

    @Test
    public void simpleSelectTest(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)new RedisOptions().addConnectionString("redis://localhost:7006/0")).connect(create -> {
            should.assertTrue(create.succeeded());
            RedisConnection redis = (RedisConnection)create.result();
            redis.exceptionHandler(ex -> {});
            redis.send(Request.cmd((Command)Command.PING), send -> {
                should.assertTrue(send.succeeded());
                should.assertNotNull(send.result());
                should.assertEquals((Object)"PONG", (Object)((Response)send.result()).toString());
                test.complete();
            });
        });
    }

    @Test
    public void batchTest(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://localhost:7006").connect(create -> {
            should.assertTrue(create.succeeded());
            RedisConnection redis = (RedisConnection)create.result();
            redis.batch(Arrays.asList(Request.cmd((Command)Command.MULTI), Request.cmd((Command)Command.SET).arg("a").arg(3), Request.cmd((Command)Command.LPOP).arg("a"), Request.cmd((Command)Command.EXEC)), batch -> {
                should.assertTrue(batch.succeeded());
                test.complete();
            });
        });
    }

    @Test
    public void simpleTestAPI(TestContext should) {
        Async test = should.async();
        Redis.createClient((Vertx)this.rule.vertx(), (String)"redis://localhost:7006").connect(create -> {
            should.assertTrue(create.succeeded());
            RedisAPI redis = RedisAPI.api((RedisConnection)((RedisConnection)create.result()));
            redis.set(Arrays.asList("key1", "value1"), set -> {
                should.assertTrue(set.succeeded());
                should.assertNotNull(set.result());
                should.assertEquals((Object)"OK", (Object)((Response)set.result()).toString());
                test.complete();
            });
        });
    }

    @Test
    public void simpleStream(TestContext should) {
        AtomicInteger cnt = new AtomicInteger(100);
        Async test = should.async();
        Vertx vertx = this.rule.vertx();
        Redis.createClient((Vertx)vertx, (String)"redis://localhost:7006").connect(create -> {
            should.assertTrue(create.succeeded());
            RedisAPI redis = RedisAPI.api((RedisConnection)((RedisConnection)create.result()));
            IntStream.range(0, 100).forEach(i -> vertx.setTimer(1L, timerid -> {
                redis.set(Arrays.asList("foo", "bar"), res -> {});
                redis.get("redis_test", res -> {
                    if (res.failed()) {
                        should.fail(res.cause());
                    } else {
                        should.assertNull(res.result());
                    }
                    if (cnt.decrementAndGet() == 0) {
                        test.complete();
                    }
                });
            }));
        });
    }

    @Test(timeout=10000L)
    public void simpleFullQueue(TestContext should) {
        Async test = should.async();
        Vertx vertx = this.rule.vertx();
        RedisOptions options = new RedisOptions().setMaxWaitingHandlers(10).addConnectionString("redis://localhost:7006");
        Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)options).connect(create -> {
            should.assertTrue(create.succeeded());
            RedisConnection redis = (RedisConnection)create.result();
            RedisAPI redisApi = RedisAPI.api((RedisConnection)redis);
            AtomicInteger cnt = new AtomicInteger();
            ArrayList futures = new ArrayList();
            IntStream.range(0, 100).forEach(i -> {
                Promise p = Promise.promise();
                vertx.setTimer(1L, timerid -> redisApi.set(Arrays.asList("foo", "bar"), (Handler)p));
                futures.add(p.future().map(res -> {
                    System.out.println("SUCCESS " + cnt.incrementAndGet());
                    return null;
                }));
            });
            CompositeFuture.all(futures).onFailure(f -> {
                should.assertEquals((Object)"Redis waiting Queue is full", (Object)f.getMessage());
                test.complete();
            }).onSuccess(r -> {
                if (cnt.get() == 100) {
                    should.fail("Should not succeed!");
                }
            });
        });
    }
}

