/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.redis.client.impl.ZModem;
import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;

public class ZModemTest {
    @Test
    public void testGenerate() {
        Assert.assertEquals((long)12325L, (long)ZModem.generate((String)"foobar"));
        Assert.assertEquals((long)9132L, (long)ZModem.generate((String)"abcdefghijklmnopqrstuvwxyz"));
        Assert.assertEquals((long)15532L, (long)ZModem.generate((String)"gsdfhan$%^&*(sdgsdnhshcs"));
        Assert.assertEquals((long)12325L, (long)ZModem.generate((String)"abc{foobar}"));
        Assert.assertEquals((long)12325L, (long)ZModem.generate((String)"{foobar}"));
        Assert.assertEquals((long)12325L, (long)ZModem.generate((String)"h8a9sd{foobar}}{asd}}"));
        Assert.assertEquals((long)16235L, (long)ZModem.generate((String)"{foobar"));
        Assert.assertEquals((long)4435L, (long)ZModem.generate((String)"foobar{}"));
        Assert.assertEquals((long)16235L, (long)ZModem.generate((String)"{{foobar}"));
        Assert.assertEquals((long)13690L, (long)ZModem.generate((String)"\u00e9\u00eae"));
        Assert.assertEquals((long)3872L, (long)ZModem.generate((String)"\u00e0\u00e2a"));
        Assert.assertEquals((long)14191L, (long)ZModem.generate((String)"\u6f22\u5b57"));
        Assert.assertEquals((long)16196L, (long)ZModem.generate((String)"\u6c49\u5b57"));
        Assert.assertEquals((long)4350L, (long)ZModem.generate((String)"\ud638\ud154"));
        Assert.assertEquals((long)9284L, (long)ZModem.generate((String)"\ud83d\udc80"));
        Assert.assertEquals((long)11620L, (long)ZModem.generate((String)"\ud800\udc00"));
    }

    @Test
    public void testGenerateMulti() {
        Assert.assertEquals((long)9132L, (long)ZModem.generateMulti(Arrays.asList("abcdefghijklmnopqrstuvwxyz", "abcdefghijklmnopqrstuvwxyz", "abcdefghijklmnopqrstuvwxyz", "abcdefghijklmnopqrstuvwxyz", "abcdefghijklmnopqrstuvwxyz", "abcdefghijklmnopqrstuvwxyz", "abcdefghijklmnopqrstuvwxyz", "abcdefghijklmnopqrstuvwxyz")));
    }

    @Test
    public void testAll() {
        HashSet<Integer> slots = new HashSet<Integer>();
        int i = 0;
        while ((double)i < Math.pow(2.0, 17.0)) {
            slots.add(ZModem.generate((String)("" + i)));
            ++i;
        }
        Assert.assertEquals((long)16384L, (long)slots.size());
    }
}

