/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.core.Vertx;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import java.util.UUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RedisClientPubSubTest {
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();
    private RedisClient redisPublish;
    private RedisClient redisSubscribe;

    @Before
    public void before() {
        this.redisPublish = RedisClient.create((Vertx)this.rule.vertx(), (RedisOptions)new RedisOptions().setPort(7006));
        this.redisSubscribe = RedisClient.create((Vertx)this.rule.vertx(), (RedisOptions)new RedisOptions().setPort(7006));
    }

    @After
    public void after(TestContext should) {
        this.redisPublish.close(null);
        this.redisSubscribe.close(null);
    }

    private static String makeKey() {
        return UUID.randomUUID().toString();
    }

    @Test
    public void testPublishSubscribe(TestContext should) {
        Async test = should.async();
        String key = RedisClientPubSubTest.makeKey();
        this.redisSubscribe.subscribe(key, reply -> {
            should.assertTrue(reply.succeeded());
            this.rule.vertx().eventBus().consumer("io.vertx.redis." + key, msg -> test.complete());
            this.redisPublish.publish(key, "foo", preply -> should.assertTrue(preply.succeeded()));
        });
    }
}

