/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.test.redis;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.http.impl.pool.ConnectionListener;
import io.vertx.core.json.JsonArray;
import io.vertx.core.net.NetSocket;
import io.vertx.ext.unit.Async;
import io.vertx.ext.unit.TestContext;
import io.vertx.ext.unit.junit.RunTestOnContext;
import io.vertx.ext.unit.junit.VertxUnitRunner;
import io.vertx.redis.client.Redis;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.RedisConnection;
import io.vertx.redis.client.RedisOptions;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.RedisConnectionImpl;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=VertxUnitRunner.class)
public class RedisClientTest {
    @Rule
    public RunTestOnContext rule = new RunTestOnContext();
    private Redis client;
    private RedisAPI redis;

    @Before
    public void before(TestContext should) {
        Async before = should.async();
        Context context = this.rule.vertx().getOrCreateContext();
        this.client = Redis.createClient((Vertx)this.rule.vertx(), (RedisOptions)new RedisOptions().setConnectionString("redis://localhost:7006"));
        this.client.connect(onConnect -> {
            should.assertTrue(onConnect.succeeded());
            should.assertEquals((Object)context, (Object)this.rule.vertx().getOrCreateContext());
            this.redis = RedisAPI.api((RedisConnection)((RedisConnection)onConnect.result()));
            before.complete();
        });
    }

    @After
    public void after() {
        this.client.close();
    }

    private static String getProperty(String name) {
        String s = System.getProperty(name);
        return s != null && s.trim().length() > 0 ? s : null;
    }

    private static JsonArray toJsonArray(Object ... params) {
        return params != null ? new JsonArray(Arrays.asList(params)) : null;
    }

    private static Object[] toArray(Object ... params) {
        return params;
    }

    private static String errorMessage(Throwable t) {
        return t != null ? t.getMessage() : "";
    }

    private static String makeKey() {
        return UUID.randomUUID().toString();
    }

    private static Map<String, Object> toMap(String ... params) {
        if (params.length % 2 != 0) {
            throw new IllegalArgumentException("Last key has no value");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        String key = null;
        for (String param : params) {
            if (key == null) {
                key = param;
                continue;
            }
            result.put(key, param);
            key = null;
        }
        return result;
    }

    @SafeVarargs
    private static <T> List<T> toList(T ... params) {
        return Arrays.asList(params);
    }

    private static Field getAccessibleField(Class<?> clazz, String name) throws NoSuchFieldException {
        Field field = clazz.getDeclaredField(name);
        field.setAccessible(true);
        return field;
    }

    @Test
    public void testConnectionClose(TestContext should) {
        final Async before = should.async();
        Context context = this.rule.vertx().getOrCreateContext();
        this.client.connect(onConnect -> {
            should.assertTrue(onConnect.succeeded());
            should.assertEquals((Object)context, (Object)this.rule.vertx().getOrCreateContext());
            RedisConnection conn = (RedisConnection)onConnect.result();
            try {
                Field listenerField = RedisClientTest.getAccessibleField(RedisConnectionImpl.class, "listener");
                final ConnectionListener originalListener = (ConnectionListener)listenerField.get(conn);
                listenerField.set(conn, new ConnectionListener<RedisConnection>(){

                    public void onConcurrencyChange(long concurrency) {
                        originalListener.onConcurrencyChange(concurrency);
                    }

                    public void onRecycle() {
                        originalListener.onRecycle();
                    }

                    public void onEvict() {
                        originalListener.onEvict();
                        before.complete();
                    }
                });
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                should.fail((Throwable)e);
            }
            try {
                Field socketField = RedisClientTest.getAccessibleField(RedisConnectionImpl.class, "netSocket");
                NetSocket socket = (NetSocket)socketField.get(conn);
                socket.close();
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                should.fail((Throwable)e);
            }
        });
    }

    @Test
    public void testContextReturn(TestContext should) {
        Async test = should.async();
        Context context = this.rule.vertx().getOrCreateContext();
        this.redis.append(RedisClientTest.makeKey(), "Hello", reply1 -> {
            should.assertEquals((Object)context, (Object)this.rule.vertx().getOrCreateContext());
            test.complete();
        });
    }

    @Test
    public void testAppend(TestContext should) {
        Async test = should.async();
        String key = RedisClientTest.makeKey();
        this.redis.del(RedisClientTest.toList(key), reply0 -> {
            should.assertTrue(reply0.succeeded());
            this.redis.append(key, "Hello", reply1 -> {
                should.assertTrue(reply1.succeeded());
                should.assertEquals((Object)5L, (Object)((Response)reply1.result()).toLong());
                this.redis.append(key, " World", reply2 -> {
                    should.assertTrue(reply2.succeeded());
                    should.assertEquals((Object)11L, (Object)((Response)reply2.result()).toLong());
                    this.redis.get(key, reply3 -> {
                        should.assertTrue(reply3.succeeded());
                        should.assertTrue(reply3.succeeded());
                        should.assertEquals((Object)"Hello World", (Object)((Response)reply3.result()).toString());
                        test.complete();
                    });
                });
            });
        });
    }

    @Test
    public void testBgrewriteaof(TestContext should) {
        Async test = should.async();
        this.redis.bgrewriteaof(reply -> {
            should.assertTrue(reply.succeeded());
            test.complete();
        });
    }

    @Test
    public void testBgsave(TestContext should) {
        Async test = should.async();
        this.redis.bgsave(RedisClientTest.toList("SCHEDULE"), reply -> {
            should.assertTrue(reply.succeeded());
            should.assertNotNull((Object)((Response)reply.result()).toString());
            should.assertTrue(((Response)reply.result()).toString().startsWith("Background saving"));
            test.complete();
        });
    }

    @Test
    public void testBitcount(TestContext should) {
        Async test = should.async();
        String key = RedisClientTest.makeKey();
        this.redis.set(RedisClientTest.toList(key, "foobar"), reply0 -> {
            should.assertTrue(reply0.succeeded());
            this.redis.bitcount(RedisClientTest.toList(key), reply1 -> {
                should.assertTrue(reply1.succeeded());
                should.assertEquals((Object)26L, (Object)((Response)reply1.result()).toLong());
                this.redis.bitcount(RedisClientTest.toList(key, "0", "0"), reply2 -> {
                    should.assertTrue(reply2.succeeded());
                    should.assertEquals((Object)4L, (Object)((Response)reply2.result()).toLong());
                    this.redis.bitcount(RedisClientTest.toList(key, "1", "1"), reply3 -> {
                        should.assertTrue(reply3.succeeded());
                        should.assertEquals((Object)6L, (Object)((Response)reply3.result()).toLong());
                        test.complete();
                    });
                });
            });
        });
    }

    @Test
    public void testBitop(TestContext should) {
        Async test = should.async();
        String key1 = RedisClientTest.makeKey();
        String key2 = RedisClientTest.makeKey();
        String destkey = RedisClientTest.makeKey();
        this.redis.set(RedisClientTest.toList(key1, "foobar"), reply0 -> {
            should.assertTrue(reply0.succeeded());
            this.redis.set(RedisClientTest.toList(key2, "abcdef"), reply1 -> {
                should.assertTrue(reply1.succeeded());
                this.redis.bitop(RedisClientTest.toList("AND", destkey, key1, key2), reply2 -> {
                    should.assertTrue(reply2.succeeded());
                    this.redis.get(destkey, reply3 -> {
                        should.assertTrue(reply3.succeeded());
                        test.complete();
                    });
                });
            });
        });
    }
}

